/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_787;

public class UnlitQuadHooks {
    private static final int LIGHT_OFFSET = UnlitQuadHooks.getLightOffset();
    private static final int UNLIT_LIGHT_UV = class_765.method_23687((int)15, (int)15);
    private static final ThreadLocal<Boolean> ENABLE_UNLIT_EXTENSIONS = new ThreadLocal();

    public static void beginDeserializingModel(class_2960 location) {
        String namespace = location.method_12836();
        if (namespace.equals("ae2")) {
            ENABLE_UNLIT_EXTENSIONS.set(true);
        }
    }

    public static void endDeserializingModel() {
        ENABLE_UNLIT_EXTENSIONS.set(false);
    }

    public static boolean isUnlitExtensionEnabled() {
        Boolean b = ENABLE_UNLIT_EXTENSIONS.get();
        return b != null && b != false;
    }

    public static class_783 enhanceModelElementFace(class_783 modelElement, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (class_3518.method_15258((JsonObject)jsonObject, (String)"unlit", (boolean)false)) {
            return new UnlitBlockPartFace(modelElement.field_4225, modelElement.field_4226, modelElement.field_4224, modelElement.field_4227);
        }
        return modelElement;
    }

    public static class_777 makeUnlit(class_777 quad) {
        int[] vertexData = (int[])quad.method_3357().clone();
        int stride = class_290.field_1590.method_1359();
        for (int i = 0; i < 4; ++i) {
            vertexData[stride * i + UnlitQuadHooks.LIGHT_OFFSET] = UNLIT_LIGHT_UV;
        }
        class_1058 sprite = quad.method_35788();
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), sprite, false);
    }

    private static int getLightOffset() {
        class_293 format = class_290.field_1590;
        int offset = 0;
        for (class_296 element : format.method_1357()) {
            if (element == class_290.field_20886) {
                if (element.method_1386() != class_296.class_297.field_1625) {
                    throw new UnsupportedOperationException("Expected light map format to be of type SHORT");
                }
                if (offset % 4 != 0) {
                    throw new UnsupportedOperationException("Expected light map offset to be 4-byte aligned");
                }
                return offset / 4;
            }
            offset += element.method_1387();
        }
        throw new UnsupportedOperationException("Failed to find the lightmap index in the block vertex format");
    }

    public static class UnlitBlockPartFace
    extends class_783 {
        public UnlitBlockPartFace(class_2350 cullFaceIn, int tintIndexIn, String textureIn, class_787 blockFaceUVIn) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
        }
    }
}

