/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.util.DimensionalBlockPos;
import appeng.block.misc.TinyTNTBlock;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2530;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class EntropyManipulatorItem
extends AEBasePoweredItem
implements IBlockTool {
    public static final int ENERGY_PER_USE = 1600;

    public EntropyManipulatorItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getEntropyManipulatorBattery(), props);
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 800.0;
    }

    public boolean method_7873(class_1799 item, class_1309 target, class_1309 hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            target.method_5639(8);
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 p, class_1268 hand) {
        class_3965 target = EntropyManipulatorItem.method_7872((class_1937)level, (class_1657)p, (class_3959.class_242)class_3959.class_242.field_1347);
        if (target.method_17783() != class_239.class_240.field_1332) {
            return new class_1271(class_1269.field_5814, (Object)p.method_5998(hand));
        }
        class_2338 pos = target.method_17777();
        class_2680 state = level.method_8320(pos);
        if (!state.method_26227().method_15769() && Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
            class_1838 context = new class_1838(p, hand, target);
            this.method_7884(context);
        }
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)p.method_5998(hand));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_3965 target;
        class_1937 level = context.method_8045();
        class_1799 item = context.method_8041();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1657 p = context.method_8036();
        boolean tryBoth = false;
        if (p == null) {
            if (level.field_9236) {
                return class_1269.field_5814;
            }
            p = Platform.getFakePlayer((class_3218)level, null);
            tryBoth = true;
        }
        if ((target = EntropyManipulatorItem.method_7872((class_1937)level, (class_1657)p, (class_3959.class_242)class_3959.class_242.field_1347)).method_17783() == class_239.class_240.field_1332) {
            pos = target.method_17777();
        }
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.method_7343(pos, side, item)) {
                return class_1269.field_5814;
            }
            if (!level.method_8608() && !this.tryApplyEffect(level, item, pos, side, p, tryBoth)) {
                return class_1269.field_5814;
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    private boolean tryApplyEffect(class_1937 level, class_1799 item, class_2338 pos, class_2350 side, class_1657 p, boolean tryBoth) {
        EntropyRecipe coolRecipe;
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        class_3610 fluidState = level.method_8316(pos);
        if ((tryBoth || InteractionUtil.isInAlternateUseMode(p)) && (coolRecipe = EntropyManipulatorItem.findRecipe(level, EntropyMode.COOL, blockState, fluidState)) != null) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            EntropyManipulatorItem.applyRecipe(coolRecipe, level, pos, blockState, fluidState);
            return true;
        }
        if (tryBoth || !InteractionUtil.isInAlternateUseMode(p)) {
            if (block instanceof class_2530) {
                class_2530 tntBlock = (class_2530)block;
                tntBlock.method_9576(level, pos, level.method_8320(pos), p);
                level.method_8650(pos, false);
                return true;
            }
            if (block instanceof TinyTNTBlock) {
                level.method_8650(pos, false);
                ((TinyTNTBlock)block).startFuse(level, pos, (class_1309)p);
                return true;
            }
            EntropyRecipe heatRecipe = EntropyManipulatorItem.findRecipe(level, EntropyMode.HEAT, blockState, fluidState);
            if (heatRecipe != null) {
                this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                EntropyManipulatorItem.applyRecipe(heatRecipe, level, pos, blockState, fluidState);
                return true;
            }
            if (this.performInWorldSmelting(item, level, p, pos, block)) {
                return true;
            }
            if (this.applyFlintAndSteelEffect(level, item, pos, side, p)) {
                return true;
            }
        }
        return false;
    }

    private boolean applyFlintAndSteelEffect(class_1937 level, class_1799 item, class_2338 pos, class_2350 side, class_1657 p) {
        class_2338 offsetPos = pos.method_10093(side);
        if (!p.method_7343(offsetPos, side, item)) {
            return false;
        }
        if (level.method_22347(offsetPos)) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            level.method_43128(p, (double)offsetPos.method_10263() + 0.5, (double)offsetPos.method_10264() + 0.5, (double)offsetPos.method_10260() + 0.5, class_3417.field_15145, class_3419.field_15248, 1.0f, level.field_9229.method_43057() * 0.4f + 0.8f);
            level.method_8501(offsetPos, class_2246.field_10036.method_9564());
        }
        return true;
    }

    private boolean performInWorldSmelting(class_1799 item, class_1937 level, class_1657 p, class_2338 pos, class_2248 block) {
        class_2680 state = level.method_8320(pos);
        List drops = Collections.emptyList();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2586 be = level.method_8321(pos);
            drops = class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)pos, (class_2586)be, (class_1297)p, (class_1799)item);
        }
        class_2680 smeltedBlockState = null;
        ArrayList<class_1799> smeltedDrops = new ArrayList<class_1799>();
        class_1277 tempInv = new class_1277(1);
        for (class_1799 i : drops) {
            tempInv.method_5447(0, i);
            Optional recipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)tempInv, level);
            if (!recipe.isPresent()) {
                return false;
            }
            class_1799 result = ((class_3861)recipe.get()).method_8116((class_1263)tempInv, level.method_30349());
            if (result.method_7909() instanceof class_1747) {
                class_2248 smeltedBlock = class_2248.method_9503((class_1792)result.method_7909());
                if (smeltedBlock == block) {
                    return false;
                }
                if (smeltedBlockState == null && !smeltedBlock.method_9564().method_26215()) {
                    smeltedBlockState = smeltedBlock.method_9564();
                    continue;
                }
            }
            smeltedDrops.add(result);
        }
        if (smeltedBlockState == null && smeltedDrops.isEmpty()) {
            return false;
        }
        this.extractAEPower(item, 1600.0, Actionable.MODULATE);
        level.method_43128(p, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15145, class_3419.field_15248, 1.0f, level.field_9229.method_43057() * 0.4f + 0.8f);
        if (smeltedBlockState == null) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        } else {
            level.method_8652(pos, smeltedBlockState, 3);
        }
        Platform.spawnDrops(level, pos, smeltedDrops);
        return true;
    }

    @Nullable
    private static EntropyRecipe findRecipe(class_1937 level, EntropyMode mode, class_2680 blockState, class_3610 fluidState) {
        for (EntropyRecipe recipe : level.method_8433().method_17717(EntropyRecipe.TYPE).values()) {
            if (!recipe.matches(mode, blockState, fluidState)) continue;
            return recipe;
        }
        return null;
    }

    private static void applyRecipe(EntropyRecipe recipe, class_1937 level, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        class_2680 outputBlockState = recipe.getOutputBlockState(blockState);
        if (outputBlockState != null) {
            level.method_8652(pos, outputBlockState, 3);
        } else {
            class_3610 outputFluidState = recipe.getOutputFluidState(fluidState);
            if (outputFluidState != null) {
                level.method_8652(pos, outputFluidState.method_15759(), 3);
            } else {
                level.method_8501(pos, class_2246.field_10124.method_9564());
            }
        }
        if (!level.field_9236) {
            for (class_1799 drop : recipe.getDrops()) {
                class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)drop.method_7972());
            }
        }
        if (recipe.getMode() == EntropyMode.HEAT && !level.method_8608()) {
            level.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }
}

