/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark.factory;

import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.ContentType;
import appeng.libs.micromark.State;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.Tokenizer;

public final class FactoryDestination {
    private FactoryDestination() {
    }

    public static State create(Tokenizer.Effects effects, State ok, State nok, String type, String literalType, String literalMarkerType, String rawType, String stringType) {
        return FactoryDestination.create(effects, ok, nok, type, literalType, literalMarkerType, rawType, stringType, null);
    }

    public static State create(Tokenizer.Effects effects, State ok, State nok, String type, String literalType, String literalMarkerType, String rawType, String stringType, Integer max) {
        return new StateMachine(effects, ok, nok, type, literalType, literalMarkerType, rawType, stringType, max)::start;
    }

    private static class StateMachine {
        private Tokenizer.Effects effects;
        private State ok;
        private State nok;
        private String type;
        private final String literalType;
        private final String literalMarkerType;
        private final String rawType;
        private final String stringType;
        private int limit;
        private int balance = 0;

        public StateMachine(Tokenizer.Effects effects, State ok, State nok, String type, String literalType, String literalMarkerType, String rawType, String stringType, Integer max) {
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.type = type;
            this.literalType = literalType;
            this.literalMarkerType = literalMarkerType;
            this.rawType = rawType;
            this.stringType = stringType;
            this.limit = max != null ? max : Integer.MAX_VALUE;
        }

        private State start(int code) {
            if (code == 60) {
                this.effects.enter(this.type);
                this.effects.enter(this.literalType);
                this.effects.enter(this.literalMarkerType);
                this.effects.consume(code);
                this.effects.exit(this.literalMarkerType);
                return this::destinationEnclosedBefore;
            }
            if (code == Integer.MIN_VALUE || code == 41 || CharUtil.asciiControl(code)) {
                return this.nok.step(code);
            }
            this.effects.enter(this.type);
            this.effects.enter(this.rawType);
            this.effects.enter(this.stringType);
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.destinationRaw(code);
        }

        private State destinationEnclosedBefore(int code) {
            if (code == 62) {
                this.effects.enter(this.literalMarkerType);
                this.effects.consume(code);
                this.effects.exit(this.literalMarkerType);
                this.effects.exit(this.literalType);
                this.effects.exit(this.type);
                return this.ok;
            }
            this.effects.enter(this.stringType);
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.destinationEnclosed(code);
        }

        private State destinationEnclosed(int code) {
            if (code == 62) {
                this.effects.exit("chunkString");
                this.effects.exit(this.stringType);
                return this.destinationEnclosedBefore(code);
            }
            if (code == Integer.MIN_VALUE || code == 60 || CharUtil.markdownLineEnding(code)) {
                return this.nok.step(code);
            }
            this.effects.consume(code);
            return code == 92 ? this::destinationEnclosedEscape : this::destinationEnclosed;
        }

        private State destinationEnclosedEscape(int code) {
            if (code == 60 || code == 62 || code == 92) {
                this.effects.consume(code);
                return this::destinationEnclosed;
            }
            return this.destinationEnclosed(code);
        }

        private State destinationRaw(int code) {
            if (code == 40) {
                if (++this.balance > this.limit) {
                    return this.nok.step(code);
                }
                this.effects.consume(code);
                return this::destinationRaw;
            }
            if (code == 41) {
                if (this.balance-- == 0) {
                    this.effects.exit("chunkString");
                    this.effects.exit(this.stringType);
                    this.effects.exit(this.rawType);
                    this.effects.exit(this.type);
                    return this.ok.step(code);
                }
                this.effects.consume(code);
                return this::destinationRaw;
            }
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEndingOrSpace(code)) {
                if (this.balance != 0) {
                    return this.nok.step(code);
                }
                this.effects.exit("chunkString");
                this.effects.exit(this.stringType);
                this.effects.exit(this.rawType);
                this.effects.exit(this.type);
                return this.ok.step(code);
            }
            if (CharUtil.asciiControl(code)) {
                return this.nok.step(code);
            }
            this.effects.consume(code);
            return code == 92 ? this::destinationRawEscape : this::destinationRaw;
        }

        private State destinationRawEscape(int code) {
            if (code == 40 || code == 41 || code == 92) {
                this.effects.consume(code);
                return this::destinationRaw;
            }
            return this.destinationRaw(code);
        }
    }
}

