/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.InterfaceLogicHost;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.primitives.Ints;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class SetStockAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final class_3917<SetStockAmountMenu> TYPE = MenuTypeBuilder.create(SetStockAmountMenu::new, InterfaceLogicHost.class).build("set_stock_amount");
    public static final String ACTION_SET_STOCK_AMOUNT = "setStockAmount";
    private final class_1735 stockedItem;
    private AEKey whatToStock;
    @GuiSync(value=1)
    private int initialAmount = -1;
    @GuiSync(value=2)
    private int maxAmount = -1;
    private int slot;
    private final InterfaceLogicHost host;

    public SetStockAmountMenu(int id, class_1661 ip, InterfaceLogicHost host) {
        super(TYPE, id, ip, host);
        this.registerClientAction(ACTION_SET_STOCK_AMOUNT, Integer.class, this::confirm);
        this.host = host;
        this.stockedItem = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.addSlot(this.stockedItem, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public InterfaceLogicHost getHost() {
        return this.host;
    }

    public static void open(class_3222 player, MenuLocator locator, int slot, AEKey whatToStock, int initialAmount) {
        MenuOpener.open(TYPE, (class_1657)player, locator);
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof SetStockAmountMenu) {
            SetStockAmountMenu cca = (SetStockAmountMenu)class_17032;
            cca.setWhatToStock(slot, whatToStock, initialAmount);
            cca.method_7623();
        }
    }

    public class_1937 getLevel() {
        return this.getPlayerInventory().field_7546.method_37908();
    }

    private void setWhatToStock(int slot, AEKey whatToStock, int initialAmount) {
        this.slot = slot;
        this.whatToStock = Objects.requireNonNull(whatToStock, "whatToStock");
        this.initialAmount = initialAmount;
        this.maxAmount = Ints.saturatedCast((long)this.host.getConfig().getMaxAmount(whatToStock));
        this.stockedItem.method_7673(whatToStock.wrapForDisplayOrFilter());
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void confirm(int amount) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STOCK_AMOUNT, amount);
            return;
        }
        GenericStackInv config = this.host.getConfig();
        if (!Objects.equals(config.getKey(this.slot), this.whatToStock)) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        if ((amount = (int)Math.min((long)amount, config.getMaxAmount(this.whatToStock))) <= 0) {
            config.setStack(this.slot, null);
        } else {
            config.setStack(this.slot, new GenericStack(this.whatToStock, amount));
        }
        this.host.returnToMainMenu(this.getPlayer(), this);
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    @Nullable
    public AEKey getWhatToStock() {
        GenericStack stack = GenericStack.fromItemStack(this.stockedItem.method_7677());
        return stack != null ? stack.what() : null;
    }
}

