/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.slot.AppEngCraftingSlot;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_8566;

public class CraftingTermSlot
extends AppEngCraftingSlot {
    private final InternalInventory craftInv;
    private final InternalInventory pattern;
    private final IActionSource mySrc;
    private final IEnergySource energySrc;
    private final MEStorage storage;
    private final IMenuCraftingPacket menu;

    public CraftingTermSlot(class_1657 player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, IMenuCraftingPacket ccp) {
        super(player, cMatrix);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.menu = ccp;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return false;
    }

    @Override
    public void method_7667(class_1657 p, class_1799 is) {
    }

    public void doClick(InventoryAction action, class_1657 who) {
        int maxTimesToCraft;
        InternalInventory target;
        if (this.method_7677().method_7960()) {
            return;
        }
        if (this.isRemote()) {
            return;
        }
        int howManyPerCraft = this.method_7677().method_7947();
        if (action == InventoryAction.CRAFT_SHIFT || action == InventoryAction.CRAFT_ALL) {
            target = new PlayerInternalInventory(who.method_31548());
            maxTimesToCraft = action == InventoryAction.CRAFT_SHIFT ? (int)Math.floor((double)this.method_7677().method_7914() / (double)howManyPerCraft) : (int)Math.floor((double)this.method_7677().method_7914() / (double)howManyPerCraft * 36.0);
        } else if (action == InventoryAction.CRAFT_STACK) {
            target = new CarriedItemInventory(this.getMenu());
            maxTimesToCraft = (int)Math.floor((double)this.method_7677().method_7914() / (double)howManyPerCraft);
        } else {
            if (this.getMenu().method_34255().method_7960()) {
                this.getMenu().method_34254(this.craftItem(who, this.storage, this.storage.getAvailableStacks()));
                return;
            }
            target = new CarriedItemInventory(this.getMenu());
            maxTimesToCraft = 1;
        }
        class_1799 itemAtStart = this.method_7677().method_7972();
        if (itemAtStart.method_7960()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            if (!class_1799.method_31577((class_1799)itemAtStart, (class_1799)this.method_7677())) {
                return;
            }
            if (!target.simulateAdd(itemAtStart).method_7960()) {
                return;
            }
            KeyCounter all = this.storage.getAvailableStacks();
            class_1799 extra = target.addItems(this.craftItem(who, this.storage, all));
            if (extra.method_7960()) continue;
            Platform.spawnDrops(who.method_37908(), who.method_24515(), List.of(extra));
            return;
        }
    }

    protected class_1860<class_8566> findRecipe(class_8566 ic, class_1937 level) {
        CraftingTermMenu terminalMenu;
        class_1860<class_8566> recipe;
        IMenuCraftingPacket iMenuCraftingPacket = this.menu;
        if (iMenuCraftingPacket instanceof CraftingTermMenu && (recipe = (terminalMenu = (CraftingTermMenu)iMenuCraftingPacket).getCurrentRecipe()) != null && recipe.method_8115((class_1263)ic, level)) {
            return terminalMenu.getCurrentRecipe();
        }
        return level.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, level).orElse(null);
    }

    @Override
    protected class_2371<class_1799> getRemainingItems(class_8566 ic, class_1937 level) {
        CraftingTermMenu terminalMenu;
        class_1860<class_8566> recipe;
        IMenuCraftingPacket iMenuCraftingPacket = this.menu;
        if (iMenuCraftingPacket instanceof CraftingTermMenu && (recipe = (terminalMenu = (CraftingTermMenu)iMenuCraftingPacket).getCurrentRecipe()) != null && recipe.method_8115((class_1263)ic, level)) {
            return terminalMenu.getCurrentRecipe().method_8111((class_1263)ic);
        }
        return super.getRemainingItems(ic, level);
    }

    private class_1799 craftItem(class_1657 p, MEStorage inv, KeyCounter all) {
        class_1799 is = this.method_7677().method_7972();
        if (is.method_7960()) {
            return class_1799.field_8037;
        }
        Object[] set = new class_1799[this.getPattern().size()];
        Arrays.fill(set, class_1799.field_8037);
        class_1937 level = p.method_37908();
        if (!level.method_8608()) {
            class_1715 ic = new class_1715(p.field_7512, 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.method_5447(x, this.getPattern().getStackInSlot(x));
            }
            class_1860<class_8566> r = this.findRecipe((class_8566)ic, level);
            if (r == null) {
                class_1792 target = is.method_7909();
                if (target.method_7846() && target.method_7878(is, is)) {
                    boolean isBad = false;
                    for (int x = 0; x < ic.method_5439(); ++x) {
                        class_1799 pis = ic.method_5438(x);
                        if (pis.method_7960() || pis.method_7909() == target) continue;
                        isBad = true;
                    }
                    if (!isBad) {
                        super.method_7667(p, is);
                        p.field_7512.method_7609(this.craftInv.toContainer());
                        return is;
                    }
                }
                return class_1799.field_8037;
            }
            is = r.method_8116((class_1263)ic, level.method_30349());
            if (inv != null) {
                IPartitionList filter = ViewCellItem.createItemFilter(this.menu.getViewCells());
                for (int x = 0; x < this.getPattern().size(); ++x) {
                    if (this.getPattern().getStackInSlot(x).method_7960()) continue;
                    set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, level, r, is, (class_8566)ic, this.getPattern().getStackInSlot(x), x, all, Actionable.MODULATE, filter);
                    ic.method_5447(x, (class_1799)set[x]);
                }
            }
        }
        if (this.preCraft(p, inv, (class_1799[])set, is)) {
            this.makeItem(p, is);
            this.postCraft(p, inv, (class_1799[])set, is);
        }
        p.field_7512.method_7609(this.craftInv.toContainer());
        return is;
    }

    private boolean preCraft(class_1657 p, MEStorage inv, class_1799[] set, class_1799 result) {
        return true;
    }

    private void makeItem(class_1657 p, class_1799 is) {
        super.method_7667(p, is);
    }

    private void postCraft(class_1657 p, MEStorage inv, class_1799[] set, class_1799 result) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (!p.method_5770().method_8608()) {
            for (int x = 0; x < this.craftInv.size(); ++x) {
                int amount;
                AEItemKey what;
                long inserted;
                if (this.craftInv.getStackInSlot(x).method_7960()) {
                    this.craftInv.setItemDirect(x, set[x]);
                    continue;
                }
                if (set[x].method_7960() || (inserted = inv.insert(what = AEItemKey.of(set[x]), amount = set[x].method_7947(), Actionable.MODULATE, this.mySrc)) >= (long)amount) continue;
                drops.add(what.toStack((int)((long)amount - inserted)));
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.method_37908(), new class_2338((int)p.method_23317(), (int)p.method_23318(), (int)p.method_23321()), drops);
        }
    }

    InternalInventory getPattern() {
        return this.pattern;
    }
}

