/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.ids.AETags;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.Upgrades;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.blockentity.misc.VibrationChamberBlockEntity;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.slot.AppEngSlot;
import appeng.util.Platform;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;

public class RestrictedInputSlot
extends AppEngSlot {
    private final PlacableItemType which;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public RestrictedInputSlot(PlacableItemType valid, InternalInventory inv, int invSlot) {
        super(inv, invSlot);
        this.which = valid;
        this.setIcon(valid.icon);
    }

    @Override
    public int method_7675() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.method_7675();
    }

    public class_1735 setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    private class_1937 getLevel() {
        return this.getMenu().getPlayerInventory().field_7546.method_5770();
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        if (!this.getMenu().isValidForSlot(this, stack)) {
            return false;
        }
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8162) {
            return false;
        }
        if (!super.method_7680(stack)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        switch (this.which) {
            case MOLECULAR_ASSEMBLER_PATTERN: {
                return PatternDetailsHelper.decodePattern(stack, this.getLevel()) instanceof IMolecularAssemblerSupportedPattern;
            }
            case ENCODED_PATTERN: {
                return PatternDetailsHelper.isEncodedPattern(stack);
            }
            case ENCODED_AE_PATTERN: {
                return AEItems.CRAFTING_PATTERN.isSameAs(stack) || AEItems.PROCESSING_PATTERN.isSameAs(stack) || AEItems.SMITHING_TABLE_PATTERN.isSameAs(stack) || AEItems.STONECUTTING_PATTERN.isSameAs(stack);
            }
            case BLANK_PATTERN: {
                return AEItems.BLANK_PATTERN.isSameAs(stack);
            }
            case INSCRIBER_PLATE: {
                if (AEItems.NAME_PRESS.isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(this.getLevel(), stack);
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return RestrictedInputSlot.isMetalIngot(stack);
            }
            case VIEW_CELL: {
                return AEItems.VIEW_CELL.isSameAs(stack);
            }
            case FUEL: {
                return VibrationChamberBlockEntity.hasBurnTime(stack);
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(stack);
            }
            case QE_SINGULARITY: {
                return QuantumBridgeBlockEntity.isValidEntangledSingularity(stack);
            }
            case RANGE_BOOSTER: {
                return AEItems.WIRELESS_BOOSTER.isSameAs(stack);
            }
            case SPATIAL_STORAGE_CELLS: {
                return stack.method_7909() instanceof ISpatialStorageCell && ((ISpatialStorageCell)stack.method_7909()).isSpatialStorage(stack);
            }
            case STORAGE_CELLS: {
                return StorageCells.isCellHandled(stack);
            }
            case WORKBENCH_CELL: {
                return stack.method_7909() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)stack.method_7909()).isEditable(stack);
            }
            case STORAGE_COMPONENT: {
                return stack.method_7909() instanceof IStorageComponent && ((IStorageComponent)stack.method_7909()).isStorageComponent(stack);
            }
            case TRASH: {
                if (StorageCells.isCellHandled(stack)) {
                    return false;
                }
                return !(stack.method_7909() instanceof IStorageComponent) || !((IStorageComponent)stack.method_7909()).isStorageComponent(stack);
            }
            case GRID_LINKABLE_ITEM: {
                IGridLinkableHandler handler = GridLinkables.get((class_1935)stack.method_7909());
                return handler != null && handler.canLink(stack);
            }
            case UPGRADES: {
                return Upgrades.isUpgradeCardItem(stack);
            }
        }
        return false;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return this.isAllowEdit();
    }

    @Override
    public class_1799 getDisplayStack() {
        EncodedPatternItem iep;
        class_1799 out;
        class_1792 class_17922;
        class_1799 is;
        if (this.isRemote() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.getDisplayStack()).method_7960() && (class_17922 = is.method_7909()) instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)class_17922).getOutput(is)).method_7960()) {
            return out;
        }
        return super.getDisplayStack();
    }

    public static boolean isMetalIngot(class_1799 i) {
        return i.method_7909().method_40131().method_40220(AETags.METAL_INGOTS);
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(Icon.BACKGROUND_STORAGE_CELL),
        ORE(Icon.BACKGROUND_ORE),
        STORAGE_COMPONENT(Icon.BACKGROUND_STORAGE_COMPONENT),
        GRID_LINKABLE_ITEM(Icon.BACKGROUND_WIRELESS_TERM),
        TRASH(Icon.BACKGROUND_TRASH),
        ENCODED_AE_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        MOLECULAR_ASSEMBLER_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        BLANK_PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        POWERED_TOOL(Icon.BACKGROUND_CHARGABLE),
        RANGE_BOOSTER(Icon.BACKGROUND_WIRELESS_BOOSTER),
        QE_SINGULARITY(Icon.BACKGROUND_SINGULARITY),
        SPATIAL_STORAGE_CELLS(Icon.BACKGROUND_SPATIAL_CELL),
        FUEL(Icon.BACKGROUND_FUEL),
        UPGRADES(Icon.BACKGROUND_UPGRADE),
        WORKBENCH_CELL(Icon.BACKGROUND_STORAGE_CELL),
        VIEW_CELL(Icon.BACKGROUND_VIEW_CELL),
        INSCRIBER_PLATE(Icon.BACKGROUND_PLATE),
        INSCRIBER_INPUT(Icon.BACKGROUND_INGOT),
        METAL_INGOTS(Icon.BACKGROUND_INGOT);

        public final Icon icon;

        private PlacableItemType(Icon o) {
            this.icon = o;
        }
    }
}

