/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class EntropyRecipeBuilder {
    private class_2960 id;
    private EntropyMode mode;
    private class_2248 inputBlock;
    private List<StateMatcher> inputBlockMatchers = Collections.emptyList();
    private class_3611 inputFluid;
    private List<StateMatcher> inputFluidMatchers = Collections.emptyList();
    private class_2248 outputBlock;
    private List<StateApplier<?>> outputBlockStateAppliers = Collections.emptyList();
    private boolean outputBlockKeep;
    private class_3611 outputFluid;
    private List<StateApplier<?>> outputFluidStateAppliers = Collections.emptyList();
    private boolean outputFluidKeep;
    private List<class_1799> drops = Collections.emptyList();

    public static EntropyRecipeBuilder cool(class_2960 id) {
        return new EntropyRecipeBuilder().setId(id).setMode(EntropyMode.COOL);
    }

    public static EntropyRecipeBuilder heat(class_2960 id) {
        return new EntropyRecipeBuilder().setId(id).setMode(EntropyMode.HEAT);
    }

    public EntropyRecipeBuilder setId(class_2960 id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0);
        this.id = id;
        return this;
    }

    public EntropyRecipeBuilder setMode(EntropyMode mode) {
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
        return this;
    }

    public EntropyRecipeBuilder setInputBlock(class_2248 inputBlock) {
        this.inputBlock = Objects.requireNonNull(inputBlock, "inputBlock must not be null");
        return this;
    }

    public EntropyRecipeBuilder setInputFluid(class_3611 inputFluid) {
        this.inputFluid = Objects.requireNonNull(inputFluid, "inputFluid must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputBlock(class_2248 outputBlock) {
        this.outputBlock = Objects.requireNonNull(outputBlock, "outputBlock must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputBlockKeep(boolean outputBlockKeep) {
        this.outputBlockKeep = outputBlockKeep;
        return this;
    }

    public EntropyRecipeBuilder setOutputFluid(class_3611 outputFluid) {
        this.outputFluid = Objects.requireNonNull(outputFluid, "outputFluid must not be null");
        return this;
    }

    public EntropyRecipeBuilder setOutputFluidKeep(boolean outputFluidKeep) {
        this.outputFluidKeep = outputFluidKeep;
        return this;
    }

    public EntropyRecipeBuilder setDrops(List<class_1799> drops) {
        Preconditions.checkArgument((!drops.isEmpty() ? 1 : 0) != 0, (Object)"drops needs to be a non empty list when set");
        this.drops = drops;
        return this;
    }

    public EntropyRecipeBuilder setDrops(class_1799 ... drops) {
        return this.setDrops(Arrays.asList(drops));
    }

    public EntropyRecipeBuilder addBlockStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input block is present.");
        if (this.inputBlockMatchers.isEmpty()) {
            this.inputBlockMatchers = new ArrayList<StateMatcher>();
        }
        this.inputBlockMatchers.add(matcher);
        return this;
    }

    public EntropyRecipeBuilder addFluidStateMatcher(StateMatcher matcher) {
        Preconditions.checkState((this.inputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an input fluid is present.");
        if (this.inputFluidMatchers.isEmpty()) {
            this.inputFluidMatchers = new ArrayList<StateMatcher>();
        }
        this.inputFluidMatchers.add(matcher);
        return this;
    }

    public EntropyRecipeBuilder addBlockStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputBlock != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output block is present.");
        if (this.outputBlockStateAppliers.isEmpty()) {
            this.outputBlockStateAppliers = new ArrayList();
        }
        this.outputBlockStateAppliers.add(applier);
        return this;
    }

    public EntropyRecipeBuilder addFluidStateAppliers(StateApplier<?> applier) {
        Preconditions.checkState((this.outputFluid != null ? 1 : 0) != 0, (Object)"Can only add appliers when an output fluid is present.");
        if (this.outputFluidStateAppliers.isEmpty()) {
            this.outputFluidStateAppliers = new ArrayList();
        }
        this.outputFluidStateAppliers.add(applier);
        return this;
    }

    public EntropyRecipe build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        Preconditions.checkState((this.mode != null ? 1 : 0) != 0);
        Preconditions.checkState((this.inputBlock != null || this.inputFluid != null ? 1 : 0) != 0, (Object)"Either inputBlock or inputFluid needs to be not null");
        return new EntropyRecipe(this.id, this.mode, this.inputBlock, this.inputBlockMatchers, this.inputFluid, this.inputFluidMatchers, this.outputBlock, this.outputBlockStateAppliers, this.outputBlockKeep, this.outputFluid, this.outputFluidStateAppliers, this.outputFluidKeep, this.drops);
    }

    public void save(Consumer<class_2444> consumer) {
        consumer.accept(new Result());
    }

    private class Result
    implements class_2444 {
        private Result() {
        }

        public void method_10416(JsonObject json) {
            EntropyRecipeSerializer.INSTANCE.toJson(EntropyRecipeBuilder.this.build(), json);
        }

        public class_2960 method_10417() {
            return EntropyRecipeBuilder.this.id;
        }

        public class_1865<?> method_17800() {
            return EntropyRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

