/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

class MultipleValuesMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final class_2769<T> property;
    private final Set<T> propertyValues;

    public MultipleValuesMatcher(class_2769<T> property, List<String> propertyValues) {
        this.property = Objects.requireNonNull(property, "property must be not null");
        this.propertyValues = propertyValues.stream().map(name -> PropertyUtils.getRequiredPropertyValue(property, name)).collect(Collectors.toSet());
    }

    @Override
    public boolean matches(class_2688<?, ?> state) {
        return this.propertyValues.contains(state.method_11654(this.property));
    }

    @Override
    public void writeToPacket(class_2540 buffer) {
        buffer.method_10817((Enum)StateMatcher.MatcherType.MULTIPLE);
        buffer.method_10814(this.property.method_11899());
        buffer.writeInt(this.propertyValues.size());
        for (Comparable value : this.propertyValues) {
            buffer.method_10814(this.property.method_11901(value));
        }
    }

    @Override
    public class_2769<?> getProperty() {
        return this.property;
    }

    public Set<String> getValueNames() {
        return this.propertyValues.stream().map(arg_0 -> this.property.method_11901(arg_0)).collect(Collectors.toSet());
    }

    public static MultipleValuesMatcher<?> create(class_2689<?, ?> stateDefinition, String propertyName, List<String> values) {
        class_2769<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new MultipleValuesMatcher(property, values);
    }

    @Environment(value=EnvType.CLIENT)
    public static MultipleValuesMatcher<?> readFromPacket(class_2689<?, ?> stateDefinition, class_2540 buffer) {
        String propertyName = buffer.method_19772();
        int size = buffer.readInt();
        ArrayList<String> values = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            values.add(buffer.method_19772());
        }
        return MultipleValuesMatcher.create(stateDefinition, propertyName, values);
    }
}

