/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SortOrder;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.util.DimensionalBlockPos;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.hooks.ticking.TickHandler;
import appeng.util.BlockUpdate;
import appeng.util.helpers.P2PHelper;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import net.minecraft.class_8566;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Platform {
    private static final FabricLoader FABRIC = FabricLoader.getInstance();
    private static final P2PHelper P2P_HELPER = new P2PHelper();
    public static final class_2350[] DIRECTIONS_WITH_NULL = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, null};
    @Nullable
    private static final Class<?> ponderLevelClass = Platform.findPonderLevelClass("com.simibubi.create.foundation.ponder.PonderWorld");
    public static class_1863 fallbackClientRecipeManager;
    public static class_5455 fallbackClientRegistryAccess;

    public static class_5455 getClientRegistryAccess() {
        if (class_310.method_1551() != null && class_310.method_1551().field_1687 != null) {
            return class_310.method_1551().field_1687.method_30349();
        }
        return Objects.requireNonNull(fallbackClientRegistryAccess);
    }

    public static class_1863 getClientRecipeManager() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null) {
            return minecraft.field_1687.method_8433();
        }
        return fallbackClientRecipeManager;
    }

    private static Class<?> findPonderLevelClass(String className) {
        if (!Platform.hasClientClasses()) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            AELog.warn("Unable to find class %s. Integration with PonderJS disabled.", className);
            return null;
        }
    }

    public static P2PHelper p2p() {
        return P2P_HELPER;
    }

    public static String formatPowerLong(long n, boolean isRate) {
        return Platform.formatPower((double)n / 100.0, isRate);
    }

    public static String formatPower(double p, boolean isRate) {
        PowerUnits displayUnits = AEConfig.instance().getSelectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String unitName = displayUnits.getSymbolName();
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + " " + level + unitName + (isRate ? "/t" : "");
    }

    public static String formatTimeMeasurement(long nanos) {
        if (nanos <= 0L) {
            return "0 ns";
        }
        if (nanos < 1000L) {
            return "<1 \u00b5s";
        }
        if (nanos <= 1000000L) {
            long ms = TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS);
            return ms + "\u00b5s";
        }
        long ms = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        return ms + "ms";
    }

    public static class_2350 crossProduct(class_2350 forward, class_2350 up) {
        int west_x = forward.method_10164() * up.method_10165() - forward.method_10165() * up.method_10164();
        int west_y = forward.method_10165() * up.method_10148() - forward.method_10148() * up.method_10165();
        int west_z = forward.method_10148() * up.method_10164() - forward.method_10164() * up.method_10148();
        return switch (west_x + west_y * 2 + west_z * 3) {
            case 1 -> class_2350.field_11034;
            case -1 -> class_2350.field_11039;
            case 2 -> class_2350.field_11036;
            case -2 -> class_2350.field_11033;
            case 3 -> class_2350.field_11035;
            case -3 -> class_2350.field_11043;
            default -> class_2350.field_11043;
        };
    }

    public static boolean hasClientClasses() {
        return FABRIC.getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isClient() {
        MinecraftServer currentServer = AppEng.instance().getCurrentServer();
        return currentServer == null || Thread.currentThread() != currentServer.method_3777();
    }

    public static boolean hasPermissions(DimensionalBlockPos dc, class_1657 player) {
        if (!dc.isInWorld((class_1936)player.method_37908())) {
            return false;
        }
        return player.method_37908().method_8505(player, dc.getPos());
    }

    public static void spawnDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        if (!level.method_8608()) {
            for (class_1799 i : drops) {
                class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)i);
            }
        }
    }

    public static boolean isServer() {
        try {
            MinecraftServer currentServer = AppEng.instance().getCurrentServer();
            return currentServer != null && Thread.currentThread() == currentServer.method_3777();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static void assertServerThread() {
        if (!Platform.isServer()) {
            throw new UnsupportedOperationException("This code can only be called server-side and this is most likely a bug.");
        }
    }

    public static String formatModName(String modId) {
        return class_124.field_1078 + class_124.field_1056 + Platform.getModName(modId);
    }

    @Nullable
    public static String getModName(String modId) {
        return FABRIC.getModContainer(modId).map(mc -> mc.getMetadata().getName()).orElse(modId);
    }

    public static String getDescriptionId(class_3611 fluid) {
        return fluid.method_15785().method_15759().method_26204().method_9539();
    }

    public static String getDescriptionId(FluidVariant fluid) {
        return Platform.getDescriptionId(fluid.getFluid());
    }

    public static class_2561 getFluidDisplayName(class_3611 fluid, @Nullable class_2487 tag) {
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid, (class_2487)tag));
    }

    public static class_2561 getItemDisplayName(class_1792 item, @Nullable class_2487 tag) {
        class_1799 itemStack = new class_1799((class_1935)item);
        itemStack.method_7980(tag);
        return itemStack.method_7964();
    }

    public static boolean isChargeable(class_1799 i) {
        if (i.method_7960()) {
            return false;
        }
        class_1792 class_17922 = i.method_7909();
        if (class_17922 instanceof IAEItemPowerStorage) {
            IAEItemPowerStorage powerStorage = (IAEItemPowerStorage)class_17922;
            return powerStorage.getAEMaxPower(i) > 0.0 && powerStorage.getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    public static class_1657 getFakePlayer(class_3218 level, @Nullable UUID playerUuid) {
        Objects.requireNonNull(level);
        if (playerUuid == null) {
            playerUuid = FakePlayer.DEFAULT_UUID;
        }
        return FakePlayer.get((class_3218)level, (GameProfile)new GameProfile(playerUuid, "[AE2]"));
    }

    public static class_2350 rotateAround(class_2350 forward, class_2350 axis) {
        if (forward.method_10166() == axis.method_10166()) {
            return forward;
        }
        class_2382 newForward = forward.method_10163().method_10259(axis.method_10163());
        return Objects.requireNonNull(class_2350.method_50026((int)newForward.method_10263(), (int)newForward.method_10264(), (int)newForward.method_10260()));
    }

    public static void configurePlayer(class_1657 player, class_2350 side, class_2586 blockEntity) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case field_11033: 
            case field_11036: {
                pitch = 90.0f;
                break;
            }
            case field_11034: {
                yaw = -90.0f;
                break;
            }
            case field_11043: {
                yaw = 180.0f;
                break;
            }
            case field_11035: {
                yaw = 0.0f;
                break;
            }
            case field_11039: {
                yaw = 90.0f;
                break;
            }
        }
        player.method_5808((double)blockEntity.method_11016().method_10263() + 0.5, (double)blockEntity.method_11016().method_10264() + 0.5, (double)blockEntity.method_11016().method_10260() + 0.5, yaw, pitch);
    }

    public static class_1799 extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, MEStorage src, class_1937 level, class_1860<class_8566> r, class_1799 output, class_8566 ci, class_1799 providedTemplate, int slot, KeyCounter items, Actionable realForFake, IPartitionList filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            long extracted;
            if (providedTemplate == null) {
                return class_1799.field_8037;
            }
            AEItemKey ae_req = AEItemKey.of(providedTemplate);
            if ((filter == null || filter.isListed(ae_req)) && (extracted = src.extract(ae_req, 1L, realForFake, mySrc)) > 0L) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return ae_req.toStack();
            }
            boolean bl = checkFuzzy = providedTemplate.method_7985() || providedTemplate.method_7963();
            if (items != null && checkFuzzy) {
                for (Object2LongMap.Entry<AEKey> x : items) {
                    long ex;
                    Object object = x.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    if (providedTemplate.method_7909() != itemKey.getItem() || itemKey.matches(output)) continue;
                    ci.method_5447(slot, itemKey.toStack());
                    if (r.method_8115((class_1263)ci, level) && class_1799.method_7973((class_1799)r.method_8116((class_1263)ci, level.method_30349()), (class_1799)output) && (filter == null || filter.isListed(itemKey)) && (ex = src.extract(itemKey, 1L, realForFake, mySrc)) > 0L) {
                        energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                        return itemKey.toStack();
                    }
                    ci.method_5447(slot, providedTemplate);
                }
            }
        }
        return class_1799.field_8037;
    }

    public static void notifyBlocksOfNeighbors(class_1937 level, class_2338 pos) {
        if (level != null && !level.field_9236) {
            TickHandler.instance().addCallable((class_1936)level, new BlockUpdate(pos));
        }
    }

    public static boolean isSortOrderAvailable(SortOrder order) {
        return true;
    }

    @Nullable
    public static class_2586 getTickingBlockEntity(@Nullable class_1937 level, class_2338 pos) {
        if (!Platform.areBlockEntitiesTicking(level, pos)) {
            return null;
        }
        return level.method_8321(pos);
    }

    public static boolean areBlockEntitiesTicking(@Nullable class_1937 level, class_2338 pos) {
        return Platform.areBlockEntitiesTicking(level, class_1923.method_37232((class_2338)pos));
    }

    public static boolean areBlockEntitiesTicking(@Nullable class_1937 level, long chunkPos) {
        class_3218 serverLevel;
        return level instanceof class_3218 && (serverLevel = (class_3218)level).method_14178().method_37114(chunkPos);
    }

    public static Transaction openOrJoinTx() {
        return Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());
    }

    public static class_2596<?> getFullChunkPacket(class_2818 c) {
        return new class_2672(c, c.method_12200().method_22336(), null, null);
    }

    public static class_1799 getInsertionRemainder(class_1799 original, long inserted) {
        if (inserted >= (long)original.method_7947()) {
            return class_1799.field_8037;
        }
        return Platform.copyStackWithSize(original, (int)((long)original.method_7947() - inserted));
    }

    public static class_1799 copyStackWithSize(class_1799 itemStack, int size) {
        if (size <= 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }

    public static void sendImmediateBlockEntityUpdate(class_1657 player, class_2338 pos) {
        if (player instanceof class_3222) {
            class_2596 packet;
            class_3222 serverPlayer = (class_3222)player;
            class_2586 be = player.method_37908().method_8321(pos);
            if (be != null && (packet = be.method_38235()) != null) {
                serverPlayer.field_13987.method_14364(packet);
            }
        }
    }

    public static boolean isPonderLevel(class_1937 level) {
        return ponderLevelClass != null && ponderLevelClass.isInstance(level);
    }

    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

