/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import org.lwjgl.stb.STBImageResize;

public class ImageUtil {
    public static class_1011 getSizedImage(int width, int height, class_1011 from, boolean autoClose) {
        class_1011 scaledImage = new class_1011(from.method_4318(), width, height, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.field_4988, (int)from.method_4307(), (int)from.method_4323(), (int)0, (long)scaledImage.field_4988, (int)width, (int)height, (int)0, (int)from.method_4318().method_4335(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static class_1011 getScaledImage(float scale, class_1011 from, boolean autoClose) {
        int scaledWidth = (int)((float)from.method_4307() * scale);
        int scaledHeight = (int)((float)from.method_4323() * scale);
        class_1011 scaledImage = new class_1011(from.method_4318(), scaledWidth, scaledHeight, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.field_4988, (int)from.method_4307(), (int)from.method_4323(), (int)0, (long)scaledImage.field_4988, (int)scaledWidth, (int)scaledHeight, (int)0, (int)from.method_4318().method_4335(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static ComparableNativeImage getComparableSubImage(int x, int y, int width, int height, class_1011 from, boolean autoClose) {
        ComparableNativeImage to = new ComparableNativeImage(from.method_4318(), width, height);
        return (ComparableNativeImage)ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static class_1011 getSubImage(int x, int y, int width, int height, class_1011 from, boolean autoClose) {
        class_1011 to = new class_1011(width, height, false);
        return ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static class_1011 getSubImage(int x, int y, int width, int height, class_1011 from, class_1011 to, boolean autoClose) {
        if (from.field_4988 == 0L) {
            throw new IllegalStateException("Image is not allocated. " + from);
        }
        if (to.method_4318() != from.method_4318()) {
            throw new UnsupportedOperationException("getSubImage only works for images of the same format.");
        }
        int i = from.method_4318().method_4335();
        STBImageResize.nstbir_resize_uint8_generic((long)(from.field_4988 + ((long)x + (long)y * (long)from.method_4307()) * (long)i), (int)width, (int)height, (int)(from.method_4307() * i), (long)to.field_4988, (int)to.method_4307(), (int)to.method_4323(), (int)0, (int)from.method_4318().method_4335(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return to;
    }

    public static class_1011 recolorImage(class_1011 image, int color) {
        class_1011 tintedImage = new class_1011(image.method_4307(), image.method_4323(), false);
        tintedImage.method_4317(image);
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4307(); ++y) {
                int imgColor = image.method_4315(x, y);
                if (ImageUtil.getAlpha(imgColor) <= 1) continue;
                tintedImage.method_35624(x, y, RGB.toRgba(color, 0.75f));
            }
        }
        return tintedImage;
    }

    public static void closeSafely(class_1011 image) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> ((class_1011)image).close());
        } else {
            image.close();
        }
    }

    public static class_1011 getNewBlankImage(int width, int height) {
        class_1011 image = new class_1011(width, height, false);
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                image.method_4305(x, y, RGB.toRgba(0, 0.0f));
            }
        }
        return image;
    }

    public static void clearAndClose(class_1011 image) {
        if (image != null) {
            try {
                image.close();
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Failed to clear and close image: ", (Throwable)e);
            }
        }
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }
}

