/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class WaypointPacket {
    public static final class_2960 CHANNEL = new class_2960("journeymap", "waypoint");
    private String action;
    private String waypoint;
    private boolean announce;

    public WaypointPacket() {
    }

    public WaypointPacket(String waypoint, boolean announce, String action) {
        this.action = action;
        this.waypoint = waypoint;
        this.announce = announce;
    }

    public static WaypointPacket decode(class_2540 buf) {
        WaypointPacket packet = new WaypointPacket();
        try {
            if (buf.readableBytes() > 1) {
                packet.waypoint = buf.method_19772();
                packet.action = buf.method_19772();
                packet.announce = buf.readBoolean();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for waypoint: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_10814(this.waypoint);
            buf.method_10814(this.action);
            buf.writeBoolean(this.announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for waypoint: " + t);
        }
    }

    public static void handle(PacketContext<WaypointPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onWaypointCreatePacket(ctx.message().waypoint, ctx.message().action, ctx.message().announce);
        }
    }
}

