/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.cit.builtin.conditions;

import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public abstract class DoubleCondition
extends CITCondition {
    protected final boolean supportsRanges;
    protected final boolean supportsNegatives;
    protected final boolean supportsPercentages;
    protected double min;
    protected double max;
    protected boolean range = false;
    protected boolean percentage = false;

    protected DoubleCondition(boolean supportsRanges, boolean supportsNegatives, boolean supportsPercentages) {
        this.supportsRanges = supportsRanges;
        this.supportsNegatives = supportsNegatives;
        this.supportsPercentages = supportsPercentages;
    }

    protected double getValue(CITContext context) {
        throw new AssertionError((Object)"Not implemented by this condition");
    }

    protected double getPercentageTotalValue(CITContext context) {
        throw new AssertionError((Object)"Not implemented by this condition");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        String strValue = value.value();
        if (this.supportsPercentages && (this.percentage = strValue.contains("%"))) {
            strValue = strValue.replace("%", "");
        }
        try {
            block33: {
                block31: {
                    block32: {
                        this.range = this.supportsRanges;
                        if (!this.range) break block31;
                        if (!this.supportsNegatives) break block32;
                        switch (strValue.length() - strValue.replace("-", "").length()) {
                            case 0: {
                                this.range = false;
                                this.min = Double.parseDouble(strValue);
                                break block33;
                            }
                            case 1: {
                                if (strValue.startsWith("-")) {
                                    this.range = false;
                                    this.min = Double.parseDouble(strValue);
                                } else if (strValue.endsWith("-")) {
                                    this.min = Double.parseDouble(strValue.substring(0, strValue.length() - 1));
                                    this.max = Double.MAX_VALUE;
                                } else {
                                    String[] split = strValue.split("-");
                                    this.min = Double.parseDouble(split[0]);
                                    this.max = Double.parseDouble(split[1]);
                                }
                                break block33;
                            }
                            case 2: {
                                if (strValue.startsWith("--")) {
                                    this.min = Double.MIN_VALUE;
                                    this.max = Double.parseDouble(strValue.substring(1));
                                } else if (strValue.startsWith("-") && strValue.endsWith("-")) {
                                    this.min = Double.parseDouble(strValue.substring(0, strValue.length() - 1));
                                    this.max = Double.MAX_VALUE;
                                } else {
                                    if (!strValue.startsWith("-") || strValue.endsWith("-") || strValue.contains("--")) throw new CITParsingException("Could not parse range", properties, value.position());
                                    int lastDash = strValue.lastIndexOf(45);
                                    this.min = Double.parseDouble(strValue.substring(0, lastDash));
                                    this.max = Double.parseDouble(strValue.substring(lastDash + 1));
                                }
                                break block33;
                            }
                            case 3: {
                                if (strValue.contains("---") || !strValue.startsWith("-")) throw new CITParsingException("Could not parse range", properties, value.position());
                                String[] split = strValue.split("--");
                                if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                                    throw new CITParsingException("Could not parse range", properties, value.position());
                                }
                                this.min = Double.parseDouble(split[0]);
                                this.max = -Double.parseDouble(split[1]);
                                break block33;
                            }
                            default: {
                                throw new CITParsingException("Could not parse range", properties, value.position());
                            }
                        }
                    }
                    this.range = strValue.contains("-");
                    if (this.range) {
                        if (strValue.contains("--")) {
                            throw new CITParsingException("Could not parse range", properties, value.position());
                        }
                        String[] split = strValue.split("-");
                        switch (split.length) {
                            case 1: {
                                this.min = Double.parseDouble(split[0]);
                                this.max = Double.MAX_VALUE;
                                break;
                            }
                            case 2: {
                                if (strValue.endsWith("-")) {
                                    throw new CITParsingException("Could not parse range", properties, value.position());
                                }
                                this.min = split[0].isEmpty() ? Double.MIN_VALUE : Double.parseDouble(split[0]);
                                this.max = split[1].isEmpty() ? Double.MAX_VALUE : Double.parseDouble(split[1]);
                                break;
                            }
                            default: {
                                throw new CITParsingException("Could not parse range", properties, value.position());
                            }
                        }
                    } else {
                        this.min = Double.parseDouble(strValue);
                    }
                    break block33;
                }
                this.min = Double.parseDouble(strValue);
                if (!this.supportsNegatives && this.min < 0.0) {
                    throw new CITParsingException("Negatives are not allowed", properties, value.position());
                }
            }
            if (!this.range) return;
            if (this.min == this.max) {
                this.range = false;
                return;
            } else {
                if (!(this.min > this.max)) return;
                throw new CITParsingException("Could not parse range", properties, value.position());
            }
        }
        catch (Exception e) {
            CITParsingException citE;
            throw e instanceof CITParsingException ? (citE = (CITParsingException)e) : new CITParsingException("Could not parse double", properties, value.position(), e);
        }
    }

    @Override
    public boolean test(CITContext context) {
        double value = this.getValue(context);
        if (this.percentage) {
            double percentValue = 100.0 * value / this.getPercentageTotalValue(context);
            return this.range ? this.min <= percentValue && percentValue <= this.max : percentValue == this.min;
        }
        return this.range ? this.min <= value && value <= this.max : value == this.min;
    }
}

