/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class CooldownTracker {
    private static final CooldownTracker clientInstance = new CooldownTracker();
    private static final CooldownTracker serverInstance = new CooldownTracker();
    private final Map<UUID, Long> lastUltimineTime = new HashMap<UUID, Long>();
    private static long ultimineCooldownClient;

    public static long getLastUltimineTime(class_1657 player) {
        CooldownTracker instance = player.method_37908().field_9236 ? clientInstance : serverInstance;
        return instance.lastUltimineTime.getOrDefault(player.method_5667(), 0L);
    }

    public static void setLastUltimineTime(class_1657 player, long when) {
        CooldownTracker instance = player.method_37908().field_9236 ? clientInstance : serverInstance;
        instance.lastUltimineTime.put(player.method_5667(), when);
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            new SyncUltimineTimePacket(when, SyncUltimineTimePacket.TimeType.LAST_USED).sendTo(sp);
        }
    }

    public static float getCooldownRemaining(class_1657 player) {
        long coolDown = CooldownTracker.getUltimineCooldown(player);
        if (coolDown == 0L) {
            return 1.0f;
        }
        long tickDelta = (System.currentTimeMillis() - CooldownTracker.getLastUltimineTime(player)) / 50L;
        return class_3532.method_15363((float)((float)tickDelta / (float)coolDown), (float)0.0f, (float)1.0f);
    }

    public static boolean isOnCooldown(class_1657 player) {
        long coolDown = CooldownTracker.getUltimineCooldown(player);
        if (coolDown == 0L) {
            return false;
        }
        long coolDownMs = coolDown * 50L;
        return coolDownMs > 0L && System.currentTimeMillis() - CooldownTracker.getLastUltimineTime(player) < coolDownMs;
    }

    private static long getUltimineCooldown(class_1657 player) {
        long l;
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            l = FTBUltimineServerConfig.getUltimineCooldown(sp);
        } else {
            l = ultimineCooldownClient;
        }
        return l;
    }

    public static void setClientCooldownTime(long cooldown) {
        ultimineCooldownClient = cooldown;
    }
}

