/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.mixin;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.other.PlayerAdditions;
import eu.pb4.graves.registry.GraveCompassItem;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerAdditions {
    @Unique
    private long graves$location = -1L;
    @Unique
    private boolean graves$hasCompass = false;
    @Unique
    private boolean graves$isInvulnerable = false;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void graves$loadNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("LastGraveId", 4)) {
            this.graves$location = nbt.method_10537("LastGraveId");
        }
        this.graves$hasCompass = nbt.method_10577("HasGraveCompass");
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void graves$writeNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.graves$location != -1L) {
            nbt.method_10544("LastGraveId", this.graves$location);
        }
        nbt.method_10556("HasGraveCompass", this.graves$hasCompass);
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void graves$copyDate(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        this.graves$hasCompass = ((ServerPlayerEntityMixin)oldPlayer).graves$hasCompass;
        this.graves$location = ((PlayerAdditions)oldPlayer).graves$lastGrave();
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void graves$setupThings(class_1282 source, CallbackInfo ci) {
        this.graves$location = -1L;
        this.graves$hasCompass = false;
    }

    @Inject(method={"onSpawn"}, at={@At(value="TAIL")})
    private void graves$onSpawn(CallbackInfo ci) {
        if (this.graves$location != -1L && !this.graves$hasCompass && ConfigManager.getConfig().interactions.giveGraveCompass) {
            this.method_31548().method_7398(GraveCompassItem.create(this.graves$location, false));
            this.graves$hasCompass = true;
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void graves$isInvulnerableTo(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.graves$isInvulnerable) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public class_2561 graves$lastDeathCause() {
        return null;
    }

    @Override
    public long graves$lastGrave() {
        return this.graves$location;
    }

    @Override
    public void graves$setLastGrave(long id) {
        this.graves$location = id;
    }

    @Override
    public void graves$setInvulnerable(boolean value) {
        this.graves$isInvulnerable = value;
    }
}

