/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.model.parts;

import com.google.common.collect.Iterables;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import eu.pb4.graves.model.parts.ModelPart;
import eu.pb4.graves.model.parts.ModelPartType;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.EntityElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2613;
import net.minecraft.class_2703;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_7828;
import org.jetbrains.annotations.Nullable;

public class EntityModelPart
extends ModelPart<EntityElement<?>, EntityModelPart> {
    @SerializedName(value="entity_type")
    public class_1299<?> entityType;
    @SerializedName(value="entity_nbt")
    @Nullable
    public class_2487 nbtCompound;
    @SerializedName(value="entity_pose")
    @Nullable
    public class_4050 entityPose;

    @Override
    public EntityElement<?> construct(class_3218 world) {
        class_1657 entity;
        Object object = entity = this.entityType == class_1299.field_6097 ? this.createPlayer((class_1937)world) : this.entityType.method_5883((class_1937)world);
        if (this.nbtCompound != null) {
            entity.method_5651(this.nbtCompound);
        }
        if (this.entityPose != null) {
            entity.method_18380(this.entityPose);
        }
        PlayerElement base = this.entityType == class_1299.field_6097 ? new PlayerElement(entity, world) : new EntityElement((class_1297)entity, world);
        base.setOffset(this.position);
        return base;
    }

    private class_1657 createPlayer(class_1937 world) {
        return new class_1657(world, class_2338.field_10980, 0.0f, new GameProfile(UUID.randomUUID(), "")){

            public class_2596<class_2602> method_18002() {
                return new class_2613((class_1657)this);
            }

            public boolean method_7325() {
                return false;
            }

            public boolean method_7337() {
                return false;
            }
        };
    }

    @Override
    public ModelPartType type() {
        return ModelPartType.ENTITY;
    }

    public static class PlayerElement
    extends EntityElement<class_1657> {
        private final int extraId = VirtualEntityUtils.requestEntityId();
        private final UUID extraUuid = UUID.randomUUID();
        private GameProfile profile;

        public PlayerElement(class_1657 entity, class_3218 world) {
            super((class_1297)entity, world);
            this.profile = new GameProfile(entity.method_5667(), "");
        }

        public IntList getEntityIds() {
            return IntList.of((int)this.extraId, (int)((class_1657)this.entity()).method_5628());
        }

        public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
            class_2703.class_2705 entry = new class_2703.class_2705(((class_1657)this.entity()).method_5667(), this.profile, false, -1, class_1934.field_9215, null, null);
            class_2703 packet = PolymerEntityUtils.createMutablePlayerListPacket(EnumSet.of(class_2703.class_5893.field_29136, class_2703.class_5893.field_29137, class_2703.class_5893.field_40700));
            packet.method_46329().add(entry);
            packetConsumer.accept((class_2596<class_2602>)packet);
            super.startWatching(player, packetConsumer);
            packetConsumer.accept((class_2596<class_2602>)new class_2604(this.extraId, this.extraUuid, ((class_1657)this.entity()).method_23317(), ((class_1657)this.entity()).method_23318(), ((class_1657)this.entity()).method_23321(), 0.0f, 0.0f, class_1299.field_42456, 0, class_243.field_1353, 0.0));
            packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)((class_1657)this.entity()).method_5628(), (int[])new int[]{this.extraId}));
        }

        public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
            super.stopWatching(player, packetConsumer);
            packetConsumer.accept((class_2596<class_2602>)new class_7828(List.of(((class_1657)this.entity()).method_5667())));
        }

        public void copyTexture(GameProfile profile) {
            Property texture = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            if (texture != null && texture.hasSignature()) {
                this.profile.getProperties().put((Object)"textures", (Object)texture);
            } else {
                this.profile.getProperties().removeAll((Object)"textures");
            }
        }
    }
}

