/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.attributeslib.ALConfig;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.attributeslib.client.AttributeModifierComponent;
import dev.shadowsoffire.attributeslib.client.ModifierSource;
import dev.shadowsoffire.attributeslib.client.ModifierSourceType;
import dev.shadowsoffire.attributeslib.mixin.accessors.AbstractContainerScreenAccessor;
import dev.shadowsoffire.attributeslib.mixin.accessors.GuiGraphicsAccessor;
import dev.shadowsoffire.placebo.PlaceboClient;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_8001;
import org.jetbrains.annotations.Nullable;

public class AttributesGui
implements class_4068,
class_364,
class_6379 {
    public static final class_2960 TEXTURES = AttributesLib.loc("textures/gui/attributes_gui.png");
    public static final int ENTRY_HEIGHT = 22;
    public static final int MAX_ENTRIES = 6;
    public static final int WIDTH = 131;
    public static boolean wasOpen = false;
    protected static float scrollOffset = 0.0f;
    protected static boolean hideUnchanged = false;
    protected final class_490 parent;
    protected final class_1657 player;
    protected final class_327 font;
    public final class_344 toggleBtn;
    protected final class_344 recipeBookButton;
    public final HideUnchangedButton hideUnchangedBtn;
    protected int leftPos;
    protected int topPos;
    protected boolean scrolling;
    protected int startIndex;
    protected List<class_1324> data;
    @Nullable
    protected class_1324 selected;
    protected boolean open;
    protected long lastRenderTick;
    private static DecimalFormat f = class_1799.field_8029;

    public AttributesGui(class_490 parent) {
        class_344 imgBtn;
        class_364 btn2;
        this.font = class_310.method_1551().field_1772;
        this.data = new ArrayList<class_1324>();
        this.selected = null;
        this.open = false;
        this.lastRenderTick = -1L;
        this.parent = parent;
        this.player = class_310.method_1551().field_1724;
        this.refreshData();
        this.leftPos = ((AbstractContainerScreenAccessor)parent).getLeftPos() - 131;
        this.topPos = ((AbstractContainerScreenAccessor)parent).getTopPos();
        this.toggleBtn = new class_344(((AbstractContainerScreenAccessor)parent).getLeftPos() + 63, ((AbstractContainerScreenAccessor)parent).getTopPos() + 10, 10, 10, 131, 0, 10, TEXTURES, 256, 256, btn -> this.toggleVisibility(), (class_2561)class_2561.method_43471((String)"zenith_attributes.gui.show_attributes")){

            public void method_25365(boolean pFocused) {
            }
        };
        this.recipeBookButton = this.parent.method_25396().size() > 1 ? ((btn2 = (class_364)this.parent.method_25396().get(0)) instanceof class_344 ? (imgBtn = (class_344)btn2) : null) : null;
        this.hideUnchangedBtn = new HideUnchangedButton(0, 0);
    }

    public void refreshData() {
        this.data.clear();
        class_7923.field_41190.method_10220().map(arg_0 -> ((class_1657)this.player).method_5996(arg_0)).filter(Objects::nonNull).filter(ai -> !ALConfig.hiddenAttributes.contains(class_7923.field_41190.method_10221((Object)ai.method_6198()))).filter(ai -> !hideUnchanged || ai.method_6201() != ai.method_6194()).filter(ai -> !Double.isNaN(ai.method_6194())).forEach(this.data::add);
        this.data.sort(this::compareAttrs);
        this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
    }

    public void toggleVisibility() {
        boolean bl = this.open = !this.open;
        if (this.open && this.parent.method_2659().method_2605()) {
            this.parent.method_2659().method_2591();
        }
        this.hideUnchangedBtn.field_22764 = this.open;
        int newLeftPos = this.open && this.parent.field_22789 >= 379 ? 177 + (this.parent.field_22789 - ((AbstractContainerScreenAccessor)this.parent).getImageWidth() - 200) / 2 : (this.parent.field_22789 - ((AbstractContainerScreenAccessor)this.parent).getImageWidth()) / 2;
        ((AbstractContainerScreenAccessor)this.parent).setLeftPos(newLeftPos);
        this.leftPos = ((AbstractContainerScreenAccessor)this.parent).getLeftPos() - 131;
        this.topPos = ((AbstractContainerScreenAccessor)this.parent).getTopPos();
        if (this.recipeBookButton != null) {
            this.recipeBookButton.method_48229(((AbstractContainerScreenAccessor)this.parent).getLeftPos() + 104, this.parent.field_22790 / 2 - 22);
        }
        this.hideUnchangedBtn.method_48229(this.leftPos + 7, this.topPos + 151);
    }

    protected int compareAttrs(class_1324 a1, class_1324 a2) {
        String name = class_1074.method_4662((String)a1.method_6198().method_26830(), (Object[])new Object[0]);
        String name2 = class_1074.method_4662((String)a2.method_6198().method_26830(), (Object[])new Object[0]);
        return name.compareTo(name2);
    }

    public boolean method_25405(double pMouseX, double pMouseY) {
        if (!this.open) {
            return false;
        }
        return this.isHovering(0, 0, 131, 166, pMouseX, pMouseY);
    }

    public void method_25394(class_332 gfx, int mouseX, int mouseY, float partialTicks) {
        this.toggleBtn.method_46421(((AbstractContainerScreenAccessor)this.parent).getLeftPos() + 63);
        this.toggleBtn.method_46419(((AbstractContainerScreenAccessor)this.parent).getTopPos() + 10);
        if (this.parent.method_2659().method_2605()) {
            this.open = false;
        }
        wasOpen = this.open;
        if (!this.open) {
            return;
        }
        if (this.lastRenderTick != PlaceboClient.ticks) {
            this.lastRenderTick = PlaceboClient.ticks;
            this.refreshData();
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURES);
        int left = this.leftPos;
        int top = this.topPos;
        gfx.method_25302(TEXTURES, left, top, 0, 0, 131, 166);
        int scrollbarPos = (int)(117.0f * scrollOffset);
        gfx.method_25302(TEXTURES, left + 111, top + 16 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 6 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.leftPos + 8, this.topPos + 16 + 22 * (idx - this.startIndex), mouseX, mouseY);
        }
        this.renderTooltip(gfx, mouseX, mouseY);
        gfx.method_51439(this.font, (class_2561)class_2561.method_43471((String)"zenith_attributes.gui.attributes"), this.leftPos + 8, this.topPos + 5, 0x404040, false);
        gfx.method_51439(this.font, (class_2561)class_2561.method_43470((String)"Hide Unchanged"), this.leftPos + 20, this.topPos + 152, 0x404040, false);
    }

    protected void renderTooltip(class_332 gfx, int mouseX, int mouseY) {
        class_1324 inst = this.getHoveredSlot(mouseX, mouseY);
        if (inst != null) {
            boolean isDynamic = class_7923.field_41190.method_47983((Object)inst.method_6198()).method_40220(ALObjects.Tags.DYNAMIC_BASE_ATTRIBUTES);
            class_1320 attr = inst.method_6198();
            IFormattableAttribute fAttr = (IFormattableAttribute)attr;
            ArrayList<Object> list = new ArrayList<Object>();
            class_5250 name = class_2561.method_43471((String)attr.method_26830()).method_27696(class_2583.field_24360.method_10977(class_124.field_1065).method_30938(Boolean.valueOf(true)));
            if (isDynamic) {
                name.method_10852((class_2561)class_2561.method_43470((String)" (dynamic)").method_27696(class_2583.field_24360.method_10977(class_124.field_1063).method_30938(Boolean.valueOf(false))));
            }
            if (AttributesLib.getTooltipFlag().method_8035()) {
                class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080).method_30938(Boolean.valueOf(false));
                name.method_10852((class_2561)class_2561.method_43470((String)(" [" + class_7923.field_41190.method_10221((Object)attr) + "]")).method_27696(style));
            }
            list.add(name);
            String key = attr.method_26830() + ".desc";
            if (class_1074.method_4663((String)key)) {
                txt = class_2561.method_43471((String)key).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056});
                list.add(txt);
            } else if (AttributesLib.getTooltipFlag().method_8035()) {
                txt = class_2561.method_43470((String)key).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
                list.add(txt);
            }
            class_124 color = class_124.field_1080;
            if (attr instanceof class_1329) {
                if (inst.method_6194() > inst.method_6201()) {
                    color = class_124.field_1054;
                } else if (inst.method_6194() < inst.method_6201()) {
                    color = class_124.field_1061;
                }
            }
            class_5250 valueComp = fAttr.toValueComponent(null, inst.method_6194(), AttributesLib.getTooltipFlag()).method_27692(color);
            class_5250 baseComp = fAttr.toValueComponent(null, inst.method_6201(), AttributesLib.getTooltipFlag()).method_27692(class_124.field_1080);
            if (!isDynamic) {
                list.add(class_5244.field_39003);
                list.add(class_2561.method_43469((String)"zenith_attributes.gui.current", (Object[])new Object[]{valueComp}).method_27692(class_124.field_1080));
                class_5250 base = class_2561.method_43469((String)"zenith_attributes.gui.base", (Object[])new Object[]{baseComp}).method_27692(class_124.field_1080);
                if (attr instanceof class_1329) {
                    class_1329 ra = (class_1329)attr;
                    class_5250 min = fAttr.toValueComponent(null, ra.method_35061(), AttributesLib.getTooltipFlag());
                    min = class_2561.method_43469((String)"zenith_attributes.gui.min", (Object[])new Object[]{min});
                    class_5250 class_52503 = fAttr.toValueComponent(null, ra.method_35062(), AttributesLib.getTooltipFlag());
                    class_52503 = class_2561.method_43469((String)"zenith_attributes.gui.max", (Object[])new Object[]{class_52503});
                    list.add(class_2561.method_43469((String)"%s \u2507 %s \u2507 %s", (Object[])new Object[]{base, min, class_52503}).method_27692(class_124.field_1080));
                } else {
                    list.add(base);
                }
            }
            ArrayList<class_5684> finalTooltip = new ArrayList<class_5684>(list.size());
            for (Object txt : list) {
                this.addComp((class_2561)txt, finalTooltip);
            }
            if (inst.method_6195().stream().anyMatch(modif -> modif.method_6186() != 0.0)) {
                this.addComp(class_5244.field_39003, finalTooltip);
                this.addComp((class_2561)class_2561.method_43471((String)"zenith_attributes.gui.modifiers").method_27692(class_124.field_1065), finalTooltip);
                HashMap modifiersToSources = new HashMap();
                for (ModifierSourceType modifierSourceType : ModifierSourceType.getTypes()) {
                    modifierSourceType.extract((class_1309)this.player, (modif, source) -> modifiersToSources.put(modif.method_6189(), (ModifierSource<?>)source));
                }
                class_5250[] opValues = new class_5250[3];
                double[] dArray = new double[3];
                for (class_1322.class_1323 op : class_1322.class_1323.values()) {
                    class_5250 comp;
                    double threshold;
                    ArrayList<class_1322> modifiers = new ArrayList<class_1322>(inst.method_6193(op));
                    double opValue = modifiers.stream().mapToDouble(class_1322::method_6186).reduce(op == class_1322.class_1323.field_6331 ? 1.0 : 0.0, (res, elem) -> op == class_1322.class_1323.field_6331 ? res * (1.0 + elem) : res + elem);
                    modifiers.sort(ModifierSourceType.compareBySource(modifiersToSources));
                    for (class_1322 modif2 : modifiers) {
                        if (modif2.method_6186() == 0.0) continue;
                        class_5250 comp2 = fAttr.toComponent(modif2, AttributesLib.getTooltipFlag());
                        ModifierSource src = (ModifierSource)modifiersToSources.get(modif2.method_6189());
                        finalTooltip.add(new AttributeModifierComponent(src, (class_5348)comp2, this.font, this.leftPos - 16));
                    }
                    color = class_124.field_1080;
                    double d = threshold = op == class_1322.class_1323.field_6331 ? 1.0005 : 5.0E-4;
                    if (opValue > threshold) {
                        color = class_124.field_1054;
                    } else if (opValue < -threshold) {
                        color = class_124.field_1061;
                    }
                    class_5250 valueComp2 = fAttr.toValueComponent(op, opValue, AttributesLib.getTooltipFlag()).method_27692(color);
                    opValues[op.ordinal()] = comp = class_2561.method_43469((String)("zenith_attributes.gui." + op.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{valueComp2}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
                    dArray[op.ordinal()] = opValue;
                }
                this.addComp(class_5244.field_39003, finalTooltip);
                this.addComp((class_2561)class_2561.method_43470((String)"Modifier Formula").method_27692(class_124.field_1065), finalTooltip);
                class_5250 base = isDynamic ? class_2561.method_43471((String)"attributeslib.gui.formula.base") : baseComp;
                class_5250 value = isDynamic ? class_2561.method_43471((String)"attributeslib.gui.formula.value") : valueComp;
                class_2561 formula = AttributesGui.buildFormula((class_2561)base, (class_2561)value, dArray);
                this.addComp(formula, finalTooltip);
            } else if (isDynamic) {
                this.addComp(class_5244.field_39003, finalTooltip);
                this.addComp((class_2561)class_2561.method_43471((String)"attributeslib.gui.no_modifiers").method_27692(class_124.field_1065), finalTooltip);
            }
            ((GuiGraphicsAccessor)gfx).callRenderTooltipInternal(this.font, finalTooltip, this.leftPos - 16 - finalTooltip.stream().map(c -> c.method_32664(this.font)).max(Integer::compare).get(), mouseY, class_8001.field_41687);
        }
    }

    private void addComp(class_2561 comp, List<class_5684> finalTooltip) {
        if (comp == class_5244.field_39003) {
            finalTooltip.add(class_5684.method_32662((class_5481)comp.method_30937()));
        } else {
            for (class_5348 fTxt : this.font.method_27527().method_27495((class_5348)comp, this.leftPos - 16, comp.method_10866())) {
                finalTooltip.add(class_5684.method_32662((class_5481)class_2477.method_10517().method_30934(fTxt)));
            }
        }
    }

    private void renderEntry(class_332 gfx, class_1324 inst, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.getHoveredSlot(mouseX, mouseY) == inst;
        gfx.method_25302(TEXTURES, x, y, 142, hover ? 22 : 0, 100, 22);
        class_5250 txt = class_2561.method_43471((String)inst.method_6198().method_26830());
        int splitWidth = 60;
        List lines = this.font.method_1728((class_5348)txt, splitWidth);
        while (lines.size() > 2) {
            lines = this.font.method_1728((class_5348)txt, splitWidth += 10);
        }
        class_4587 stack = gfx.method_51448();
        stack.method_22903();
        float scale = 1.0f;
        int maxWidth = lines.stream().map(arg_0 -> ((class_327)this.font).method_30880(arg_0)).max(Integer::compareTo).get();
        if (maxWidth > 66) {
            scale = 66.0f / (float)maxWidth;
            stack.method_22905(scale, scale, 1.0f);
        }
        for (int i = 0; i < lines.size(); ++i) {
            class_5481 line = (class_5481)lines.get(i);
            float width = (float)this.font.method_30880(line) * scale;
            float lineX = ((float)(x + 1) + (68.0f - width) / 2.0f) / scale;
            float lineY = (float)(y + (lines.size() == 1 ? 7 : 2) + i * 10) / scale;
            gfx.method_51430(this.font, line, (int)lineX, (int)lineY, 0x404040, false);
        }
        stack.method_22909();
        stack.method_22903();
        IFormattableAttribute attr = (IFormattableAttribute)inst.method_6198();
        class_5250 value = attr.toValueComponent(null, inst.method_6194(), (class_1836)class_1836.class_1837.field_41070);
        if (class_7923.field_41190.method_47983((Object)inst.method_6198()).method_40220(ALObjects.Tags.DYNAMIC_BASE_ATTRIBUTES)) {
            value = class_2561.method_43470((String)"\ufffd");
        }
        scale = 1.0f;
        if (this.font.method_27525((class_5348)value) > 27) {
            scale = 27.0f / (float)this.font.method_27525((class_5348)value);
            stack.method_22905(scale, scale, 1.0f);
        }
        int color = 0xFFFFFF;
        if (attr instanceof class_1329) {
            if (inst.method_6194() > inst.method_6201()) {
                color = 0x55DD55;
            } else if (inst.method_6194() < inst.method_6201()) {
                color = 0xFF6060;
            }
        }
        gfx.method_51439(this.font, (class_2561)value, (int)(((float)(x + 72) + (27.0f - (float)this.font.method_27525((class_5348)value) * scale) / 2.0f) / scale), (int)((float)(y + 7) / scale), color, true);
        stack.method_22909();
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (!this.open || !this.isScrollBarActive()) {
            return false;
        }
        this.scrolling = false;
        int left = this.leftPos + 111;
        int top = this.topPos + 15;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 155)) {
            this.scrolling = true;
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = class_3532.method_15363((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.open) {
            return false;
        }
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = class_3532.method_15363((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (!this.open) {
            return false;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffScreenRows();
            scrollOffset = (float)((double)scrollOffset - pDelta / (double)i);
            scrollOffset = class_3532.method_15363((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)i) + 0.5);
            return true;
        }
        return false;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 6;
    }

    protected int getOffScreenRows() {
        return Math.max(0, this.data.size() - 6);
    }

    @Nullable
    public class_1324 getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 6; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.isHovering(8, 14 + 22 * i, 100, 22, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    public static class_2561 buildFormula(class_2561 base, class_2561 value, double[] numericValues) {
        class_124 color;
        Object withParens;
        double add = numericValues[0];
        double mulBase = numericValues[1];
        double mulTotal = numericValues[2];
        boolean isAddNeg = add < 0.0;
        boolean isMulNeg = mulBase < 0.0;
        String addSym = isAddNeg ? "-" : "+";
        add = Math.abs(add);
        String mulBaseSym = isMulNeg ? "-" : "+";
        mulBase = Math.abs(mulBase);
        String addStr = f.format(add);
        String mulBaseStr = f.format(mulBase);
        String mulTotalStr = f.format(mulTotal);
        Object formula = "%2$s";
        if (add != 0.0) {
            class_124 color2 = isAddNeg ? class_124.field_1061 : class_124.field_1054;
            formula = (String)formula + " " + AttributesGui.colored(addSym + " " + addStr, color2);
        }
        if (mulBase != 0.0) {
            withParens = add == 0.0 ? formula : "(%s)".formatted(formula);
            color = isMulNeg ? class_124.field_1061 : class_124.field_1054;
            formula = (String)withParens + " " + AttributesGui.colored(mulBaseSym + " " + mulBaseStr + " * ", color) + (String)withParens;
        }
        if (mulTotal != 1.0) {
            withParens = add == 0.0 && mulBase == 0.0 ? formula : "(%s)".formatted(formula);
            color = mulTotal < 1.0 ? class_124.field_1061 : class_124.field_1054;
            formula = AttributesGui.colored(mulTotalStr + " * ", color) + (String)withParens;
        }
        return class_2561.method_43469((String)("%1$s = " + (String)formula), (Object[])new Object[]{value, base}).method_27692(class_124.field_1080);
    }

    private static String colored(String str, class_124 color) {
        return "\u00a7" + color.method_36145() + str + "\u00a7" + class_124.field_1070.method_36145();
    }

    public class_6379.class_6380 method_37018() {
        return null;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public void method_25365(boolean pFocused) {
    }

    public boolean method_25370() {
        return false;
    }

    public boolean method_37303() {
        return false;
    }

    public class HideUnchangedButton
    extends class_344 {
        public HideUnchangedButton(int pX, int pY) {
            super(pX, pY, 10, 10, 131, 20, 10, TEXTURES, 256, 256, null, (class_2561)class_2561.method_43470((String)"Hide Unchanged Attributes"));
            this.field_22764 = false;
        }

        public void method_25306() {
            hideUnchanged = !hideUnchanged;
        }

        public void method_48579(class_332 gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int vOffset;
            int u = 131;
            int v = 20;
            int n = vOffset = hideUnchanged ? 0 : 10;
            if (this.field_22762) {
                vOffset += 20;
            }
            RenderSystem.enableDepthTest();
            class_4587 pose = gfx.method_51448();
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, 100.0f);
            gfx.method_25290(TEXTURES, this.method_46426(), this.method_46427(), (float)u, (float)(v + vOffset), 10, 10, 256, 256);
            pose.method_22909();
        }
    }
}

