/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.impl;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import dev.shadowsoffire.attributeslib.ALConfig;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.attributeslib.api.events.LivingHealEvent;
import dev.shadowsoffire.attributeslib.api.events.LivingHurtEvent;
import dev.shadowsoffire.attributeslib.commands.ModifierCommand;
import dev.shadowsoffire.attributeslib.compat.ModCompat;
import dev.shadowsoffire.attributeslib.components.BooleanComponent;
import dev.shadowsoffire.attributeslib.components.ZenithAttributesComponents;
import dev.shadowsoffire.attributeslib.packet.CritParticleMessage;
import dev.shadowsoffire.attributeslib.util.AttributesUtil;
import dev.shadowsoffire.attributeslib.util.FlyingAbility;
import dev.shadowsoffire.placebo.events.ReloadableServerEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3302;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8110;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

public class AttributeEvents {
    private static boolean noRecurse = false;
    private static Random dodgeRand = new Random();

    private static boolean canBenefitFromDrawSpeed(class_1799 stack) {
        return stack.method_7909() instanceof class_1811 || stack.method_7909() instanceof class_1835;
    }

    public static void init() {
        AttributeEvents.elytra();
        AttributeEvents.lifeStealOverheal();
        AttributeEvents.meleeDamageAttributes();
        AttributeEvents.apothCriticalStrike();
        AttributeEvents.breakSpd();
        AttributeEvents.heal();
        AttributeEvents.dodgeMelee();
        AttributeEvents.dodgeProjectile();
        AttributeEvents.affixModifiers();
        AttributeEvents.commands();
        AttributeEvents.reloads();
        ModCompat.init();
        FlyingAbility.initZenithFlyingAbility();
    }

    public static void elytra() {
        EntityElytraEvents.CUSTOM.register((entity, tickElytra) -> {
            class_1799 chestplate = entity.method_6118(class_1304.field_6174);
            if (chestplate.method_7909() instanceof class_1770) {
                return false;
            }
            return entity.method_26825(ALObjects.Attributes.ELYTRA_FLIGHT) > 0.0;
        });
    }

    public static int drawSpeed(class_1297 entity, class_1799 usingItem, int useItemRemaining) {
        if (entity instanceof class_1657) {
            int mod;
            class_1657 player = (class_1657)entity;
            double t = player.method_26825(ALObjects.Attributes.DRAW_SPEED) - 1.0;
            if (t == 0.0 || !AttributeEvents.canBenefitFromDrawSpeed(usingItem)) {
                return useItemRemaining;
            }
            int offset = -1;
            if (t < 0.0) {
                offset = 1;
                t = -t;
            }
            if (t > 1.0) {
                t -= 1.0;
                return useItemRemaining + offset;
            }
            if (t > 0.5) {
                if (player.field_6012 % 2 == 0) {
                    return useItemRemaining + offset;
                }
                t -= 0.5;
            }
            if (entity.field_6012 % (mod = (int)Math.floor(1.0 / Math.min(1.0, t))) == 0) {
                return useItemRemaining + offset;
            }
            t -= 1.0;
        }
        return useItemRemaining;
    }

    public static void lifeStealOverheal() {
        LivingHurtEvent.EVENT.register((source, damaged, amount) -> {
            class_1297 patt5599$temp = source.method_5526();
            if (patt5599$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt5599$temp;
                if (AttributesUtil.isPhysicalDamage(source)) {
                    float lifesteal = (float)attacker.method_26825(ALObjects.Attributes.LIFE_STEAL);
                    float dmg = Math.min(amount, attacker.method_6032());
                    if ((double)lifesteal > 0.001) {
                        attacker.method_6025(dmg * lifesteal);
                    }
                    float overheal = (float)attacker.method_26825(ALObjects.Attributes.OVERHEAL);
                    float maxOverheal = attacker.method_6063() * 0.5f;
                    if (overheal > 0.0f && attacker.method_6067() < maxOverheal) {
                        attacker.method_6073(Math.min(maxOverheal, attacker.method_6067() + dmg * overheal));
                    }
                }
            }
            return amount;
        });
    }

    public static void meleeDamageAttributes() {
        LivingHurtEvent.EVENT.register((source, damaged, amount) -> {
            if (damaged.method_37908().field_9236 || damaged.method_29504()) {
                return amount;
            }
            if (noRecurse) {
                return amount;
            }
            noRecurse = true;
            class_1297 patt7177$temp = source.method_5526();
            if (patt7177$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt7177$temp;
                if (AttributesUtil.isPhysicalDamage(source)) {
                    float hpDmg = (float)attacker.method_26825(ALObjects.Attributes.CURRENT_HP_DAMAGE);
                    float fireDmg = (float)attacker.method_26825(ALObjects.Attributes.FIRE_DAMAGE);
                    float coldDmg = (float)attacker.method_26825(ALObjects.Attributes.COLD_DAMAGE);
                    int time = damaged.field_6008;
                    damaged.field_6008 = 0;
                    if ((double)hpDmg > 0.001 && AttributesLib.localAtkStrength >= 0.85f) {
                        damaged.method_5643(AttributeEvents.src(ALObjects.DamageTypes.CURRENT_HP_DAMAGE, attacker), AttributesLib.localAtkStrength * hpDmg * damaged.method_6032());
                    }
                    damaged.field_6008 = 0;
                    if ((double)fireDmg > 0.001 && AttributesLib.localAtkStrength >= 0.55f) {
                        damaged.method_5643(AttributeEvents.src(ALObjects.DamageTypes.FIRE_DAMAGE, attacker), AttributesLib.localAtkStrength * fireDmg);
                        damaged.method_20803(damaged.method_20802() + (int)(10.0f * fireDmg));
                    }
                    damaged.field_6008 = 0;
                    if ((double)coldDmg > 0.001 && AttributesLib.localAtkStrength >= 0.55f) {
                        damaged.method_5643(AttributeEvents.src(ALObjects.DamageTypes.COLD_DAMAGE, attacker), AttributesLib.localAtkStrength * coldDmg);
                        damaged.method_6092(new class_1293(class_1294.field_5909, (int)(15.0f * coldDmg), class_3532.method_15375((float)(coldDmg / 5.0f))));
                    }
                    damaged.field_6008 = time;
                    if (damaged.method_29504()) {
                        damaged.getCustomData().method_10556("zenith.killed_by_aux_dmg", true);
                    }
                }
            }
            noRecurse = false;
            return amount;
        });
    }

    private static class_1282 src(class_5321<class_8110> type, class_1309 entity) {
        return entity.method_37908().method_48963().method_48796(type, (class_1297)entity);
    }

    public static void apothCriticalStrike() {
        LivingHurtEvent.EVENT.register((source, damaged, amount) -> {
            class_1309 le;
            class_1309 attacker;
            class_1297 class_12972 = source.method_5529();
            class_1309 class_13092 = attacker = class_12972 instanceof class_1309 ? (le = (class_1309)class_12972) : null;
            if (attacker == null) {
                return amount;
            }
            double critChance = attacker.method_26825(ALObjects.Attributes.CRIT_CHANCE);
            class_5819 rand = damaged.method_6051();
            float critMult = 1.0f;
            for (float critDmg = 1.0f + (float)attacker.method_26825(AdditionalEntityAttributes.CRITICAL_BONUS_DAMAGE); (double)rand.method_43057() <= critChance && critDmg > 0.0f; critDmg *= 0.85f) {
                critChance -= 1.0;
                critMult *= critDmg;
            }
            amount *= critMult;
            if (critMult > 1.0f && !attacker.method_37908().field_9236 && attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                CritParticleMessage.sendTo(damaged.method_5628(), player);
            }
            return amount;
        });
    }

    public static void breakSpd() {
        PlayerEvents.BREAK_SPEED.register(event -> event.setNewSpeed(event.getOriginalSpeed() * (float)event.getPlayer().method_26825(ALObjects.Attributes.MINING_SPEED)));
    }

    public static void heal() {
        LivingHealEvent.EVENT.register((entity, amount) -> {
            if (!(entity instanceof class_1657)) {
                return amount;
            }
            class_1657 player = (class_1657)entity;
            float factor = (float)player.method_26825(ALObjects.Attributes.HEALING_RECEIVED);
            return amount * factor;
        });
    }

    public static double modifyArrowDamage(class_1665 arrow, class_1309 shooter, double baseDamage) {
        if (((BooleanComponent)ZenithAttributesComponents.ARROW_DAMAGE_DONE.get((Object)arrow)).getValue()) {
            return baseDamage;
        }
        double arrowDamage = shooter.method_26825(ALObjects.Attributes.ARROW_DAMAGE);
        if (!Double.isNaN(arrowDamage)) {
            baseDamage *= arrowDamage;
        }
        ((BooleanComponent)ZenithAttributesComponents.ARROW_DAMAGE_DONE.get((Object)arrow)).setValue(true);
        return baseDamage;
    }

    public static void modifyArrowVelocity(Args args, class_1665 arrow, float velocity) {
        class_1309 le;
        double arrowVelocity;
        if (arrow.method_37908().field_9236) {
            return;
        }
        if (((BooleanComponent)ZenithAttributesComponents.ARROW_VELOCITY_DONE.get((Object)arrow)).getValue()) {
            return;
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_1309 && !Double.isNaN(arrowVelocity = (le = (class_1309)class_12972).method_26825(ALObjects.Attributes.ARROW_VELOCITY))) {
            args.set(3, (Object)Float.valueOf((float)((double)velocity * arrowVelocity)));
        }
        ((BooleanComponent)ZenithAttributesComponents.ARROW_VELOCITY_DONE.get((Object)arrow)).setValue(true);
    }

    private static double getAttackReachSqr(class_1297 attacker, class_1309 pAttackTarget) {
        return attacker.method_17681() * 2.0f * attacker.method_17681() * 2.0f + pAttackTarget.method_17681();
    }

    public static void dodgeMelee() {
        LivingHurtEvent.EVENT.register((source, damaged, amount) -> {
            if (damaged.method_37908().field_9236) {
                return amount;
            }
            class_1297 attacker = source.method_5526();
            if (attacker instanceof class_1309) {
                double atkRangeSqr;
                if (!damaged.method_6127().method_27306(ALObjects.Attributes.DODGE_CHANCE)) {
                    return amount;
                }
                if (attacker instanceof class_1657) {
                    class_1657 p = (class_1657)attacker;
                    v0 = AttributeEvents.getReach(p) * AttributeEvents.getReach(p);
                } else {
                    v0 = atkRangeSqr = AttributeEvents.getAttackReachSqr(attacker, damaged);
                }
                if (attacker.method_5858((class_1297)damaged) <= atkRangeSqr && AttributeEvents.isDodging(damaged)) {
                    AttributeEvents.onDodge(damaged);
                    return 0.0f;
                }
            }
            return amount;
        });
    }

    private static double getReach(class_1657 entity) {
        double range = entity.method_26825(ReachEntityAttributes.ATTACK_RANGE);
        return range == 0.0 ? 0.0 : range + (double)(entity.method_7337() ? 3 : 0);
    }

    public static void dodgeProjectile() {
        EntityEvents.PROJECTILE_IMPACT.register(event -> {
            class_1309 lvTarget;
            class_1297 target;
            class_239 class_2392 = event.getRayTraceResult();
            if (class_2392 instanceof class_3966) {
                class_3966 entRes = (class_3966)class_2392;
                v0 = entRes.method_17782();
            } else {
                v0 = target = null;
            }
            if (target instanceof class_1309 && AttributeEvents.isDodging(lvTarget = (class_1309)target)) {
                AttributeEvents.onDodge(lvTarget);
                event.setCanceled(true);
            }
        });
    }

    public static int computeDodgeSeed(class_1309 target) {
        int delta = -1640531527;
        int base = target.field_6012 + target.method_5667().hashCode();
        return base + delta + (base << 6) + (base >> 2);
    }

    public static boolean isDodging(class_1309 target) {
        double chance = target.method_26825(ALObjects.Attributes.DODGE_CHANCE);
        dodgeRand.setSeed(AttributeEvents.computeDodgeSeed(target));
        return (double)dodgeRand.nextFloat() <= chance;
    }

    private static void onDodge(class_1309 target) {
        target.method_37908().method_43129(null, (class_1297)target, ALObjects.Sounds.DODGE, class_3419.field_15254, 1.0f, 0.7f + target.method_6051().method_43057() * 0.3f);
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sl = (class_3218)class_19372;
            double height = target.method_17682();
            double width = target.method_17681();
            sl.method_14199((class_2394)class_2398.field_11237, target.method_23317() - width / 4.0, target.method_23318(), target.method_23321() - width / 4.0, 6, -width / 4.0, height / 8.0, -width / 4.0, 0.0);
        }
    }

    public static void affixModifiers() {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, attributeModifiers) -> {
            boolean customElytraItem;
            boolean hasBaseAD = attributeModifiers.get((Object)class_5134.field_23721).stream().filter(m -> ((IFormattableAttribute)class_5134.field_23721).getBaseUUID().equals(m.method_6189())).findAny().isPresent();
            if (hasBaseAD) {
                boolean hasBaseAR = false;
                if (attributeModifiers.containsKey((Object)ReachEntityAttributes.REACH)) {
                    hasBaseAR = attributeModifiers.get((Object)ReachEntityAttributes.REACH).stream().anyMatch(m -> Objects.equals(((IFormattableAttribute)ReachEntityAttributes.REACH).getBaseUUID(), m.method_6189()));
                }
                if (!hasBaseAR) {
                    attributeModifiers.put((Object)ReachEntityAttributes.REACH, (Object)new class_1322(AttributeHelper.BASE_ENTITY_REACH, () -> "zenith_attributes:fake_base_range", 0.0, class_1322.class_1323.field_6328));
                }
            }
            try {
                FabricElytraItem fabricElytraItem;
                class_1792 patt17714$temp = stack.method_7909();
                customElytraItem = patt17714$temp instanceof FabricElytraItem && (fabricElytraItem = (FabricElytraItem)patt17714$temp).useCustomElytra(null, stack, false);
            }
            catch (NullPointerException e) {
                customElytraItem = false;
            }
            if (slot == class_1304.field_6174 && (customElytraItem || stack.method_7909() instanceof class_1770) && !attributeModifiers.containsKey((Object)ALObjects.Attributes.ELYTRA_FLIGHT)) {
                attributeModifiers.put((Object)ALObjects.Attributes.ELYTRA_FLIGHT, (Object)new class_1322(AttributeHelper.ELYTRA_FLIGHT_UUID, () -> "zenith_attributes:elytra_item_flight", 1.0, class_1322.class_1323.field_6328));
            }
        });
    }

    public static void commands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder root = class_2170.method_9247((String)"zenith_attributes");
            ModifierCommand.register((LiteralArgumentBuilder<class_2168>)root);
            dispatcher.register(root);
        });
    }

    public static void reloads() {
        ReloadableServerEvent.addListeners((class_3302)ALConfig.makeReloader());
    }
}

