/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureEvents;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.boss.BossEvents;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.boss.Exclusion;
import dev.shadowsoffire.apotheosis.adventure.boss.MinibossRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixConvertLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixHookLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.net.RadialStateChangeMessage;
import dev.shadowsoffire.apotheosis.adventure.socket.AddSocketsRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketingRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.UnnamingRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.WithdrawalRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.spawner.RogueSpawnerRegistry;
import dev.shadowsoffire.apotheosis.util.AffixItemIngredient;
import dev.shadowsoffire.apotheosis.util.GemIngredient;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.placebo.config.Configuration;
import io.github.fabricators_of_create.porting_lib.loot.PortingLibLoot;
import java.io.File;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8060;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdventureModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Zenith : Adventure");
    public static final boolean STAGES_LOADED = FabricLoader.getInstance().isModLoaded("gamestages");

    public static void init() {
        AdventureModule.reload(false);
        AdventureEvents.init();
        Adventure.bootstrap();
        BossEvents.INSTANCE.init();
        RarityRegistry.INSTANCE.register();
        AffixRegistry.INSTANCE.register();
        GemRegistry.INSTANCE.register();
        AffixLootRegistry.INSTANCE.register();
        BossRegistry.INSTANCE.register();
        RogueSpawnerRegistry.INSTANCE.register();
        MinibossRegistry.INSTANCE.register();
        class_2378.method_10230((class_2378)class_7923.field_41133, (class_2960)Apotheosis.loc("random_affix_item"), (Object)AffixLootPoolEntry.TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41133, (class_2960)Apotheosis.loc("random_gem"), (Object)GemLootPoolEntry.TYPE);
        Exclusion.initSerializers();
        GemBonus.initCodecs();
        RadialStateChangeMessage.init();
        CustomIngredientSerializer.register((CustomIngredientSerializer)GemIngredient.Serializer.INSTANCE);
        CustomIngredientSerializer.register((CustomIngredientSerializer)AffixItemIngredient.Serializer.INSTANCE);
        AdventureModule.structureDatapack();
        AdventureModule.serializers();
        AdventureModule.blocks();
        AdventureModule.items();
        AdventureModule.miscRegistration();
    }

    public static void blocks() {
        Apoth.registerBlock(Adventure.Blocks.REFORGING_TABLE, "reforging_table");
        Apoth.registerBlock(Adventure.Blocks.BOSS_SPAWNER, "boss_spawner");
        Apoth.registerBlock((class_2248)Adventure.Blocks.GEM_CUTTING_TABLE, "gem_cutting_table");
        Apoth.registerBlock(Adventure.Blocks.SIMPLE_REFORGING_TABLE, "simple_reforging_table");
        Apoth.registerBlock(Adventure.Blocks.SALVAGING_TABLE, "salvaging_table");
        Apoth.registerBlock(Adventure.Blocks.AUGMENTING_TABLE, "augmenting_table");
    }

    public static void items() {
        Apoth.registerItem(Adventure.Items.COMMON_MATERIAL, "common_material");
        Apoth.registerItem(Adventure.Items.UNCOMMON_MATERIAL, "uncommon_material");
        Apoth.registerItem(Adventure.Items.RARE_MATERIAL, "rare_material");
        Apoth.registerItem(Adventure.Items.EPIC_MATERIAL, "epic_material");
        Apoth.registerItem(Adventure.Items.MYTHIC_MATERIAL, "mythic_material");
        Apoth.registerItem(Adventure.Items.ANCIENT_MATERIAL, "ancient_material");
        Apoth.registerItem(Adventure.Items.GEM_DUST, "gem_dust");
        Apoth.registerItem(Adventure.Items.GEM_FUSED_SLATE, "gem_fused_slate");
        Apoth.registerItem(Adventure.Items.SIGIL_OF_SOCKETING, "sigil_of_socketing");
        Apoth.registerItem(Adventure.Items.SIGIL_OF_WITHDRAWAL, "sigil_of_withdrawal");
        Apoth.registerItem(Adventure.Items.SIGIL_OF_REBIRTH, "sigil_of_rebirth");
        Apoth.registerItem(Adventure.Items.SIGIL_OF_ENHANCEMENT, "sigil_of_enhancement");
        Apoth.registerItem(Adventure.Items.SIGIL_OF_UNNAMING, "sigil_of_unnaming");
        Apoth.registerItem(Adventure.Items.BOSS_SUMMONER, "boss_summoner");
        Apoth.registerItem(Adventure.Items.SIMPLE_REFORGING_TABLE, "simple_reforging_table");
        Apoth.registerItem(Adventure.Items.REFORGING_TABLE, "reforging_table");
        Apoth.registerItem(Adventure.Items.SALVAGING_TABLE, "salvaging_table");
        Apoth.registerItem(Adventure.Items.GEM_CUTTING_TABLE, "gem_cutting_table");
        Apoth.registerItem(Adventure.Items.AUGMENTING_TABLE, "augmenting_table");
        Apoth.registerItem(Adventure.Items.GEM, "gem");
    }

    public static void tiles() {
    }

    public static void serializers() {
        Apoth.registerSerializer("socketing", SocketingRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("withdrawal", WithdrawalRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("unnaming", UnnamingRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("add_sockets", AddSocketsRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("salvaging", SalvagingRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("reforging", ReforgingRecipe.Serializer.INSTANCE);
    }

    public static void miscRegistration() {
        class_2378.method_10230((class_2378)((class_2378)PortingLibLoot.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()), (class_2960)Apotheosis.loc("gems"), GemLootModifier.CODEC);
        class_2378.method_10230((class_2378)((class_2378)PortingLibLoot.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()), (class_2960)Apotheosis.loc("affix_loot"), AffixLootModifier.CODEC);
        class_2378.method_10230((class_2378)((class_2378)PortingLibLoot.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()), (class_2960)Apotheosis.loc("affix_conversion"), AffixConvertLootModifier.CODEC);
        class_2378.method_10230((class_2378)((class_2378)PortingLibLoot.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()), (class_2960)Apotheosis.loc("affix_hook"), AffixHookLootModifier.CODEC);
    }

    public static void structureDatapack() {
        class_2960 id = Apotheosis.loc("structures");
        ModContainer container = AdventureModule.getModContainer(id);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)id, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
    }

    private static ModContainer getModContainer(class_2960 pack) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                if (!mod.findPath("resourcepacks/" + pack.method_12832()).isPresent()) continue;
                return mod;
            }
        }
        return (ModContainer)FabricLoader.getInstance().getModContainer(pack.method_12836()).orElseThrow();
    }

    public static void reload(boolean e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "adventure.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (!e && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (!e && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(class_2338 pos, String name) {
        if (Apotheosis.enableDebug) {
            LOGGER.info("Generated a {} at {} {} {}", (Object)name, (Object)pos.method_10263(), (Object)pos.method_10264(), (Object)pos.method_10260());
        }
    }

    public static class ApothSmithingRecipe
    extends class_8060 {
        public static final int TEMPLATE = 0;
        public static final int BASE = 1;
        public static final int ADDITION = 2;

        public ApothSmithingRecipe(class_2960 pId, class_1856 pBase, class_1856 pAddition, class_1799 pResult) {
            super(pId, class_1856.field_9017, pBase, pAddition, pResult);
        }

        public boolean method_48454(class_1799 stack) {
            return !LootCategory.forItem(stack).isNone();
        }
    }
}

