/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTile;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.RerollResultMessage;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AugmentingMenu
extends BlockEntityMenu<AugmentingTableTile> {
    public static final int UPGRADE = 0;
    public static final int REROLL = 1;
    public static final int UPGRADE_COST = 2;
    public static final int REROLL_COST = 1;
    protected final class_1657 player;
    protected class_1277 itemInv = new class_1277(1);

    public AugmentingMenu(int id, class_1661 inv, class_2540 buf) {
        this(id, inv, buf.method_10811());
    }

    public AugmentingMenu(int id, class_1661 inv, class_2338 pos) {
        super(Adventure.Menus.AUGMENTING, id, inv, pos);
        this.player = inv.field_7546;
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((class_1263)this.itemInv, 0, 16, 16, AffixHelper::hasAffixes){

            public int method_7675() {
                return 1;
            }

            public int method_7676(class_1799 pStack) {
                return 1;
            }
        });
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, (class_1263)((AugmentingTableTile)this.tile).inv, 0, 16, 41, stack -> stack.method_7909() == Adventure.Items.SIGIL_OF_ENHANCEMENT));
        this.addPlayerSlots(inv, 8, 140);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && AffixHelper.hasAffixes(stack), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.method_7909() == Adventure.Items.SIGIL_OF_ENHANCEMENT, 1, 2);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9, true);
        this.registerInvShuffleRules();
    }

    public void method_7595(class_1657 pPlayer) {
        super.method_7595(pPlayer);
        this.method_7607(pPlayer, (class_1263)this.itemInv);
    }

    public boolean method_7604(class_1657 player, int id) {
        int selected = id >> 1;
        class_1799 mainItem = this.getMainItem();
        if (mainItem.method_7960()) {
            return false;
        }
        List<AffixInstance> affixes = AugmentingMenu.computeItemAffixes(mainItem);
        if (affixes.isEmpty() || selected >= affixes.size()) {
            return false;
        }
        switch (id & 1) {
            case 0: {
                AffixInstance inst = affixes.get(selected);
                if (inst.level() >= 1.0f) {
                    return false;
                }
                class_1799 sigils = this.getSigils();
                if (!this.player.method_7337()) {
                    if (sigils.method_7947() < 2) {
                        return false;
                    }
                    sigils.method_7934(2);
                }
                AffixHelper.applyAffix(mainItem, inst.withNewLevel(inst.level() + 0.25f));
                ((class_1735)this.field_7761.get(0)).method_7673(mainItem);
                player.method_37908().method_8396(null, this.pos, class_3417.field_14858, class_3419.field_15248, 1.0f, player.method_37908().field_9229.method_43057() * 0.25f + 1.0f);
                player.method_37908().method_8396(null, this.pos, class_3417.field_26946, class_3419.field_15248, 0.34f, player.method_37908().field_9229.method_43057() * 0.2f + 0.8f);
                player.method_37908().method_8396(null, this.pos, class_3417.field_22463, class_3419.field_15248, 0.45f, player.method_37908().field_9229.method_43057() * 0.75f + 0.5f);
                return true;
            }
            case 1: {
                AffixInstance inst = affixes.get(selected);
                List<DynamicHolder<? extends Affix>> alternatives = AugmentingMenu.computeAlternatives(mainItem, inst, affixes);
                if (alternatives.isEmpty()) {
                    return false;
                }
                class_1799 sigils = this.getSigils();
                if (!this.player.method_7337()) {
                    if (sigils.method_7947() < 1) {
                        return false;
                    }
                    sigils.method_7934(1);
                }
                HashMap<DynamicHolder<? extends Affix>, AffixInstance> newAffixes = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>(AffixHelper.getAffixes(mainItem));
                newAffixes.remove(inst.affix());
                DynamicHolder<? extends Affix> newAffix = alternatives.get(player.method_6051().method_43048(alternatives.size()));
                newAffixes.put(newAffix, new AffixInstance(newAffix, mainItem, inst.rarity(), player.method_6051().method_43057()));
                AffixHelper.setAffixes(mainItem, newAffixes);
                ((class_1735)this.field_7761.get(0)).method_7673(mainItem);
                player.method_37908().method_8396(null, this.pos, class_3417.field_14858, class_3419.field_15248, 1.0f, player.method_37908().field_9229.method_43057() * 0.25f + 1.0f);
                player.method_37908().method_8396(null, this.pos, class_3417.field_26946, class_3419.field_15248, 0.34f, player.method_37908().field_9229.method_43057() * 0.2f + 0.8f);
                player.method_37908().method_8396(null, this.pos, class_3417.field_22463, class_3419.field_15248, 0.45f, player.method_37908().field_9229.method_43057() * 0.75f + 0.5f);
                this.method_7623();
                RerollResultMessage.sendTo(newAffix, this.player);
                return true;
            }
        }
        return false;
    }

    public class_1799 getMainItem() {
        return ((class_1735)this.field_7761.get(0)).method_7677();
    }

    public class_1799 getSigils() {
        return ((class_1735)this.field_7761.get(1)).method_7677();
    }

    public static List<AffixInstance> computeItemAffixes(class_1799 stack) {
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        if (affixes.isEmpty()) {
            return Collections.emptyList();
        }
        return affixes.values().stream().sorted(Comparator.comparing(inst -> inst.affix().getId())).filter(a -> !a.affix().equals(Adventure.Affixes.DURABLE)).toList();
    }

    protected static List<DynamicHolder<? extends Affix>> computeAlternatives(class_1799 stack, AffixInstance selected, List<AffixInstance> affixes) {
        return LootController.getAvailableAffixes(stack, (LootRarity)selected.rarity().get(), affixes.stream().map(AffixInstance::affix).collect(Collectors.toSet()), ((Affix)selected.affix().get()).getType());
    }
}

