/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_5250;

public class OmneticAffix
extends Affix {
    public static final Codec<OmneticAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(OmneticData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OmneticAffix::new));
    protected final Map<LootRarity, OmneticData> values;

    public OmneticAffix(Map<LootRarity, OmneticData> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        return class_2561.method_43469((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{class_2561.method_43471((String)("misc.zenith." + this.values.get((Object)rarity).name))});
    }

    public boolean harvest(class_1657 player, class_2680 state) {
        AffixInstance inst;
        class_1799 stack = player.method_6047();
        if (!stack.method_7960() && (inst = AffixHelper.getAffixes(stack).get(Adventure.Affixes.OMNETIC)) != null && inst.isValid()) {
            OmneticData data = this.values.get(inst.rarity().get());
            for (class_1799 item : data.items()) {
                if (!item.method_7951(state)) continue;
                return true;
            }
        }
        return false;
    }

    public void speed(PlayerEvents.BreakSpeed e) {
        AffixInstance inst;
        class_1799 stack = e.getEntity().method_6047();
        if (!stack.method_7960() && (inst = AffixHelper.getAffixes(stack).get(Adventure.Affixes.OMNETIC)) != null && inst.isValid()) {
            float speed = e.getOriginalSpeed();
            OmneticData data = this.values.get(inst.rarity().get());
            for (class_1799 item : data.items()) {
                speed = Math.max(OmneticAffix.getBaseSpeed(e.getEntity(), item, e.getState(), e.getPos()), speed);
            }
            e.setNewSpeed(speed);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    static float getBaseSpeed(class_1657 player, class_1799 tool, class_2680 state, class_2338 pos) {
        float f = tool.method_7924(state);
        if (f > 1.0f) {
            int i = class_1890.method_8234((class_1309)player);
            class_1799 itemstack = player.method_6047();
            if (i > 0 && !itemstack.method_7960()) {
                f += (float)(i * i + 1);
            }
        }
        if (class_1292.method_5576((class_1309)player)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)player) + 1) * 0.2f;
        }
        if (player.method_6059(class_1294.field_5901)) {
            float f1 = switch (player.method_6112(class_1294.field_5901).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                case 3 -> 8.1E-4f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        if (player.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)player)) {
            f /= 5.0f;
        }
        if (!player.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    record OmneticData(String name, class_1799[] items) {
        public static Codec<OmneticData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(OmneticData::name), (App)Codec.list((Codec)ItemAdapter.CODEC).xmap(l -> l.toArray(new class_1799[0]), Arrays::asList).fieldOf("items").forGetter(OmneticData::items)).apply((Applicative)inst, OmneticData::new));
    }
}

