/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import blue.endless.jankson.annotation.Nullable;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.cca.IntComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3417;
import net.minecraft.class_3915;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ReforgingMenu
extends PlaceboContainerMenu {
    public static final String REFORGE_SEED = "apoth_reforge_seed";
    protected final class_2338 pos;
    protected final ReforgingTableTile tile;
    protected final class_1657 player;
    protected class_1277 itemInventory = new class_1277(1);
    protected class_1277 choicesInv = new class_1277(3);
    protected final class_5819 random = new class_6677(0L);
    protected final int[] costs = new int[3];
    protected int seed = -1;

    public ReforgingMenu(int id, class_1661 inv, class_2540 buf) {
        this(id, inv, buf.method_10811());
    }

    public ReforgingMenu(int id, class_1661 inv, class_2338 pos) {
        super(Adventure.Menus.REFORGING, id, inv);
        this.player = inv.field_7546;
        this.pos = pos;
        this.tile = (ReforgingTableTile)this.level.method_8321(pos);
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((class_1263)this.itemInventory, 0, 81, 62, stack -> !LootCategory.forItem(stack).isNone()){

            public int method_7675() {
                return 1;
            }

            public int method_7676(class_1799 stack) {
                return 1;
            }
        });
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, (class_1263)this.tile.inventory, 0, 39, 40, this.tile::isValidRarityMat));
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, (class_1263)this.tile.inventory, 1, 123, 86, stack -> stack.method_7909() == Adventure.Items.SIGIL_OF_REBIRTH));
        this.method_7621(new ReforgingResultSlot((class_1263)this.choicesInv, 0, 27, 135));
        this.method_7621(new ReforgingResultSlot((class_1263)this.choicesInv, 1, 81, 135));
        this.method_7621(new ReforgingResultSlot((class_1263)this.choicesInv, 2, 135, 135));
        this.addPlayerSlots(inv, 8, 184);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !LootCategory.forItem(stack).isNone(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.tile.isValidRarityMat((class_1799)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.method_7909() == Adventure.Items.SIGIL_OF_REBIRTH, 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
        this.updateSeed();
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)2));
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, (class_1263)this.itemInventory);
    }

    protected void updateSeed() {
        int seed;
        if (this.player.getCustomData().method_10545(REFORGE_SEED)) {
            this.player.getCustomData().method_10551(REFORGE_SEED);
        }
        if ((seed = ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)this.player)).getValue()) == 0) {
            seed = this.player.method_6051().method_43054();
            ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)this.player)).setValue(seed);
        }
        this.seed = seed;
    }

    public int getMatCount() {
        return this.method_7611(1).method_7677().method_7947();
    }

    public int getSigilCount() {
        return this.method_7611(2).method_7677().method_7947();
    }

    @Nullable
    public LootRarity getRarity() {
        class_1799 s = this.method_7611(1).method_7677();
        if (s.method_7960()) {
            return null;
        }
        return RarityRegistry.getMaterialRarity(s.method_7909()).getOptional().orElse(null);
    }

    public int getSigilCost(int slot) {
        return this.costs[0] * ++slot;
    }

    public int getMatCost(int slot) {
        return this.costs[1] * ++slot;
    }

    public int getLevelCost(int slot) {
        return this.costs[2] * ++slot;
    }

    public void method_7609(class_1263 pContainer) {
        ReforgingRecipe recipe;
        LootRarity rarity = this.getRarity();
        if (rarity != null && (recipe = this.tile.getRecipeFor(rarity)) != null) {
            this.costs[0] = recipe.sigilCost();
            this.costs[1] = recipe.matCost();
            this.costs[2] = recipe.levelCost();
        }
        class_1799 input = this.method_7611(0).method_7677();
        for (int slot = 0; slot < 3; ++slot) {
            if (!input.method_7960() && rarity != null) {
                class_5819 rand = this.random;
                rand.method_43052((long)(this.seed ^ class_7923.field_41178.method_10221((Object)input.method_7909()).hashCode() + slot));
                class_1799 output = LootController.createLootItem(input.method_7972(), rarity, rand);
                this.choicesInv.method_5447(slot, output);
                continue;
            }
            this.choicesInv.method_5447(slot, class_1799.field_8037);
        }
        super.method_7609(pContainer);
        this.tile.method_5431();
    }

    public boolean method_7597(class_1657 player) {
        if (this.level.field_9236) {
            return true;
        }
        return this.level.method_8320(this.pos).method_26204() == Adventure.Blocks.REFORGING_TABLE || this.level.method_8320(this.pos).method_26204() == Adventure.Blocks.SIMPLE_REFORGING_TABLE;
    }

    public class ReforgingResultSlot
    extends class_1735 {
        public ReforgingResultSlot(class_1263 itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean method_7680(@NotNull class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 playerIn) {
            class_1799 input = ReforgingMenu.this.method_7611(0).method_7677();
            LootRarity rarity = ReforgingMenu.this.getRarity();
            ReforgingRecipe recipe = ReforgingMenu.this.tile.getRecipeFor(rarity);
            if (recipe == null || input.method_7960()) {
                return false;
            }
            int sigils = ReforgingMenu.this.getSigilCount();
            int sigilCost = ReforgingMenu.this.getSigilCost(this.getSlotIndex());
            int mats = ReforgingMenu.this.getMatCount();
            int matCost = ReforgingMenu.this.getMatCost(this.getSlotIndex());
            int levels = ReforgingMenu.this.player.field_7520;
            int levelCost = ReforgingMenu.this.getLevelCost(this.getSlotIndex());
            if (!(sigils >= sigilCost && mats >= matCost && levels >= levelCost || ReforgingMenu.this.player.method_7337())) {
                return false;
            }
            return super.method_7674(playerIn);
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            if (!player.method_37908().field_9236) {
                ReforgingMenu.this.method_7611(0).method_7673(class_1799.field_8037);
                if (!player.method_7337()) {
                    int sigilCost = ReforgingMenu.this.getSigilCost(this.getSlotIndex());
                    int matCost = ReforgingMenu.this.getMatCost(this.getSlotIndex());
                    int levelCost = ReforgingMenu.this.getLevelCost(this.getSlotIndex());
                    ReforgingMenu.this.method_7611(1).method_7677().method_7934(matCost);
                    ReforgingMenu.this.method_7611(2).method_7677().method_7934(sigilCost);
                    EnchantmentUtils.chargeExperience((class_1657)player, (int)ApothMiscUtil.getExpCostForSlot(levelCost, this.getSlotIndex()));
                }
                ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)player)).setValue(player.method_6051().method_43054());
                ReforgingMenu.this.updateSeed();
            }
            player.method_5783(class_3417.field_14858, 0.99f, player.method_37908().field_9229.method_43057() * 0.25f + 1.0f);
            player.method_5783(class_3417.field_26946, 0.34f, player.method_37908().field_9229.method_43057() * 0.2f + 0.8f);
            player.method_5783(class_3417.field_22463, 0.45f, player.method_37908().field_9229.method_43057() * 0.5f + 0.75f);
        }
    }
}

