/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossStats;
import dev.shadowsoffire.apotheosis.adventure.boss.Exclusion;
import dev.shadowsoffire.apotheosis.adventure.boss.MinibossRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.cca.BossComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.apotheosis.util.SupportingEntity;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class ApothMiniboss
implements CodecProvider<ApothMiniboss>,
WeightedDynamicRegistry.ILuckyWeighted,
WeightedDynamicRegistry.IDimensional,
GameStagesCompat.IStaged,
MinibossRegistry.IEntityMatch {
    public static final String NAME_GEN = "use_name_generation";
    public static final Codec<ApothMiniboss> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)class_5699.field_34387.fieldOf("chance").forGetter(a -> Float.valueOf(a.chance)), (App)PlaceboCodecs.nullableField((Codec)Codec.STRING, (String)"name", (Object)"").forGetter(a -> a.name), (App)PlaceboCodecs.setOf((Codec)class_7923.field_41177.method_39673()).fieldOf("entities").forGetter(a -> a.entities), (App)BossStats.CODEC.fieldOf("stats").forGetter(a -> a.stats), (App)PlaceboCodecs.nullableField((Codec)PlaceboCodecs.setOf((Codec)Codec.STRING), (String)"stages").forGetter(a -> Optional.ofNullable(a.stages)), (App)PlaceboCodecs.setOf((Codec)class_2960.field_25139).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"affixed", (Object)false).forGetter(a -> a.affixed), (App)PlaceboCodecs.nullableField((Codec)GearSet.SetPredicate.CODEC.listOf(), (String)"valid_gear_sets", Collections.emptyList()).forGetter(a -> a.gearSets), (App)PlaceboCodecs.nullableField((Codec)NBTAdapter.EITHER_CODEC, (String)"nbt").forGetter(a -> Optional.ofNullable(a.nbt)), (App)PlaceboCodecs.nullableField((Codec)SupportingEntity.CODEC.listOf(), (String)"supporting_entities", Collections.emptyList()).forGetter(a -> a.support), (App)PlaceboCodecs.nullableField(SupportingEntity.CODEC, (String)"mount").forGetter(a -> Optional.ofNullable(a.mount)), (App)PlaceboCodecs.nullableField((Codec)Exclusion.CODEC.listOf(), (String)"exclusions", Collections.emptyList()).forGetter(a -> a.exclusions), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"finalize", (Object)false).forGetter(a -> a.finalize)).apply((Applicative)inst, ApothMiniboss::new));
    protected final int weight;
    protected final float quality;
    protected final float chance;
    protected final String name;
    protected final Set<class_1299<?>> entities;
    protected final BossStats stats;
    @Nullable
    protected final Set<String> stages;
    protected final Set<class_2960> dimensions;
    protected final boolean affixed;
    protected final List<GearSet.SetPredicate> gearSets;
    @Nullable
    protected final class_2487 nbt;
    protected final List<SupportingEntity> support;
    @Nullable
    protected final SupportingEntity mount;
    protected final List<Exclusion> exclusions;
    protected final boolean finalize;

    public ApothMiniboss(int weight, float quality, float chance, String name, Set<class_1299<?>> entities, BossStats stats, Optional<Set<String>> stages, Set<class_2960> dimensions, boolean affixed, List<GearSet.SetPredicate> gearSets, Optional<class_2487> nbt, List<SupportingEntity> support, Optional<SupportingEntity> mount, List<Exclusion> exclusions, boolean finalize) {
        this.weight = weight;
        this.quality = quality;
        this.chance = chance;
        this.name = name;
        this.entities = entities;
        this.stats = stats;
        this.stages = stages.orElse(null);
        this.dimensions = dimensions;
        this.affixed = affixed;
        this.gearSets = gearSets;
        this.nbt = nbt.orElse(null);
        this.support = support;
        this.mount = mount.orElse(null);
        this.exclusions = exclusions;
        this.finalize = finalize;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public Set<class_1299<?>> getEntities() {
        return this.entities;
    }

    public void transformMiniboss(class_5425 level, class_1308 mob, class_5819 random, float luck) {
        class_243 pos = mob.method_30950(0.0f);
        if (this.nbt != null && this.nbt.method_10545("Passengers")) {
            class_2499 passengers = this.nbt.method_10554("Passengers", 10);
            for (int i = 0; i < passengers.size(); ++i) {
                class_1297 entity = class_1299.method_17842((class_2487)passengers.method_10602(i), (class_1937)level.method_8410(), Function.identity());
                if (entity == null) continue;
                entity.method_5873((class_1297)mob, true);
            }
        }
        mob.method_33574(pos);
        this.initBoss(random, mob, luck);
        if (this.nbt != null) {
            mob.method_5749(this.nbt);
        }
        if (this.mount != null) {
            class_1308 mountedEntity = this.mount.create(mob.method_37908(), mob.method_23317() + 0.5, mob.method_23318(), mob.method_23321() + 0.5);
            mob.method_5873((class_1297)mountedEntity, true);
            level.method_8649((class_1297)mountedEntity);
        }
        if (this.support != null) {
            for (SupportingEntity support : this.support) {
                class_1308 supportingMob = support.create(mob.method_37908(), mob.method_23317() + 0.5, mob.method_23318(), mob.method_23321() + 0.5);
                level.method_8649((class_1297)supportingMob);
            }
        }
    }

    public void initBoss(class_5819 rand, class_1308 mob, float luck) {
        ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).setMiniBoss(MinibossRegistry.INSTANCE.getKey(this).toString());
        int duration = mob instanceof class_1548 ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : this.stats.effects()) {
            if (!(rand.method_43057() <= inst.chance())) continue;
            mob.method_6092(inst.create(rand, duration));
        }
        for (RandomAttributeModifier modif : this.stats.modifiers()) {
            modif.apply(rand, (class_1309)mob);
        }
        if (NAME_GEN.equals(this.name)) {
            NameHelper.setEntityName(rand, mob);
        } else if (!Strings.isNullOrEmpty((String)this.name)) {
            mob.method_5665((class_2561)class_2561.method_43471((String)this.name));
        }
        if (mob.method_16914()) {
            mob.method_5880(true);
        }
        if (!this.gearSets.isEmpty()) {
            GearSet set = GearSetRegistry.INSTANCE.getRandomSet(rand, luck, this.gearSets);
            Preconditions.checkNotNull((Object)set, (Object)String.format("Failed to find a valid gear set for the miniboss %s.", MinibossRegistry.INSTANCE.getKey(this)));
            set.apply((class_1309)mob);
        }
        int guaranteed = -1;
        if (this.affixed) {
            boolean anyValid = false;
            for (class_1304 t : class_1304.values()) {
                class_1799 s = mob.method_6118(t);
                if (s.method_7960() || LootCategory.forItem(s).isNone()) continue;
                anyValid = true;
                break;
            }
            if (!anyValid) {
                AdventureModule.LOGGER.error("Attempted to affix a miniboss with ID " + MinibossRegistry.INSTANCE.getKey(this) + " but it is not wearing any affixable items!");
                return;
            }
            guaranteed = rand.method_43048(6);
            class_1799 temp = mob.method_6118(class_1304.values()[guaranteed]);
            while (temp.method_7960() || LootCategory.forItem(temp) == LootCategory.NONE) {
                guaranteed = rand.method_43048(6);
                temp = mob.method_6118(class_1304.values()[guaranteed]);
            }
            LootRarity rarity = LootRarity.random(rand, luck, AdventureConfig.AFFIX_CONVERT_RARITIES.get(mob.method_37908().method_27983().method_29177()));
            ApothBoss.modifyBossItem(temp, rand, mob.method_16914() ? mob.method_5797().getString() : "", luck, rarity, this.stats);
            mob.method_5665((class_2561)((class_5250)mob.method_5797()).method_27696(class_2583.field_24360.method_27703(rarity.getColor())));
            mob.method_5946(class_1304.values()[guaranteed], 2.0f);
        }
        for (class_1304 s : class_1304.values()) {
            class_1799 stack = mob.method_6118(s);
            if (stack.method_7960() || s.ordinal() == guaranteed || !(rand.method_43057() < this.stats.enchantChance())) continue;
            ApothBoss.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels()[0] : this.stats.enchLevels()[1], true);
            mob.method_5673(s, stack);
        }
        mob.method_6033(mob.method_6063());
    }

    public ApothMiniboss validate(class_2960 key) {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Miniboss Item " + key + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Miniboss Item " + key + " has a negative quality!"));
        Preconditions.checkNotNull(this.entities, (Object)("Miniboss Item " + key + " has null entity match list!"));
        Preconditions.checkNotNull((Object)this.stats, (Object)("Miniboss Item " + key + " has no stats!"));
        return this;
    }

    public Set<class_2960> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public Codec<? extends ApothMiniboss> getCodec() {
        return CODEC;
    }

    public boolean requiresNbtAccess() {
        return this.exclusions.stream().anyMatch(Exclusion::requiresNbtAccess);
    }

    public boolean isExcluded(class_1308 mob, class_5425 level, class_3730 type) {
        class_2487 tag = this.requiresNbtAccess() ? mob.method_5647(new class_2487()) : null;
        return this.exclusions.stream().anyMatch(ex -> ex.isExcluded(mob, level, type, tag));
    }

    public boolean shouldFinalize() {
        return this.finalize;
    }
}

