/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.client;

import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingScreen;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTileRenderer;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.RerollResultMessage;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingScreen;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTileRenderer;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureKeys;
import dev.shadowsoffire.apotheosis.adventure.client.BossSpawnMessage;
import dev.shadowsoffire.apotheosis.adventure.client.SocketTooltipRenderer;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.cutting.GemCuttingScreen;
import dev.shadowsoffire.apotheosis.util.ZenithModCompat;
import dev.shadowsoffire.apotheosis.util.events.ModifyComponents;
import dev.shadowsoffire.attributeslib.api.client.AddAttributeTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.GatherSkippedAttributeTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.ItemTooltipCallbackWithPlayer;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3929;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5616;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_5944;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_822;
import org.apache.commons.lang3.mutable.MutableInt;

public class AdventureModuleClient {
    public static List<BossSpawnMessage.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnMessage.BossSpawnData>();

    public static void init() {
        class_3929.method_17542(Adventure.Menus.REFORGING, ReforgingScreen::new);
        class_3929.method_17542(Adventure.Menus.SALVAGE, SalvagingScreen::new);
        class_3929.method_17542(Adventure.Menus.GEM_CUTTING, GemCuttingScreen::new);
        class_3929.method_17542(Adventure.Menus.AUGMENTING, AugmentingScreen::new);
        class_5616.method_32144(Adventure.Tiles.REFORGING_TABLE, context -> new ReforgingTableTileRenderer());
        class_5616.method_32144(Adventure.Tiles.AUGMENTING_TABLE, context -> new AugmentingTableTileRenderer());
        AdventureModuleClient.time();
        AdventureModuleClient.tooltips();
        AdventureModuleClient.ignoreSocketUUIDS();
        AdventureModuleClient.affixTooltips();
        AdventureModuleClient.comps();
        AdventureModuleClient.renderBossBeam();
        BossSpawnMessage.init();
        RerollResultMessage.init();
        CoreShaderRegistrationCallback.EVENT.register(context -> context.register(Apotheosis.loc("gray"), class_290.field_1580, shaderInstance -> {
            CustomRenderTypes.grayShader = shaderInstance;
        }));
        AdventureKeys.registerKeys();
        AdventureKeys.handleKeys();
    }

    public static void onBossSpawn(class_2338 pos, float[] color) {
        BOSS_SPAWNS.add(new BossSpawnMessage.BossSpawnData(pos, color, new MutableInt()));
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(class_3417.field_14981, class_3419.field_15251, AdventureConfig.bossAnnounceVolume, 1.25f, class_310.method_1551().field_1724.method_6051(), class_310.method_1551().field_1724.method_24515()));
    }

    public static void renderBossBeam() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_4587 stack = context.matrixStack();
            class_4597.class_4598 buf = class_310.method_1551().method_22940().method_23000();
            class_746 p = class_310.method_1551().field_1724;
            for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
                BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
                stack.method_22903();
                float partials = context.tickDelta();
                class_243 vec = context.camera().method_19326();
                stack.method_22904(-vec.field_1352, -vec.field_1351, -vec.field_1350);
                stack.method_46416((float)data.pos().method_10263(), (float)data.pos().method_10264(), (float)data.pos().method_10260());
                class_822.method_3545((class_4587)stack, (class_4597)buf, (class_2960)class_822.field_4338, (float)partials, (float)1.0f, (long)p.method_37908().method_8510(), (int)0, (int)512, (float[])data.color(), (float)0.166f, (float)0.33f);
                stack.method_22909();
            }
            buf.method_37104();
        });
    }

    public static void time() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
                BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
                if (data.ticks().getAndIncrement() <= 400) continue;
                BOSS_SPAWNS.remove(i--);
            }
        });
    }

    public static void tooltips() {
        AddAttributeTooltipsEvent.EVENT.register((stack, player, tooltip, attributeTooltipIterator, flag) -> {
            int sockets = SocketHelper.getSockets(stack);
            if (sockets > 0) {
                attributeTooltipIterator.add(class_2561.method_43470((String)"ZENITH_REMOVE_MARKER"));
            }
        });
    }

    public static void ignoreSocketUUIDS() {
        GatherSkippedAttributeTooltipsEvent.EVENT.register((stack, player, skips, flag) -> {
            for (GemInstance gem : SocketHelper.getGems(stack)) {
                skips.addAll(gem.getUUIDs());
            }
        });
    }

    public static void comps() {
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof SocketTooltipRenderer.SocketComponent) {
                SocketTooltipRenderer.SocketComponent comp = (SocketTooltipRenderer.SocketComponent)data;
                return new SocketTooltipRenderer(comp);
            }
            return null;
        });
        ZenithModCompat.Adventure.icebergCompat();
        ModifyComponents.MODIFY_COMPONENTS.register(e -> {
            int sockets = SocketHelper.getSockets(e.stack);
            if (sockets == 0) {
                return;
            }
            List<Either<class_5348, class_5632>> list = e.tooltipElements;
            int rmvIdx = -1;
            for (int i = 0; i < list.size(); ++i) {
                class_2585 tc;
                class_2561 comp;
                class_7417 patt8548$temp;
                Object patt8500$temp;
                Optional o = list.get(i).left();
                if (!o.isPresent() || !((patt8500$temp = o.get()) instanceof class_2561) || !((patt8548$temp = (comp = (class_2561)patt8500$temp).method_10851()) instanceof class_2585) || !"ZENITH_REMOVE_MARKER".equals((tc = (class_2585)patt8548$temp).comp_737())) continue;
                rmvIdx = i;
                list.remove(i);
                break;
            }
            if (rmvIdx == -1) {
                return;
            }
            e.tooltipElements.add(rmvIdx, (Either<class_5348, class_5632>)Either.right((Object)new SocketTooltipRenderer.SocketComponent(e.stack, SocketHelper.getGems(e.stack))));
        });
    }

    public static void affixTooltips() {
        ItemTooltipCallbackWithPlayer.EVENT.register((stack, context, lines, player) -> {
            if (stack.method_7985()) {
                Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
                ArrayList components = new ArrayList();
                Consumer<class_2561> dotPrefixer = afxComp -> components.add(class_2561.method_43469((String)"text.zenith.dot_prefix", (Object[])new Object[]{afxComp}).method_27692(class_124.field_1054));
                affixes.values().stream().sorted(Comparator.comparingInt(a -> ((Affix)a.affix().get()).getType().ordinal())).map(AffixInstance::getDescription).filter(c -> c.method_10851() != class_7417.field_39004).forEach(dotPrefixer);
                lines.addAll(1, components);
            }
        });
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 font) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        ModifyComponents.ModifyComponentsEvent event = new ModifyComponents.ModifyComponentsEvent(stack, screenWidth, screenHeight, elements, -1);
        ((ModifyComponents.ModifyComponentsCallback)ModifyComponents.MODIFY_COMPONENTS.invoker()).modifyComponents(event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipTextWidth = event.tooltipElements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.maxWidth > 0 && tooltipTextWidth > event.maxWidth) {
            tooltipTextWidth = event.maxWidth;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return event.tooltipElements.stream().flatMap(either -> (Stream)either.map(text -> AdventureModuleClient.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return event.tooltipElements.stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), class_5684::method_32663)).toList();
    }

    private static Stream<class_5684> splitLine(class_5348 text, class_327 font, int maxWidth) {
        class_2561 component;
        if (text instanceof class_2561 && (component = (class_2561)text).getString().isEmpty()) {
            return Stream.of(component.method_30937()).map(class_5684::method_32662);
        }
        return font.method_1728(text, maxWidth).stream().map(class_5684::method_32662);
    }

    public static class_1921 gray(class_2960 texture) {
        return CustomRenderTypes.GRAY.apply(texture);
    }

    public static void checkAffixLangKeys() {
        StringBuilder sb = new StringBuilder("Missing Affix Lang Keys:\n");
        boolean any = false;
        String json = "\"%s\": \"\",";
        for (Affix a : AffixRegistry.INSTANCE.getValues()) {
            class_2960 id = AffixRegistry.INSTANCE.getKey(a);
            if (!class_1074.method_4663((String)("affix." + id))) {
                sb.append(json.formatted("affix." + id) + "\n");
                any = true;
            }
            if (class_1074.method_4663((String)("affix." + id + ".suffix"))) continue;
            sb.append(json.formatted("affix." + id + ".suffix") + "\n");
            any = true;
        }
        if (any) {
            AdventureModule.LOGGER.error(sb.toString());
        }
    }

    private static class CustomRenderTypes
    extends class_1921 {
        private static class_5944 grayShader;
        private static final class_4668.class_5942 RENDER_TYPE_GRAY;
        public static Function<class_2960, class_1921> GRAY;

        private static class_1921 gray(class_2960 loc) {
            class_1921.class_4688 rendertype$state = class_1921.class_4688.method_23598().method_34578(RENDER_TYPE_GRAY).method_34577((class_4668.class_5939)new class_4668.class_4683(loc, false, false)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23611(field_21385).method_23616(class_4668.field_21349).method_23617(true);
            return CustomRenderTypes.method_24049((String)"gray", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)rendertype$state);
        }

        private CustomRenderTypes(String s, class_293 v, class_293.class_5596 m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        static {
            RENDER_TYPE_GRAY = new class_4668.class_5942(() -> grayShader);
            GRAY = class_156.method_34866(CustomRenderTypes::gray);
        }
    }

    public static class StackStorage {
        public static class_1799 hoveredItem = class_1799.field_8037;
    }
}

