/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5819;

public class AffixConvertLootModifier
extends LootModifier {
    public static final Codec<AffixConvertLootModifier> CODEC = RecordCodecBuilder.create(inst -> AffixConvertLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AffixConvertLootModifier::new));

    protected AffixConvertLootModifier(class_5341[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_CONVERT_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            RarityClamp rarities = AdventureConfig.AFFIX_CONVERT_RARITIES.get(context.method_299().method_27983().method_29177());
            class_5819 rand = context.method_294();
            float luck = context.method_302();
            for (class_1799 s : generatedLoot) {
                if (LootCategory.forItem(s).isNone() || !AffixHelper.getAffixes(s).isEmpty() || !(rand.method_43057() <= m.chance())) continue;
                LootController.createLootItem(s, LootRarity.random(rand, luck, rarities), rand);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

