/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_2540;

public record GemClass(String key, Set<LootCategory> types) {
    public static Codec<GemClass> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("key").forGetter(GemClass::key), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(GemClass::types)).apply((Applicative)inst, GemClass::new));

    public GemClass(String key, Set<LootCategory> types) {
        this.key = key;
        this.types = types;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Invalid GemClass with null key");
        Preconditions.checkArgument((this.types != null && !this.types.isEmpty() ? 1 : 0) != 0, (Object)"Invalid GemClass with null or empty types");
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.key);
        buf.writeByte(this.types.size());
        this.types.forEach(c -> buf.method_10814(c.getName()));
    }

    public static GemClass read(class_2540 buf) {
        String key = buf.method_19772();
        int size = buf.readByte();
        ArrayList<LootCategory> list = new ArrayList<LootCategory>(size);
        for (int i = 0; i < size; ++i) {
            list.add(LootCategory.byId(buf.method_19772()));
        }
        return new GemClass(key, (Set<LootCategory>)ImmutableSet.copyOf(list));
    }
}

