/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class GemRegistry
extends WeightedDynamicRegistry<Gem> {
    public static final GemRegistry INSTANCE = new GemRegistry();

    public GemRegistry() {
        super(AdventureModule.LOGGER, "gems", true, false);
    }

    protected void registerBuiltinCodecs() {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        this.registerDefaultCodec(Apotheosis.loc("gem"), Gem.CODEC);
    }

    @SafeVarargs
    public static class_1799 createRandomGemStack(class_5819 rand, class_3218 level, float luck, Predicate<Gem> ... filter) {
        Gem gem = (Gem)INSTANCE.getRandomItem(rand, luck, filter);
        if (gem == null) {
            return class_1799.field_8037;
        }
        RarityClamp clamp = AdventureConfig.GEM_DIM_RARITIES.get(level.method_27983().method_29177());
        LootRarity rarity = gem.clamp(LootRarity.random(rand, luck, clamp));
        return GemRegistry.createGemStack(gem, rarity);
    }

    public static class_1799 createGemStack(Gem gem, LootRarity rarity) {
        class_1799 stack = new class_1799((class_1935)Adventure.Items.GEM);
        GemItem.setGem(stack, gem);
        AffixHelper.setRarity(stack, rarity);
        return stack;
    }

    protected void validateItem(class_2960 key, Gem item) {
        super.validateItem(key, (CodecProvider)item);
        for (LootRarity r = item.minRarity; r != item.maxRarity; r = r.next()) {
            boolean atLeastOne = false;
            for (GemBonus bonus : item.bonuses) {
                if (!bonus.supports(r)) continue;
                atLeastOne = true;
            }
            Preconditions.checkArgument((boolean)atLeastOne, (String)"No bonuses provided for supported rarity %s. At least one bonus must be provided, or the rarity should not be supported.", (Object)RarityRegistry.INSTANCE.getKey(r));
        }
    }
}

