/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public class MultiAttrBonus
extends GemBonus {
    public static Codec<MultiAttrBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(MultiAttrBonus.gemClass(), (App)ModifierInst.CODEC.listOf().fieldOf("modifiers").forGetter(a -> a.modifiers), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.desc)).apply((Applicative)inst, MultiAttrBonus::new));
    protected final List<ModifierInst> modifiers;
    protected final String desc;

    public MultiAttrBonus(GemClass gemClass, List<ModifierInst> modifiers, String desc) {
        super(Apotheosis.loc("multi_attribute"), gemClass);
        this.modifiers = modifiers;
        this.desc = desc;
    }

    @Override
    public void addModifiers(class_1799 gem, LootRarity rarity, BiConsumer<class_1320, class_1322> map) {
        List<UUID> uuids = GemItem.getUUIDs(gem);
        int i = 0;
        for (ModifierInst modifier : this.modifiers) {
            map.accept(modifier.attr, modifier.build(uuids.get(i++), rarity));
        }
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        Object[] values = new Object[this.modifiers.size() * 2];
        int i = 0;
        for (ModifierInst modifier : this.modifiers) {
            values[i] = IFormattableAttribute.toComponent((class_1320)modifier.attr, (class_1322)modifier.build(UUID.randomUUID(), rarity), (class_1836)AttributesLib.getTooltipFlag());
            values[this.modifiers.size() + i] = IFormattableAttribute.toValueComponent((class_1320)modifier.attr, (class_1322.class_1323)modifier.op, (double)i, (class_1836)AttributesLib.getTooltipFlag());
            ++i;
        }
        return class_2561.method_43469((String)this.desc, (Object[])values).method_27692(class_124.field_1054);
    }

    @Override
    public MultiAttrBonus validate() {
        Preconditions.checkNotNull(this.modifiers, (Object)"Invalid AttributeBonus with null values");
        ArrayList rarityChecks = new ArrayList();
        for (ModifierInst inst : this.modifiers) {
            HashSet set = new HashSet();
            RarityRegistry.INSTANCE.getValues().stream().filter(r -> inst.values.containsKey(r)).forEach(set::add);
            rarityChecks.add(set);
        }
        Preconditions.checkArgument((boolean)rarityChecks.stream().mapToInt(Set::size).allMatch(size -> size == ((Set)rarityChecks.get(0)).size()));
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.modifiers.get((int)0).values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return this.modifiers.size();
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    protected record ModifierInst(class_1320 attr, class_1322.class_1323 op, Map<LootRarity, Float> values) {
        public static Codec<ModifierInst> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41190.method_39673().fieldOf("attribute").forGetter(ModifierInst::attr), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(ModifierInst::op), (App)LootRarity.mapCodec(Codec.FLOAT).fieldOf("values").forGetter(ModifierInst::values)).apply((Applicative)inst, ModifierInst::new));

        public class_1322 build(UUID id, LootRarity rarity) {
            return new class_1322(id, "apoth.gem_modifier", (double)this.values.get(rarity).floatValue(), this.op);
        }
    }
}

