/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5250;

public class BloodyArrowBonus
extends GemBonus {
    public static Codec<BloodyArrowBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, BloodyArrowBonus::new));
    protected final Map<LootRarity, Data> values;

    public BloodyArrowBonus(Map<LootRarity, Data> values) {
        super(Apotheosis.loc("bloody_arrow"), new GemClass("ranged_weapon", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.BOW, (Object)LootCategory.CROSSBOW)));
        this.values = values;
    }

    @Override
    public void onArrowFired(class_1799 gem, LootRarity rarity, class_1309 user, class_1665 arrow) {
        Data d = this.values.get(rarity);
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Is Bloody arrow on cooldown: {}, current damage: {}", (Object)Affix.isOnCooldown(this.getId(), d.cooldown, user), (Object)arrow.method_7448());
        }
        if (Affix.isOnCooldown(this.getId(), d.cooldown, user)) {
            return;
        }
        user.method_5643(user.method_48923().method_48795(Apoth.DamageTypes.CORRUPTED), user.method_6063() * d.healthCost);
        arrow.method_7438(arrow.method_7448() * (double)d.dmgMultiplier);
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Base damage after: {}", (Object)arrow.method_7448());
        }
        Affix.startCooldown(this.getId(), user);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        Data d = this.values.get(rarity);
        class_5250 cooldown = class_2561.method_43469((String)"affix.zenith.cooldown", (Object[])new Object[]{class_3544.method_15439((int)d.cooldown)});
        return class_2561.method_43469((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(d.healthCost * 100.0f), Affix.fmt(100.0f * d.dmgMultiplier), cooldown}).method_27692(class_124.field_1054);
    }

    @Override
    public BloodyArrowBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    record Data(float healthCost, float dmgMultiplier, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("health_cost").forGetter(Data::healthCost), (App)Codec.FLOAT.fieldOf("damage_mult").forGetter(Data::dmgMultiplier), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }
}

