/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.IngredientCodec;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.util.StepFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class DropTransformBonus
extends GemBonus {
    public static Codec<DropTransformBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DropTransformBonus.gemClass(), (App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("blocks").forGetter(a -> a.tag), (App)IngredientCodec.INSTANCE.fieldOf("inputs").forGetter(a -> a.inputs), (App)ItemAdapter.CODEC.fieldOf("output").forGetter(a -> a.output), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.descKey)).apply((Applicative)inst, DropTransformBonus::new));
    protected final class_6862<class_2248> tag;
    protected final class_1856 inputs;
    protected final class_1799 output;
    protected final Map<LootRarity, StepFunction> values;
    protected final String descKey;
    protected final transient List<class_2248> blocks;

    public DropTransformBonus(GemClass gemClass, class_6862<class_2248> tag, class_1856 inputs, class_1799 output, Map<LootRarity, StepFunction> values, String descKey) {
        super(Apotheosis.loc("drop_transform"), gemClass);
        this.tag = tag;
        this.inputs = inputs;
        this.output = output;
        this.values = values;
        this.descKey = descKey;
        this.blocks = Collections.emptyList();
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        float chance = this.values.get(rarity).min();
        return class_2561.method_43469((String)this.descKey, (Object[])new Object[]{Affix.fmt(chance * 100.0f)}).method_27692(class_124.field_1054);
    }

    @Override
    public void modifyLoot(class_1799 gem, LootRarity rarity, ObjectArrayList<class_1799> loot, class_47 ctx) {
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Drop transform init");
        }
        if (ctx.method_300(class_181.field_1224)) {
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("LootContext is a block");
            }
            class_2248 block = ((class_2680)ctx.method_35508(class_181.field_1224)).method_26204();
            if (!this.blocks.isEmpty() && !this.blocks.contains(block)) {
                if (Apotheosis.enableDebug) {
                    AdventureModule.LOGGER.error("List of blocks is empty or list doesn't contain broken block");
                }
                return;
            }
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("List of blocks contains this block");
            }
            if (ctx.method_294().method_43057() <= this.values.get(rarity).min()) {
                if (Apotheosis.enableDebug) {
                    AdventureModule.LOGGER.info("Changing loot, size of loot list: {}", (Object)loot.size());
                }
                for (int i = 0; i < loot.size(); ++i) {
                    class_1799 stack = (class_1799)loot.get(i);
                    if (Apotheosis.enableDebug) {
                        AdventureModule.LOGGER.info("Passes test? {}, input ingredient: {}, stack: {}", (Object)this.inputs.method_8093(stack), (Object)this.inputs, (Object)stack);
                    }
                    if (!this.inputs.method_8093(stack)) continue;
                    class_1799 outCopy = this.output.method_7972();
                    if (Apotheosis.enableDebug) {
                        AdventureModule.LOGGER.info("Changing {} to {}", (Object)stack, (Object)outCopy);
                    }
                    outCopy.method_7939(stack.method_7947());
                    loot.set(i, (Object)outCopy);
                }
            }
        }
    }

    @Override
    public DropTransformBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }
}

