/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.adventure.client.GrayBufferSource;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.cutting.GemCuttingMenu;
import dev.shadowsoffire.apotheosis.util.DrawsOnLeft;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1101;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

public class GemCuttingScreen
extends AdventureContainerScreen<GemCuttingMenu>
implements DrawsOnLeft {
    public static final class_2960 TEXTURE = new class_2960("zenith", "textures/gui/gem_cutting.png");
    protected final class_1799 displayDust = Adventure.Items.GEM_DUST.method_7854();
    protected class_1799 displayMat;
    protected SimpleTexButton upgradeBtn;

    public GemCuttingScreen(GemCuttingMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        ((GemCuttingMenu)this.field_2797).addSlotListener((id, stack) -> this.updateBtnStatus());
        this.field_2779 = 180;
        this.field_25268 = 5;
        this.field_25270 = 86;
    }

    protected void method_25426() {
        super.method_25426();
        int left = this.field_2776;
        int top = this.field_2800;
        this.upgradeBtn = (SimpleTexButton)this.method_37063((class_364)new SimpleTexButton(left + 135, top + 44, 18, 18, 238, 0, TEXTURE, 256, 256, this::clickUpgradeBtn, (class_2561)class_2561.method_43471((String)"button.zenith.upgrade")).setInactiveMessage((class_2561)class_2561.method_43471((String)"button.zenith.upgrade.no").method_27692(class_124.field_1061)));
        this.updateBtnStatus();
    }

    protected void clickUpgradeBtn(class_4185 btn) {
        this.field_22787.field_1761.method_2900(((GemCuttingMenu)this.field_2797).field_7763, 0);
        GemUpgradeSound.start(((GemCuttingMenu)this.field_2797).player.method_24515());
    }

    protected void updateBtnStatus() {
        class_1799 gem = ((GemCuttingMenu)this.field_2797).method_7611(0).method_7677();
        class_1799 left = ((GemCuttingMenu)this.field_2797).method_7611(1).method_7677();
        class_1799 bot = ((GemCuttingMenu)this.field_2797).method_7611(2).method_7677();
        class_1799 right = ((GemCuttingMenu)this.field_2797).method_7611(3).method_7677();
        for (GemCuttingMenu.GemCuttingRecipe r : GemCuttingMenu.RECIPES) {
            if (!r.matches(gem, left, bot, right)) continue;
            this.upgradeBtn.field_22763 = true;
            return;
        }
        class_1799 class_17992 = this.displayMat = gem.method_7960() ? class_1799.field_8037 : new class_1799((class_1935)((LootRarity)AffixHelper.getRarity(gem).get()).getMaterial());
        if (this.upgradeBtn != null) {
            this.upgradeBtn.field_22763 = false;
        }
    }

    protected void method_2389(class_332 gfx, float pPartialTick, int pMouseX, int pMouseY) {
        int xCenter = (this.field_22789 - this.field_2792) / 2;
        int yCenter = (this.field_22790 - this.field_2779) / 2;
        gfx.method_25302(TEXTURE, xCenter, yCenter, 0, 0, this.field_2792, this.field_2779);
        if (this.hasItem(0) && GemCuttingMenu.isValidMainGem(((GemCuttingMenu)this.field_2797).method_7611(0).method_7677())) {
            if (!this.hasItem(1)) {
                this.renderGrayItem(gfx, this.displayDust, ((GemCuttingMenu)this.field_2797).method_7611(1));
            }
            if (!this.hasItem(2)) {
                this.renderGrayItem(gfx, ((GemCuttingMenu)this.field_2797).method_7611(0).method_7677(), ((GemCuttingMenu)this.field_2797).method_7611(2));
            }
            if (!this.hasItem(3)) {
                this.renderGrayItem(gfx, this.displayMat, ((GemCuttingMenu)this.field_2797).method_7611(3));
            }
        }
    }

    protected boolean hasItem(int slot) {
        return ((GemCuttingMenu)this.field_2797).method_7611(slot).method_7681();
    }

    protected void renderGrayItem(class_332 gfx, class_1799 stack, class_1735 slot) {
        SalvagingScreen.renderGuiItem(gfx, stack, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872, GrayBufferSource::new);
    }

    protected void method_2380(class_332 gfx, int pX, int pY) {
        class_1799 gemStack = ((GemCuttingMenu)this.field_2797).method_7611(0).method_7677();
        GemInstance gem = GemInstance.unsocketed(gemStack);
        GemInstance secondary = GemInstance.unsocketed(((GemCuttingMenu)this.field_2797).method_7611(2).method_7677());
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (gem.isValidUnsocketed()) {
            int dust = ((GemCuttingMenu)this.field_2797).method_7611(1).method_7677().method_7947();
            DynamicHolder<LootRarity> rarity = gem.rarity();
            if (rarity == RarityRegistry.getMaxRarity()) {
                list.add((class_2561)class_2561.method_43471((String)"text.zenith.no_upgrade").method_27695(new class_124[]{class_124.field_1065, class_124.field_1073}));
            } else {
                list.add((class_2561)class_2561.method_43471((String)"text.zenith.cut_cost").method_27695(new class_124[]{class_124.field_1065, class_124.field_1073}));
                list.add(class_5244.field_39003);
                int dustCost = GemCuttingMenu.getDustCost((LootRarity)rarity.get());
                boolean hasDust = dust > dustCost;
                list.add((class_2561)class_2561.method_43469((String)"text.zenith.cost", (Object[])new Object[]{dustCost, Adventure.Items.GEM_DUST.method_7864(class_1799.field_8037)}).method_27692(hasDust ? class_124.field_1060 : class_124.field_1061));
                boolean hasGem2 = secondary.isValidUnsocketed() && gem.gem() == secondary.gem() && rarity == secondary.rarity();
                list.add((class_2561)class_2561.method_43469((String)"text.zenith.cost", (Object[])new Object[]{1, gemStack.method_7964().getString()}).method_27692(hasGem2 ? class_124.field_1060 : class_124.field_1061));
                list.add((class_2561)class_2561.method_43471((String)"text.zenith.one_rarity_mat").method_27692(class_124.field_1080));
                this.addMatTooltip(RarityRegistry.next(rarity), 1, list);
                this.addMatTooltip(rarity, 3, list);
                if (rarity != RarityRegistry.getMinRarity()) {
                    this.addMatTooltip(RarityRegistry.prev(rarity), 9, list);
                }
            }
        }
        this.drawOnLeft(gfx, list, this.field_2800 + 16);
        super.method_2380(gfx, pX, pY);
    }

    private void addMatTooltip(DynamicHolder<LootRarity> rarity, int cost, List<class_2561> list) {
        class_1792 rarityMat = ((LootRarity)rarity.get()).getMaterial();
        class_1799 slotMat = ((GemCuttingMenu)this.field_2797).method_7611(3).method_7677();
        boolean hasMats = slotMat.method_7909() == rarityMat && slotMat.method_7947() >= cost;
        list.add((class_2561)AttributeHelper.list().method_10852((class_2561)class_2561.method_43469((String)"text.zenith.cost", (Object[])new Object[]{cost, rarityMat.method_7864(class_1799.field_8037)}).method_27692(!hasMats ? class_124.field_1061 : class_124.field_1054)));
    }

    protected static class GemUpgradeSound
    extends class_1101 {
        protected int ticks = 0;
        protected float pitchOff;

        public GemUpgradeSound(class_2338 pos) {
            super(class_3417.field_26979, class_3419.field_15245, class_310.method_1551().field_1687.field_9229);
            this.field_5439 = (float)pos.method_10263() + 0.5f;
            this.field_5450 = pos.method_10264();
            this.field_5449 = (float)pos.method_10260() + 0.5f;
            this.field_5442 = 1.5f;
            this.field_5441 = 1.5f + 0.35f * (1.0f - 2.0f * this.field_38800.method_43057());
            this.pitchOff = 0.35f * (1.0f - 2.0f * this.field_38800.method_43057());
            this.field_5451 = 999;
        }

        public void method_16896() {
            if (this.ticks == 4 || this.ticks == 9) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_26979, (float)(this.field_5441 + this.pitchOff), (float)1.5f));
                this.pitchOff = -this.pitchOff;
            }
            if (this.ticks++ > 8) {
                this.method_24876();
            }
        }

        public static void start(class_2338 pos) {
            class_310.method_1551().method_1483().method_4873((class_1113)new GemUpgradeSound(pos));
        }
    }
}

