/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench;

import com.chocohead.mm.api.ClassTinkerers;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.EnchConfig;
import dev.shadowsoffire.apotheosis.ench.EnchModuleEvents;
import dev.shadowsoffire.apotheosis.ench.EnchantmentInfo;
import dev.shadowsoffire.apotheosis.ench.objects.TomeItem;
import dev.shadowsoffire.apotheosis.ench.objects.TypedShelfBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantTile;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.KeepNBTEnchantingRecipe;
import dev.shadowsoffire.apotheosis.mixin.accessors.BlockEntityTypeAccessor;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchModule {
    public static final Map<class_1887, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<class_1887, EnchantmentInfo>();
    public static final Object2IntMap<class_1887> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final Logger LOGGER = LogManager.getLogger((String)"Zenith : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();
    public static final class_1886 HOE = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"HOE");
    public static final class_1886 SHIELD = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"SHIELD");
    public static final class_1886 ANVIL = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"ANVIL");
    public static final class_1886 SHEARS = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"SHEARS");
    public static final class_1886 PICKAXE = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"PICKAXE");
    public static final class_1886 AXE = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"AXE");
    public static final class_1886 CORE_ARMOR = (class_1886)ClassTinkerers.getEnum(class_1886.class, (String)"CORE_ARMOR");
    static Configuration enchInfoConfig;

    public static void init() {
        Ench.bootstrap();
        EnchModule.particles();
        EnchModule.recipeSerializers();
        PlaceboUtil.registerCustomColor((class_5251)Ench.Colors.LIGHT_BLUE_FLASH);
        EnchModuleEvents.registerEvents();
        EnchantingStatRegistry.INSTANCE.register();
        ((BlockEntityTypeAccessor)class_2591.field_11912).setFactory(ApothEnchantTile::new);
        EnchModule.reload(false);
    }

    public static void recipeSerializers() {
        Apoth.registerSerializer("enchanting", EnchantingRecipe.SERIALIZER);
        Apoth.registerSerializer("keep_nbt_enchanting", KeepNBTEnchantingRecipe.SERIALIZER);
    }

    public static void particles() {
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Apotheosis.loc("enchant_fire"), (Object)Ench.Particles.ENCHANT_FIRE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Apotheosis.loc("enchant_water"), (Object)Ench.Particles.ENCHANT_WATER);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Apotheosis.loc("enchant_sculk"), (Object)Ench.Particles.ENCHANT_SCULK);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Apotheosis.loc("enchant_end"), (Object)Ench.Particles.ENCHANT_END);
    }

    private static class_2248 shelf(class_4970.class_2251 props, float strength) {
        return EnchModule.shelf(props, strength, class_2398.field_11215);
    }

    private static class_2248 shelf(class_4970.class_2251 props, float strength, class_2400 particle) {
        props.method_9632(strength);
        return new TypedShelfBlock(props, particle);
    }

    private static class_2248 sculkShelf(float strength, class_2400 particle) {
        class_4970.class_2251 props = class_4970.class_2251.method_9637().method_31710(class_3620.field_16009).method_9626(class_2498.field_11544).method_9632(strength).method_9640().method_29292();
        return new TypedShelfBlock.SculkShelfBlock(props, particle);
    }

    public static EnchantmentInfo getEnchInfo(class_1887 ench) {
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, EnchantmentInfo::new);
        }
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            return new EnchantmentInfo(ench);
        }
        if (info == null) {
            info = EnchantmentInfo.load(ench, enchInfoConfig);
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)class_7923.field_41176.method_10221((Object)ench), (Object)class_7923.field_41176.method_10221((Object)ench).method_12836());
        }
        return info;
    }

    public static int getDefaultMax(class_1887 ench) {
        int level = ench.method_8183();
        if (level == 1) {
            return 1;
        }
        EnchantmentInfo.PowerFunc minFunc = EnchantmentInfo.defaultMin(ench);
        int max = (int)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f);
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    public static boolean isVanillaAnvil(class_1799 stack) {
        return stack.method_31574(class_1802.field_8782) || stack.method_31574(class_1802.field_8750) || stack.method_31574(class_1802.field_8427);
    }

    public static void reload(boolean e) {
        enchInfoConfig = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        enchInfoConfig.setTitle("Zenith Enchantment Information");
        enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
        ENCHANTMENT_INFO.clear();
        for (class_1887 ench : class_7923.field_41176) {
            ENCHANTMENT_INFO.put(ench, EnchantmentInfo.load(ench, enchInfoConfig));
        }
        for (class_1887 ench : class_7923.field_41176) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)class_7923.field_41176.method_10221((Object)ench), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        if (!e && enchInfoConfig.hasChanged()) {
            enchInfoConfig.save();
        }
        EnchConfig.load(new Configuration(new File(Apotheosis.configDir, "ench.cfg")));
    }
}

