/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import dev.shadowsoffire.apotheosis.advancements.EnchTrigger;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantTile;
import dev.shadowsoffire.apotheosis.ench.table.ClueMessage;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.IEnchantableItem;
import dev.shadowsoffire.apotheosis.ench.table.RealEnchantmentHelper;
import dev.shadowsoffire.apotheosis.ench.table.StatsMessage;
import dev.shadowsoffire.apotheosis.mixin.accessors.EnchantmentMenuAccessor;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.apotheosis.util.ZenithModCompat;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4538;
import net.minecraft.class_7923;

public class ApothEnchantmentMenu
extends class_1718 {
    protected TableStats stats = TableStats.INVALID;
    protected final class_1657 player;

    public ApothEnchantmentMenu(int id, class_1661 inv) {
        super(id, inv, class_3914.field_17304);
        this.player = inv.field_7546;
        this.field_7761.clear();
        this.addSecretSlot(new class_1735(((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots(), 0, 15, 47){

            public boolean method_7680(class_1799 stack) {
                return !stack.method_31573(Tags.Items.ENCHANTING_FUELS);
            }

            public int method_7675() {
                return 1;
            }
        });
        this.addSecretSlot(new class_1735(((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots(), 1, 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantmentMenu(int id, class_1661 inv, class_3914 wPos, ApothEnchantTile te) {
        super(id, inv, wPos);
        this.player = inv.field_7546;
        this.field_7761.clear();
        this.addSecretSlot(new class_1735(((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots(), 0, 15, 47){

            public boolean method_7680(class_1799 stack) {
                return !stack.method_31573(Tags.Items.ENCHANTING_FUELS);
            }

            public int method_7675() {
                return 1;
            }
        });
        this.addSecretSlot(new class_1735((class_1263)te.inventory, 0, 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    protected class_1735 addSecretSlot(class_1735 pSlot) {
        pSlot.field_7874 = this.field_7761.size();
        this.field_7761.add((Object)pSlot);
        return pSlot;
    }

    private void initCommon(class_1661 inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSecretSlot(new class_1735((class_1263)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSecretSlot(new class_1735((class_1263)inv, k, 8 + k * 18, 173));
        }
    }

    public boolean method_7604(class_1657 player, int id) {
        int slot = id;
        int level = this.field_7808[slot];
        class_1799 toEnchant = ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots().method_5438(0);
        class_1799 lapis = this.method_7611(1).method_7677();
        int cost = id + 1;
        if ((lapis.method_7960() || lapis.method_7947() < cost) && !player.method_31549().field_7477) {
            return false;
        }
        if (this.field_7808[id] <= 0 || toEnchant.method_7960() || (player.field_7520 < cost || player.field_7520 < this.field_7808[id]) && !player.method_31549().field_7477) {
            return false;
        }
        ((EnchantmentMenuAccessor)((Object)this)).getAccess().method_17393((world, pos) -> {
            class_1799 enchanted = toEnchant;
            float eterna = this.stats.eterna;
            float quanta = this.stats.quanta;
            float arcana = this.stats.arcana;
            float rectification = this.stats.rectification;
            List<class_1889> list = this.getEnchantmentList(toEnchant, slot, this.field_7808[slot]);
            if (list.isEmpty()) return;
            EnchantmentUtils.chargeExperience((class_1657)player, (int)ApothMiscUtil.getExpCostForSlot(level, slot));
            player.method_7286(toEnchant, 0);
            ZenithModCompat.Ench.endRemasteredEnchHook(player);
            if (list.get((int)0).field_9093 == Ench.Enchantments.INFUSION) {
                EnchantingRecipe match = EnchantingRecipe.findMatch(world, toEnchant, eterna, quanta, arcana);
                if (match == null) return;
                ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots().method_5447(0, match.assemble(toEnchant, eterna, quanta, arcana));
            } else {
                ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots().method_5447(0, ((IEnchantableItem)toEnchant.method_7909()).onEnchantment(toEnchant, list));
            }
            if (!player.method_31549().field_7477) {
                lapis.method_7934(cost);
                if (lapis.method_7960()) {
                    ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots().method_5447(1, class_1799.field_8037);
                }
            }
            player.method_7281(class_3468.field_15420);
            if (player instanceof class_3222) {
                ((EnchTrigger)class_174.field_1181).zenith$trigger((class_3222)player, enchanted, level, eterna, quanta, arcana, rectification);
            }
            ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots().method_5431();
            ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed().method_17404(player.method_7278());
            this.method_7609(((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots());
            world.method_8396((class_1657)null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
        });
        return true;
    }

    public void method_7609(class_1263 inventoryIn) {
        ((EnchantmentMenuAccessor)((Object)this)).getAccess().method_17395((world, pos) -> {
            if (inventoryIn == ((EnchantmentMenuAccessor)((Object)this)).getEnchantSlots()) {
                class_1799 toEnchant = inventoryIn.method_5438(0);
                this.gatherStats();
                EnchantingRecipe match = EnchantingRecipe.findItemMatch(world, toEnchant);
                if (toEnchant.method_7947() == 1 && (match != null || toEnchant.method_7909().method_7870(toEnchant) && ApothEnchantmentMenu.isEnchantableEnough(toEnchant))) {
                    int slot;
                    float eterna = this.stats.eterna();
                    if ((double)eterna < 1.5) {
                        eterna = 1.5f;
                    }
                    ((EnchantmentMenuAccessor)((Object)this)).getRandom().method_43052((long)((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed().method_17407());
                    for (slot = 0; slot < 3; ++slot) {
                        this.field_7808[slot] = RealEnchantmentHelper.getEnchantmentCost(((EnchantmentMenuAccessor)((Object)this)).getRandom(), slot, eterna, toEnchant);
                        this.field_7812[slot] = -1;
                        this.field_7810[slot] = -1;
                        if (this.field_7808[slot] >= slot + 1) continue;
                        int n = slot;
                        this.field_7808[n] = this.field_7808[n] + 1;
                    }
                    for (slot = 0; slot < 3; ++slot) {
                        List<class_1889> list;
                        if (this.field_7808[slot] <= 0 || (list = this.getEnchantmentList(toEnchant, slot, this.field_7808[slot])) == null || list.isEmpty()) continue;
                        class_1889 enchantmentdata = list.remove(((EnchantmentMenuAccessor)((Object)this)).getRandom().method_43048(list.size()));
                        this.field_7812[slot] = class_7923.field_41176.method_10206((Object)enchantmentdata.field_9093);
                        this.field_7810[slot] = enchantmentdata.field_9094;
                        int clues = this.stats.clues();
                        ArrayList<class_1889> clueList = new ArrayList<class_1889>();
                        if (clues-- > 0) {
                            clueList.add(enchantmentdata);
                        }
                        while (clues-- > 0 && !list.isEmpty()) {
                            clueList.add(list.remove(((EnchantmentMenuAccessor)((Object)this)).getRandom().method_43048(list.size())));
                        }
                        ClueMessage.sendTo(slot, clueList, list.isEmpty(), this.player);
                    }
                    this.method_7623();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.field_7808[i] = 0;
                        this.field_7812[i] = -1;
                        this.field_7810[i] = -1;
                    }
                    this.stats = TableStats.INVALID;
                    StatsMessage.sendTo(this.stats, this.player);
                }
            }
            return this;
        });
    }

    private List<class_1889> getEnchantmentList(class_1799 stack, int enchantSlot, int level) {
        ((EnchantmentMenuAccessor)((Object)this)).getRandom().method_43052((long)(((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed().method_17407() + enchantSlot));
        List<class_1889> list = RealEnchantmentHelper.selectEnchantment(((EnchantmentMenuAccessor)((Object)this)).getRandom(), stack, level, this.stats.quanta(), this.stats.arcana(), this.stats.rectification(), this.stats.treasure(), this.stats.blacklist());
        EnchantingRecipe match = ((Optional)((EnchantmentMenuAccessor)((Object)this)).getAccess().method_17395((world, pos) -> Optional.ofNullable(EnchantingRecipe.findMatch(world, stack, this.stats.eterna(), this.stats.quanta(), this.stats.arcana()))).get()).orElse(null);
        if (enchantSlot == 2 && match != null) {
            list.clear();
            list.add(new class_1889((class_1887)Ench.Enchantments.INFUSION, 1));
        }
        return list;
    }

    public void gatherStats() {
        ((EnchantmentMenuAccessor)((Object)this)).getAccess().method_17395((world, pos) -> {
            this.stats = ApothEnchantmentMenu.gatherStats(world, pos, this.method_7611(0).method_7677().method_7909().method_7837());
            StatsMessage.sendTo(this.stats, this.player);
            return this;
        }).orElse(this);
    }

    public static TableStats gatherStats(class_1937 level, class_2338 pos, int itemEnch) {
        TableStats.Builder builder = new TableStats.Builder(itemEnch);
        for (class_2338 offset : class_2331.field_36535) {
            if (!ApothEnchantmentMenu.canReadStatsFrom(level, pos, offset)) continue;
            ApothEnchantmentMenu.gatherStats(builder, level, pos.method_10081((class_2382)offset));
        }
        return builder.build();
    }

    public static boolean canReadStatsFrom(class_1937 level, class_2338 tablePos, class_2338 offset) {
        return level.method_8320(tablePos.method_10069(offset.method_10263() / 2, offset.method_10264(), offset.method_10260() / 2)).method_26164(class_3481.field_44473);
    }

    public static void gatherStats(TableStats.Builder builder, class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return;
        }
        float eterna = EnchantingStatRegistry.getEterna(state, world, pos);
        float max = EnchantingStatRegistry.getMaxEterna(state, world, pos);
        builder.addEterna(eterna, max);
        builder.addQuanta(EnchantingStatRegistry.getQuanta(state, world, pos));
        builder.addArcana(EnchantingStatRegistry.getArcana(state, world, pos));
        builder.addRectification(EnchantingStatRegistry.getQuantaRectification(state, world, pos));
        builder.addClues(EnchantingStatRegistry.getBonusClues(state, world, pos));
        ((IEnchantingBlock)state.method_26204()).getBlacklistedEnchantments(state, (class_4538)world, pos).forEach(builder::blacklistEnchant);
        if (((IEnchantingBlock)state.method_26204()).allowsTreasure(state, (class_4538)world, pos)) {
            builder.setAllowsTreasure(true);
        }
    }

    public class_3917<?> method_17358() {
        return Ench.Menus.ENCHANTING_TABLE;
    }

    public static boolean isEnchantableEnough(class_1799 stack) {
        if (!stack.method_7942()) {
            return true;
        }
        return class_1890.method_8222((class_1799)stack).keySet().stream().allMatch(class_1887::method_8195);
    }

    public record TableStats(float eterna, float quanta, float arcana, float rectification, int clues, Set<class_1887> blacklist, boolean treasure) {
        public static TableStats INVALID = new TableStats(0.0f, 0.0f, 0.0f, 0.0f, 0, Collections.emptySet(), false);

        public TableStats(float eterna, float quanta, float arcana, float rectification, int clues, Set<class_1887> blacklist, boolean treasure) {
            this.eterna = class_3532.method_15363((float)eterna, (float)0.0f, (float)EnchantingStatRegistry.getAbsoluteMaxEterna());
            this.quanta = class_3532.method_15363((float)quanta, (float)0.0f, (float)100.0f);
            this.arcana = class_3532.method_15363((float)arcana, (float)0.0f, (float)100.0f);
            this.rectification = class_3532.method_15363((float)rectification, (float)0.0f, (float)100.0f);
            this.clues = Math.max(clues, 0);
            this.blacklist = Collections.unmodifiableSet(blacklist);
            this.treasure = treasure;
        }

        public TableStats(float[] data, Set<class_1887> blacklist, boolean treasure) {
            this(data[0], data[1], data[2], data[3], (int)data[4], blacklist, treasure);
        }

        public void write(class_2540 buf) {
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
            buf.writeShort(this.blacklist.size());
            for (class_1887 e : this.blacklist) {
                buf.method_10804(class_7923.field_41176.method_10206((Object)e));
            }
            buf.writeBoolean(this.treasure);
        }

        public static TableStats read(class_2540 buf) {
            float[] data = new float[]{buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte()};
            int size = buf.readShort();
            HashSet<class_1887> blacklist = new HashSet<class_1887>(size);
            for (int i = 0; i < size; ++i) {
                blacklist.add((class_1887)class_7923.field_41176.method_10200(buf.method_10816()));
            }
            boolean treasure = buf.readBoolean();
            return new TableStats(data, blacklist, treasure);
        }

        public static class Builder {
            private final Float2FloatMap eternaMap = new Float2FloatOpenHashMap();
            private final Set<class_1887> blacklist = new HashSet<class_1887>();
            private boolean allowsTreasure = false;
            private final float[] stats = new float[5];

            public Builder(int itemEnch) {
                this.addQuanta(15.0f);
                this.addArcana((float)itemEnch / 2.0f);
                this.addClues(1);
            }

            public void addEterna(float eterna, float max) {
                this.eternaMap.put(max, this.eternaMap.getOrDefault(max, 0.0f) + eterna);
            }

            public void addQuanta(float quanta) {
                this.stats[1] = this.stats[1] + quanta;
            }

            public void addArcana(float arcana) {
                this.stats[2] = this.stats[2] + arcana;
            }

            public void addRectification(float rectification) {
                this.stats[3] = this.stats[3] + rectification;
            }

            public void addClues(int clues) {
                this.stats[4] = this.stats[4] + (float)clues;
            }

            public void blacklistEnchant(class_1887 ench) {
                this.blacklist.add(ench);
            }

            public void setAllowsTreasure(boolean allowsTreasure) {
                this.allowsTreasure = allowsTreasure;
            }

            public TableStats build() {
                ArrayList entries = new ArrayList(this.eternaMap.float2FloatEntrySet());
                Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
                for (Float2FloatMap.Entry e : entries) {
                    if (e.getFloatKey() > 0.0f) {
                        this.stats[0] = Math.min(e.getFloatKey(), this.stats[0] + e.getFloatValue());
                        continue;
                    }
                    this.stats[0] = this.stats[0] + e.getFloatValue();
                }
                return new TableStats(this.stats, this.blacklist, this.allowsTreasure);
            }
        }
    }

    public static enum Arcana {
        EMPTY(0.0f, 10, 5, 2, 1),
        LITTLE(10.0f, 8, 5, 3, 1),
        FEW(20.0f, 7, 5, 4, 2),
        SOME(30.0f, 5, 5, 4, 2),
        LESS(40.0f, 5, 5, 4, 3),
        MEDIUM(50.0f, 5, 5, 5, 5),
        MORE(60.0f, 3, 4, 5, 5),
        VALUE(70.0f, 2, 4, 5, 5),
        EXTRA(80.0f, 2, 4, 5, 7),
        ALMOST(90.0f, 1, 3, 5, 8),
        MAX(99.0f, 1, 2, 5, 10);

        final float threshold;
        final int[] rarities;
        static Arcana[] VALUES;

        private Arcana(float threshold, int ... rarities) {
            this.threshold = threshold;
            this.rarities = rarities;
        }

        public int[] getRarities() {
            return this.rarities;
        }

        public static Arcana getForThreshold(float threshold) {
            for (int i = VALUES.length - 1; i >= 0; --i) {
                if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
                return VALUES[i];
            }
            return EMPTY;
        }

        static {
            VALUES = Arcana.values();
        }
    }
}

