/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchScreen;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.RealEnchantmentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6880;

public class EnchantingInfoScreen
extends class_437 {
    public static final class_2960 TEXTURES = new class_2960("zenith", "textures/gui/enchanting_info.png");
    protected static class_124[] colors = new class_124[]{class_124.field_1068, class_124.field_1054, class_124.field_1078, class_124.field_1065};
    protected final ApothEnchScreen parent;
    protected final int imageWidth;
    protected final int imageHeight;
    protected final class_1799 toEnchant;
    protected final int[] costs;
    protected final int[] clues;
    protected final int[][] powers = new int[3][];
    protected final boolean treasure;
    protected int selectedSlot = -1;
    protected int leftPos;
    protected int topPos;
    protected PowerSlider slider;
    protected int currentPower;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    List<EnchantmentDataWrapper> enchantments = Collections.emptyList();
    Map<class_1887, List<class_1887>> exclusions = new HashMap<class_1887, List<class_1887>>();

    public EnchantingInfoScreen(ApothEnchScreen parent) {
        super((class_2561)class_2561.method_43471((String)"info.zenith.enchinfo_title"));
        this.parent = parent;
        this.imageWidth = 240;
        this.imageHeight = 170;
        this.toEnchant = parent.getMenu().method_7611(0).method_7677();
        this.costs = parent.getMenu().field_7808;
        this.clues = parent.getMenu().field_7812;
        this.treasure = parent.getMenu().stats.treasure();
        for (int i = 0; i < 3; ++i) {
            class_1887 clue = class_1887.method_8191((int)this.clues[i]);
            if (clue == null) continue;
            int level = this.costs[i];
            float quanta = parent.getMenu().stats.quanta() / 100.0f;
            float rectification = parent.getMenu().stats.rectification() / 100.0f;
            int minPow = Math.round(class_3532.method_15363((float)((float)level - (float)level * (quanta - quanta * rectification)), (float)1.0f, (float)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f)));
            int maxPow = Math.round(class_3532.method_15363((float)((float)level + (float)level * quanta), (float)1.0f, (float)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f)));
            this.powers[i] = new int[]{minPow, maxPow};
            this.selectedSlot = i;
        }
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.slider = (PowerSlider)this.method_37063((class_364)new PowerSlider(this.leftPos + 5, this.topPos + 80, 80, 20));
    }

    public void method_25394(class_332 gfx, int pMouseX, int pMouseY, float pPartialTick) {
        int i;
        int v;
        this.method_25420(gfx);
        class_4587 pose = gfx.method_51448();
        pose.method_22903();
        pose.method_46416((float)this.leftPos, (float)this.topPos, 0.0f);
        gfx.method_25302(TEXTURES, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int i2 = 0; i2 < 3; ++i2) {
            class_1887 clue = class_1887.method_8191((int)this.clues[i2]);
            int u = 199;
            v = 225;
            if (clue == null) {
                u += 19;
                v += 16;
            } else if (this.selectedSlot == i2 || this.isHovering(8, 18 + 19 * i2, 18, 18, pMouseX, pMouseY)) {
                u += 38;
            }
            gfx.method_25302(TEXTURES, 8, 18 + 19 * i2, 224, u, 18, 19);
            gfx.method_25302(TEXTURES, 9, 22 + 18 * i2 + i2, 16 * i2, v, 16, 16);
        }
        int scrollbarPos = (int)(128.0f * this.scrollOffs);
        gfx.method_25302(TEXTURES, 220, 18 + scrollbarPos, 244, 173 + (this.isScrollBarActive() ? 0 : 15), 12, 15);
        EnchantmentDataWrapper hover = this.getHovered(pMouseX, pMouseY);
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            v = 173;
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            if (data.isBlacklisted) {
                v += 26;
            } else if (hover == this.enchantments.get(this.startIndex + i)) {
                v += 13;
            }
            gfx.method_25302(TEXTURES, 89, 18 + 13 * i, 96, v, 128, 13);
        }
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            if (data.isBlacklisted) {
                gfx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)data.getEnch().method_8184()).method_27694(s -> s.method_36139(5812428).method_36140(Boolean.valueOf(true))), 91, 21 + 13 * i, 0xFFFF80, false);
                continue;
            }
            gfx.method_51433(this.field_22793, class_1074.method_4662((String)data.getEnch().method_8184(), (Object[])new Object[0]), 91, 21 + 13 * i, 0xFFFF80, false);
        }
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        ApothEnchantmentMenu.Arcana a = ApothEnchantmentMenu.Arcana.getForThreshold(this.parent.getMenu().stats.arcana());
        list.add(class_2561.method_43471((String)"info.zenith.weights").method_27695(new class_124[]{class_124.field_1073, class_124.field_1054}));
        list.add(class_2561.method_43469((String)"info.zenith.weight", (Object[])new Object[]{class_1074.method_4662((String)"rarity.enchantment.common", (Object[])new Object[0]), a.rarities[0]}).method_27692(class_124.field_1080));
        list.add(class_2561.method_43469((String)"info.zenith.weight", (Object[])new Object[]{class_1074.method_4662((String)"rarity.enchantment.uncommon", (Object[])new Object[0]), a.rarities[1]}).method_27692(class_124.field_1060));
        list.add(class_2561.method_43469((String)"info.zenith.weight", (Object[])new Object[]{class_1074.method_4662((String)"rarity.enchantment.rare", (Object[])new Object[0]), a.rarities[2]}).method_27692(class_124.field_1078));
        list.add(class_2561.method_43469((String)"info.zenith.weight", (Object[])new Object[]{class_1074.method_4662((String)"rarity.enchantment.very_rare", (Object[])new Object[0]), a.rarities[3]}).method_27692(class_124.field_1065));
        gfx.method_51434(this.field_22793, list, a == ApothEnchantmentMenu.Arcana.MAX ? -2 : 1, 120);
        gfx.method_51439(this.field_22793, this.field_22785, 7, 4, 0x404040, false);
        pose.method_22909();
        pose.method_46416(0.0f, 0.0f, 10.0f);
        for (int i3 = 0; i3 < 3; ++i3) {
            if (!this.isHovering(8, 18 + 19 * i3, 18, 18, pMouseX, pMouseY)) continue;
            list.clear();
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_slot", (Object[])new Object[]{i3 + 1}).method_27695(new class_124[]{class_124.field_1065, class_124.field_1073}));
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_level", (Object[])new Object[]{this.costs[i3]}).method_27692(class_124.field_1060));
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_minpow", (Object[])new Object[]{this.powers[i3][0]}).method_27692(class_124.field_1079));
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_maxpow", (Object[])new Object[]{this.powers[i3][1]}).method_27692(class_124.field_1078));
            gfx.method_51434(this.field_22793, list, pMouseX, pMouseY);
        }
        if (hover != null) {
            List<class_1887> excls;
            list.clear();
            list.add(class_2561.method_43471((String)hover.getEnch().method_8184()).method_27695(new class_124[]{EnchantingInfoScreen.getColor(hover.getEnch()), class_124.field_1073}));
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_level", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + hover.getLevel()))}).method_27692(class_124.field_1062));
            class_5250 rarity = class_2561.method_43471((String)("rarity.enchantment." + hover.getEnch().method_8186().name().toLowerCase(Locale.ROOT))).method_27692(colors[hover.getEnch().method_8186().ordinal()]);
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_rarity", (Object[])new Object[]{rarity}).method_27692(class_124.field_1062));
            list.add(class_2561.method_43469((String)"info.zenith.enchinfo_chance", (Object[])new Object[]{String.format("%.2f", Float.valueOf(100.0f * (float)hover.method_34979().method_34976() / (float)class_6011.method_34984(this.enchantments))) + "%"}).method_27692(class_124.field_1062));
            if (class_1074.method_4663((String)(hover.getEnch().method_8184() + ".desc"))) {
                list.add(class_2561.method_43471((String)(hover.getEnch().method_8184() + ".desc")).method_27692(class_124.field_1062));
            }
            if (!(excls = this.exclusions.get(hover.getEnch())).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i4 = 0; i4 < excls.size(); ++i4) {
                    sb.append(class_1074.method_4662((String)excls.get(i4).method_8184(), (Object[])new Object[0]));
                    if (i4 == excls.size() - 1) continue;
                    sb.append(", ");
                }
                list.add(class_2561.method_43469((String)"info.zenith.exclusive", (Object[])new Object[]{sb.toString()}).method_27692(class_124.field_1061));
            }
            gfx.method_51434(this.field_22793, list, pMouseX, pMouseY);
        }
        gfx.method_51445(this.toEnchant, this.leftPos + 49, this.topPos + 39);
        pose.method_46416(0.0f, 0.0f, -10.0f);
        super.method_25394(gfx, pMouseX, pMouseY, pPartialTick);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.leftPos + 220;
        int top = this.topPos + 18;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 143)) {
            this.scrolling = true;
            this.method_25403(pMouseX, pMouseY, 0, pMouseX, pMouseY);
        }
        for (int i = 0; i < 3; ++i) {
            class_1887 clue = class_1887.method_8191((int)this.clues[i]);
            if (this.selectedSlot == i || clue == null || !this.isHovering(8, 18 + 19 * i, 18, 18, pMouseX, pMouseY)) continue;
            this.selectedSlot = i;
            this.slider.setValue((this.slider.min() + this.slider.max()) / 2);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 18;
            int j = i + 143;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.enchantments.size() > 11;
    }

    protected int getOffscreenRows() {
        return this.enchantments.size() - 11;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    protected void recomputeEnchantments() {
        ApothEnchantmentMenu.Arcana arc = ApothEnchantmentMenu.Arcana.getForThreshold(this.parent.getMenu().stats.arcana());
        Set<class_1887> blacklist = this.parent.getMenu().stats.blacklist();
        this.enchantments = RealEnchantmentHelper.getAvailableEnchantmentResults(this.currentPower, this.toEnchant, this.treasure, Collections.emptySet()).stream().map(e -> new RealEnchantmentHelper.ArcanaEnchantmentData(arc, (class_1889)e)).map(a -> new EnchantmentDataWrapper((RealEnchantmentHelper.ArcanaEnchantmentData)((Object)a), blacklist.contains(a.data.field_9093))).collect(Collectors.toList());
        if (this.startIndex + 11 >= this.enchantments.size()) {
            this.startIndex = 0;
            this.scrollOffs = 0.0f;
        }
        this.exclusions.clear();
        for (EnchantmentDataWrapper d : this.enchantments) {
            if (blacklist.contains(d.getEnch())) continue;
            ArrayList<class_1887> excls = new ArrayList<class_1887>();
            for (EnchantmentDataWrapper d2 : this.enchantments) {
                if (d == d2 || d.getEnch().method_8188(d2.getEnch())) continue;
                excls.add(d2.getEnch());
            }
            this.exclusions.put(d.getEnch(), excls);
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected EnchantmentDataWrapper getHovered(double mouseX, double mouseY) {
        for (int i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            if (!this.isHovering(89, 18 + i * 13, 128, 13, mouseX, mouseY)) continue;
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            return data.isBlacklisted ? null : data;
        }
        return null;
    }

    public static class_124 getColor(class_1887 ench) {
        return EnchModule.getEnchInfo(ench).isTreasure() ? class_124.field_1065 : class_124.field_1060;
    }

    public class PowerSlider
    extends class_357 {
        public PowerSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
            if (EnchantingInfoScreen.this.selectedSlot != -1 && this.field_22753 == 0.0) {
                this.field_22753 = this.normalizeValue(EnchantingInfoScreen.this.currentPower == 0 ? (double)((this.max() + this.min()) / 2) : (double)EnchantingInfoScreen.this.currentPower);
                this.method_25344();
            }
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)"info.zenith.slider_power", (Object[])new Object[]{EnchantingInfoScreen.this.currentPower}));
        }

        protected void method_25344() {
            EnchantingInfoScreen.this.currentPower = this.denormalizeValue(this.field_22753);
            EnchantingInfoScreen.this.recomputeEnchantments();
        }

        public void setValue(int value) {
            if (!EnchantingInfoScreen.this.method_25397()) {
                this.field_22753 = this.normalizeValue(value);
                this.method_25344();
                this.method_25346();
            }
        }

        public double normalizeValue(double value) {
            return class_3532.method_15350((double)((this.snapToStepClamp(value) - (double)this.min()) / (double)(this.max() - this.min())), (double)0.0, (double)1.0);
        }

        public int denormalizeValue(double value) {
            return (int)this.snapToStepClamp(class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.min(), (double)this.max()));
        }

        private double snapToStepClamp(double valueIn) {
            if (this.step() > 0.0f) {
                valueIn = this.step() * (float)Math.round(valueIn / (double)this.step());
            }
            return class_3532.method_15350((double)valueIn, (double)this.min(), (double)this.max());
        }

        private int min() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][0];
        }

        private int max() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][1];
        }

        private float step() {
            return 1.0f / (float)Math.max(this.max() - this.min(), 1);
        }
    }

    protected static class EnchantmentDataWrapper
    extends class_6008.class_6009 {
        protected final RealEnchantmentHelper.ArcanaEnchantmentData data;
        protected final boolean isBlacklisted;

        public EnchantmentDataWrapper(RealEnchantmentHelper.ArcanaEnchantmentData data, boolean isBlacklisted) {
            super(isBlacklisted ? 0 : data.method_34979().method_34976());
            this.data = data;
            this.isBlacklisted = isBlacklisted;
        }

        public class_1887 getEnch() {
            return this.data.data.field_9093;
        }

        public int getLevel() {
            return this.data.data.field_9094;
        }
    }
}

