/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.potion;

import dev.shadowsoffire.apotheosis.potion.PotionModule;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.item.DamageableItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class PotionCharmItem
extends class_1792
implements CustomEnchantingBehaviorItem,
DamageableItem {
    public static final Set<class_2960> EXTENDED_POTIONS = new HashSet<class_2960>();

    public PotionCharmItem() {
        super(new class_1792.class_1793().method_7889(1).method_7895(192));
    }

    public class_1799 method_7854() {
        return class_1844.method_8061((class_1799)super.method_7854(), (class_1842)class_1847.field_9000);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean isSelected) {
        if (!PotionModule.charmsInTrinketsOnly) {
            this.charmLogic(stack, world, entity, slot, isSelected);
        }
    }

    public void charmLogic(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean isSelected) {
        if (!PotionCharmItem.hasEffect(stack)) {
            return;
        }
        if (stack.method_7948().method_10577("charm_enabled") && entity instanceof class_3222) {
            boolean matches;
            class_3222 serverPlayer = (class_3222)entity;
            class_1293 contained = PotionCharmItem.getEffect(stack);
            class_1291 eff = contained.method_5579();
            class_1293 active = serverPlayer.method_6112(eff);
            if (active == null || active.method_5584() < PotionCharmItem.getCriticalDuration(active.method_5579())) {
                int durationOffset = PotionCharmItem.getCriticalDuration(eff);
                if (eff == class_1294.field_5924) {
                    durationOffset += 50 >> contained.method_5578();
                }
                class_1293 newEffect = new class_1293(eff, (int)Math.ceil((double)contained.method_5584() / 24.0) + durationOffset, contained.method_5578(), false, false);
                serverPlayer.method_6092(newEffect);
                if (!serverPlayer.method_7337() && stack.method_7970(eff == class_1294.field_5924 ? 2 : 1, world.field_9229, (class_3222)entity)) {
                    stack.method_7934(1);
                }
            }
            if ((matches = PotionModule.CharmMatcher.isDisabled(eff, contained.method_5578())) && PotionModule.yeetInvalidCharms) {
                stack.method_7939(0);
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Illegal charm " + eff.method_5567() + " yeeted, don't die ;)")).method_27692(class_124.field_1061), false);
            }
        }
    }

    private static int getCriticalDuration(class_1291 effect) {
        return EXTENDED_POTIONS.contains(class_7923.field_41174.method_10221((Object)effect)) ? 210 : 5;
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_7948().method_10577("charm_enabled");
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            stack.method_7948().method_10556("charm_enabled", !stack.method_7969().method_10577("charm_enabled"));
        } else if (!stack.method_7969().method_10577("charm_enabled")) {
            world.method_8396(player, player.method_24515(), class_3417.field_14627, class_3419.field_15248, 1.0f, 0.3f);
        }
        return class_1271.method_22427((Object)stack);
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        if (PotionModule.charmsInTrinketsOnly) {
            tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".trinkets_only")).method_27692(class_124.field_1061));
        }
        if (PotionCharmItem.hasEffect(stack)) {
            class_1293 effect = PotionCharmItem.getEffect(stack);
            if (PotionModule.CharmMatcher.isDisabled(effect.method_5579(), effect.method_5578())) {
                tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".crafting_disabled")).method_27692(class_124.field_1061));
            }
            class_5250 potionCmp = class_2561.method_43471((String)effect.method_5586());
            if (effect.method_5578() > 0) {
                potionCmp = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{potionCmp, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
            }
            potionCmp.method_27692(effect.method_5579().method_18792().method_18793());
            tooltip.add((class_2561)class_2561.method_43469((String)(this.method_7876() + ".desc"), (Object[])new Object[]{potionCmp}).method_27692(class_124.field_1080));
            boolean enabled = stack.method_7948().method_10577("charm_enabled");
            class_5250 enabledCmp = class_2561.method_43471((String)(this.method_7876() + (enabled ? ".enabled" : ".disabled")));
            enabledCmp.method_27692(enabled ? class_124.field_1078 : class_124.field_1061);
            if (effect.method_5584() > 20) {
                potionCmp = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{potionCmp, class_1292.method_5577((class_1293)effect, (float)1.0f)});
            }
            potionCmp.method_27692(effect.method_5579().method_18792().method_18793());
            tooltip.add((class_2561)class_2561.method_43469((String)(this.method_7876() + ".desc3"), (Object[])new Object[]{potionCmp}).method_27692(class_124.field_1080));
        }
    }

    public int getMaxDamage(class_1799 stack) {
        if (!PotionCharmItem.hasEffect(stack)) {
            return 1;
        }
        return 192;
    }

    public class_2561 method_7864(class_1799 stack) {
        if (!PotionCharmItem.hasEffect(stack)) {
            return class_2561.method_43471((String)"item.zenith.potion_charm_broke");
        }
        class_1293 effect = PotionCharmItem.getEffect(stack);
        class_5250 potionCmp = class_2561.method_43471((String)effect.method_5586());
        if (effect.method_5578() > 0) {
            potionCmp = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{potionCmp, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
        }
        return class_2561.method_43469((String)"item.zenith.potion_charm", (Object[])new Object[]{potionCmp});
    }

    public static boolean hasEffect(class_1799 stack) {
        List effects = class_1844.method_8067((class_1799)stack);
        return !effects.isEmpty();
    }

    public static class_1293 getEffect(class_1799 stack) {
        return (class_1293)class_1844.method_8067((class_1799)stack).get(0);
    }

    public static void fillItemCategory(class_1761.class_7704 out) {
        for (class_1842 potion : class_7923.field_41179) {
            if (potion.method_8049().size() != 1 || ((class_1293)potion.method_8049().get(0)).method_5579().method_5561() || PotionModule.CharmMatcher.isDisabled(((class_1293)potion.method_8049().get(0)).method_5579(), ((class_1293)potion.method_8049().get(0)).method_5578())) continue;
            out.method_45420(class_1844.method_8061((class_1799)new class_1799((class_1935)PotionModule.POTION_CHARM), (class_1842)potion));
        }
    }

    public String getCreatorModId(class_1799 itemStack) {
        class_1842 potionType = class_1844.method_8063((class_1799)itemStack);
        class_2960 resourceLocation = class_7923.field_41179.method_10221((Object)potionType);
        if (resourceLocation != null) {
            return resourceLocation.method_12836();
        }
        return class_7923.field_41178.method_10221((Object)this).method_12836();
    }

    public int method_7837() {
        return 0;
    }
}

