/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.potion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.potion.PotionModule;
import dev.shadowsoffire.placebo.recipe.RecipeHelper;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8566;

public class PotionCharmRecipe
extends class_1869 {
    protected final IntList potionSlots = new IntArrayList();
    protected final class_1856 potion = PotionCharmRecipe.makePotionIngredient();

    public PotionCharmRecipe(List<Object> ingredients, int width, int height) {
        super(Apotheosis.loc("potion_charm"), "", class_7710.field_40251, width, height, PotionCharmRecipe.makeIngredients(ingredients), new class_1799((class_1935)PotionModule.POTION_CHARM));
        for (int i = 0; i < ingredients.size(); ++i) {
            if (!"potion".equals(ingredients.get(i))) continue;
            this.potionSlots.add(i);
        }
    }

    private static class_1856 makePotionIngredient() {
        ArrayList<class_1799> potionStacks = new ArrayList<class_1799>();
        PotionCharmRecipe.getValidPotions(potionStacks);
        return class_1856.method_8101((class_1799[])potionStacks.toArray(new class_1799[0]));
    }

    public static void getValidPotions(List<class_1799> addedList) {
        for (class_1842 p : class_7923.field_41179) {
            class_2960 id;
            if (p.method_8049().size() != 1 || ((class_1293)p.method_8049().get(0)).method_5579().method_5561() || PotionModule.CharmMatcher.isDisabled(id = class_7923.field_41174.method_10221((Object)((class_1293)p.method_8049().get(0)).method_5579()), ((class_1293)p.method_8049().get(0)).method_5578())) continue;
            class_1799 potion = new class_1799((class_1935)class_1802.field_8574);
            class_1844.method_8061((class_1799)potion, (class_1842)p);
            addedList.add(potion);
        }
    }

    private static class_2371<class_1856> makeIngredients(List<Object> ingredients) {
        ArrayList<Object> realIngredients = new ArrayList<Object>();
        class_1856 potion = PotionCharmRecipe.makePotionIngredient();
        for (Object o : ingredients) {
            if ("potion".equals(o)) {
                realIngredients.add(potion);
                continue;
            }
            realIngredients.add(o);
        }
        return RecipeHelper.createInput((String)"zenith", (boolean)true, (Object[])realIngredients.toArray());
    }

    public class_1856 getPotionIngredient() {
        return this.potion;
    }

    public IntList getPotionSlots() {
        return this.potionSlots;
    }

    public class_1799 method_17727(class_8566 inv, class_5455 regs) {
        class_1799 out = super.method_17727(inv, regs);
        class_1844.method_8061((class_1799)out, (class_1842)class_1844.method_8063((class_1799)inv.method_5438(4)));
        return out;
    }

    public boolean method_17728(class_8566 inv, class_1937 world) {
        List potions;
        if (super.method_17728(inv, world) && (potions = this.potionSlots.intStream().mapToObj(s -> inv.method_5438(s)).map(class_1844::method_8063).collect(Collectors.toList())).size() > 0 && potions.stream().allMatch(p -> p != null && p.method_8049().size() == 1 && !((class_1293)p.method_8049().get(0)).method_5579().method_5561() && !PotionModule.CharmMatcher.isDisabled(((class_1293)p.method_8049().get(0)).method_5579(), ((class_1293)p.method_8049().get(0)).method_5578()))) {
            return potions.stream().distinct().count() == 1L;
        }
        return false;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements class_1865<PotionCharmRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public PotionCharmRecipe fromJson(class_2960 recipeId, JsonObject json) {
            JsonArray inputs = json.get("recipe").getAsJsonArray();
            int width = 0;
            int height = inputs.size();
            ArrayList<Object> ingredients = new ArrayList<Object>();
            for (JsonElement e : inputs) {
                JsonArray arr = e.getAsJsonArray();
                width = arr.size();
                for (JsonElement input : arr) {
                    if (input.isJsonPrimitive() && "potion".equals(input.getAsString())) {
                        ingredients.add("potion");
                        continue;
                    }
                    ingredients.add(CraftingHelper.getIngredient((JsonElement)input));
                }
            }
            return new PotionCharmRecipe(ingredients, width, height);
        }

        public PotionCharmRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            byte width = buffer.readByte();
            byte height = buffer.readByte();
            int potions = buffer.readByte();
            IntArrayList potionSlots = new IntArrayList();
            for (int i = 0; i < potions; ++i) {
                potionSlots.add((int)buffer.readByte());
            }
            ArrayList<Object> inputs = new ArrayList<Object>(width * height);
            for (int i = 0; i < width * height; ++i) {
                if (!potionSlots.contains(i)) {
                    inputs.add(i, class_1856.method_8086((class_2540)buffer));
                    continue;
                }
                inputs.add("potion");
            }
            return new PotionCharmRecipe(inputs, width, height);
        }

        public void toNetwork(class_2540 buffer, PotionCharmRecipe recipe) {
            int i;
            buffer.writeByte(recipe.method_8150());
            buffer.writeByte(recipe.method_8158());
            buffer.writeByte(recipe.potionSlots.size());
            IntListIterator intListIterator = recipe.potionSlots.iterator();
            while (intListIterator.hasNext()) {
                i = (Integer)intListIterator.next();
                buffer.writeByte(i);
            }
            class_2371 inputs = recipe.method_8117();
            for (i = 0; i < inputs.size(); ++i) {
                if (recipe.potionSlots.contains(i)) continue;
                ((class_1856)inputs.get(i)).method_8088(buffer);
            }
        }
    }
}

