/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.potion;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.objects.GlowyBlockItem;
import dev.shadowsoffire.apotheosis.potion.PotionCharmItem;
import dev.shadowsoffire.apotheosis.potion.PotionCharmRecipe;
import dev.shadowsoffire.apotheosis.potion.PotionEnchantingRecipe;
import dev.shadowsoffire.apotheosis.util.ZenithModCompat;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.placebo.config.Configuration;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1463;
import net.minecraft.class_151;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Zenith : Potion");
    public static final PotionCharmItem POTION_CHARM = new PotionCharmItem();
    public static final class_1792 LUCKY_FOOT = new GlowyBlockItem.GlowyItem(new class_1792.class_1793());
    public static int knowledgeMult = 4;
    public static boolean charmsInTrinketsOnly = false;
    public static boolean yeetInvalidCharms = false;
    public static List<CharmMatcher> LIMITED_CHARMS = new ArrayList<CharmMatcher>();
    public static boolean resistanceEnabled = true;
    public static boolean sunderingEnabled = true;
    public static boolean absorptionEnabled = true;
    public static boolean hasteEnabled = true;
    public static boolean fatigueEnabled = true;
    public static boolean witherEnabled = true;
    public static boolean knowledgeEnabled = true;
    public static boolean luckEnabled = true;
    public static boolean vitalityEnabled = true;
    public static boolean grievousEnabled = true;
    public static boolean levitationEnabled = true;
    public static boolean flyingEnabled = true;

    public static void init() {
        PotionModule.reload(false);
        PotionModule.potions();
        PotionModule.items();
        PotionModule.serializers();
        PotionModule.drops();
        ZenithModCompat.Potion.registerTrinkets();
    }

    public static void items() {
        Apoth.registerItem(LUCKY_FOOT, "lucky_foot");
        Apoth.registerItem(POTION_CHARM, "potion_charm");
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(PotionCharmItem::fillItemCategory);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(entries -> entries.method_45421((class_1935)LUCKY_FOOT));
    }

    public static void serializers() {
        Apoth.registerSerializer("potion_charm", PotionCharmRecipe.Serializer.INSTANCE);
        Apoth.registerSerializer("potion_charm_enchanting", PotionEnchantingRecipe.SERIALIZER);
    }

    public static void drops() {
        LivingEntityEvents.DROPS.register((target, source, drops, lootingLevel, recentlyHit) -> {
            if (target instanceof class_1463) {
                class_1463 rabbit = (class_1463)target;
                if (drops != null && rabbit.method_37908().field_9229.method_43057() < 0.045f + 0.045f * (float)lootingLevel) {
                    drops.clear();
                    drops.add(new class_1542(rabbit.method_37908(), rabbit.method_23317(), rabbit.method_23318(), rabbit.method_23321(), new class_1799((class_1935)LUCKY_FOOT)));
                }
            }
            return false;
        });
    }

    public static void reload(boolean e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "potion.cfg"));
        config.setTitle("Zenith Potion Module Configuration");
        knowledgeMult = config.getInt("Knowledge XP Multiplier", "general", knowledgeMult, 1, Integer.MAX_VALUE, "The strength of Ancient Knowledge.  This multiplier determines how much additional xp is granted.\nServer-authoritative.");
        charmsInTrinketsOnly = config.getBoolean("Restrict Charms to Trinkets", "general", charmsInTrinketsOnly, "If Potion Charms will only work when in a trinkets slot, instead of in the inventory.");
        String[] defExt = new String[]{class_7923.field_41174.method_10221((Object)class_1294.field_5925).toString(), class_7923.field_41174.method_10221((Object)class_1294.field_5914).toString()};
        String[] names = config.getStringList("Extended Potion Charms", "general", defExt, "A list of effects that, when as charms, will be applied and reapplied at a longer threshold to avoid issues at low durations, like night vision.\nServer-authoritative.");
        PotionCharmItem.EXTENDED_POTIONS.clear();
        for (String s : names) {
            try {
                PotionCharmItem.EXTENDED_POTIONS.add(new class_2960(s));
            }
            catch (class_151 ex) {
                LOGGER.error("Invalid extended potion charm entry {} will be ignored.", (Object)s);
            }
        }
        String[] defDis = new String[]{"modid:charm_id", "modid:charm_id_two|3"};
        String[] disabled = config.getStringList("Disabled Potion Charms", "general", defDis, "Disabled Charm Rules, in the form of Charm Matchers, permitting potion charms to reach a certain level.\nThe format for these is domain:pattern|max and domain is optional.  Domain is a modid, pattern is a regex string, and max is a positive integer that is the maximum possible charm level.\nIf you omit the domain, the format is pattern|chance, and the matcher will run for all domains.\nThe pattern MUST be a valid regex string, and should match the paths of desired loot tables under the specified domain.  Note: \"Match Any Character\" is \".*\" (dot star) and not \"*\" (star).\nIf there is a match, a charm up that level (inclusive) can be crafted.\nServer-authoritative.");
        yeetInvalidCharms = config.getBoolean("Yeet Uncraftable Charms", "general", yeetInvalidCharms, "If charms that are uncraftable are removed from the user.");
        LIMITED_CHARMS.clear();
        for (String s : disabled) {
            try {
                LIMITED_CHARMS.add(CharmMatcher.parse(s));
            }
            catch (Exception ex) {
                LOGGER.error("Invalid disabled potion charm entry {} will be ignored.", (Object)s);
                ex.printStackTrace();
            }
        }
        config.setCategoryComment("brewing", "All brewing recipe disables are Server-authoritative.");
        resistanceEnabled = config.getBoolean("Resistance", "brewing", resistanceEnabled, "If this potion type will be craftable in the brewing stand.");
        sunderingEnabled = config.getBoolean("Sundering", "brewing", sunderingEnabled, "If this potion type will be craftable in the brewing stand.");
        absorptionEnabled = config.getBoolean("Absorption", "brewing", absorptionEnabled, "If this potion type will be craftable in the brewing stand.");
        hasteEnabled = config.getBoolean("Haste", "brewing", hasteEnabled, "If this potion type will be craftable in the brewing stand.");
        fatigueEnabled = config.getBoolean("Fatigue", "brewing", fatigueEnabled, "If this potion type will be craftable in the brewing stand.");
        witherEnabled = config.getBoolean("Wither", "brewing", witherEnabled, "If this potion type will be craftable in the brewing stand.");
        knowledgeEnabled = config.getBoolean("Knowledge", "brewing", knowledgeEnabled, "If this potion type will be craftable in the brewing stand.");
        luckEnabled = config.getBoolean("Luck", "brewing", luckEnabled, "If this potion type will be craftable in the brewing stand.");
        vitalityEnabled = config.getBoolean("Vitality", "brewing", vitalityEnabled, "If this potion type will be craftable in the brewing stand.");
        grievousEnabled = config.getBoolean("Grievous", "brewing", grievousEnabled, "If this potion type will be craftable in the brewing stand.");
        levitationEnabled = config.getBoolean("Levitation", "brewing", levitationEnabled, "If this potion type will be craftable in the brewing stand.");
        flyingEnabled = config.getBoolean("Flying", "brewing", flyingEnabled, "If this potion type will be craftable in the brewing stand.");
        if (!e && config.hasChanged()) {
            config.save();
        }
    }

    public static void potions() {
        if (resistanceEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_8815, (class_1842)Potion.RESISTANCE);
            class_1845.method_8074((class_1842)Potion.RESISTANCE, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_RESISTANCE);
            class_1845.method_8074((class_1842)Potion.RESISTANCE, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_RESISTANCE);
        }
        if (sunderingEnabled) {
            class_1845.method_8074((class_1842)Potion.RESISTANCE, (class_1792)class_1802.field_8711, (class_1842)Potion.SUNDERING);
            class_1845.method_8074((class_1842)Potion.LONG_RESISTANCE, (class_1792)class_1802.field_8711, (class_1842)Potion.LONG_SUNDERING);
            class_1845.method_8074((class_1842)Potion.STRONG_RESISTANCE, (class_1792)class_1802.field_8711, (class_1842)Potion.STRONG_SUNDERING);
            class_1845.method_8074((class_1842)Potion.SUNDERING, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_SUNDERING);
            class_1845.method_8074((class_1842)Potion.SUNDERING, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_SUNDERING);
        }
        if (absorptionEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_8463, (class_1842)Potion.ABSORPTION);
            class_1845.method_8074((class_1842)Potion.ABSORPTION, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_ABSORPTION);
            class_1845.method_8074((class_1842)Potion.ABSORPTION, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_ABSORPTION);
        }
        if (hasteEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_8208, (class_1842)Potion.HASTE);
            class_1845.method_8074((class_1842)Potion.HASTE, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_HASTE);
            class_1845.method_8074((class_1842)Potion.HASTE, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_HASTE);
        }
        if (fatigueEnabled) {
            class_1845.method_8074((class_1842)Potion.HASTE, (class_1792)class_1802.field_8711, (class_1842)Potion.FATIGUE);
            class_1845.method_8074((class_1842)Potion.LONG_HASTE, (class_1792)class_1802.field_8711, (class_1842)Potion.LONG_FATIGUE);
            class_1845.method_8074((class_1842)Potion.STRONG_HASTE, (class_1792)class_1802.field_8711, (class_1842)Potion.STRONG_FATIGUE);
            class_1845.method_8074((class_1842)Potion.FATIGUE, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_FATIGUE);
            class_1845.method_8074((class_1842)Potion.FATIGUE, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_FATIGUE);
        }
        if (witherEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_8791, (class_1842)Potion.WITHER);
            class_1845.method_8074((class_1842)Potion.WITHER, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_WITHER);
            class_1845.method_8074((class_1842)Potion.WITHER, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_WITHER);
        }
        if (knowledgeEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_8287, (class_1842)Potion.KNOWLEDGE);
            class_1845.method_8074((class_1842)Potion.KNOWLEDGE, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_KNOWLEDGE);
            class_1845.method_8074((class_1842)Potion.KNOWLEDGE, (class_1792)class_1802.field_8287, (class_1842)Potion.STRONG_KNOWLEDGE);
        }
        if (luckEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)LUCKY_FOOT, (class_1842)class_1847.field_8995);
        }
        if (vitalityEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)class_1802.field_16998, (class_1842)Potion.VITALITY);
            class_1845.method_8074((class_1842)Potion.VITALITY, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_VITALITY);
            class_1845.method_8074((class_1842)Potion.VITALITY, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_VITALITY);
        }
        if (grievousEnabled) {
            class_1845.method_8074((class_1842)Potion.VITALITY, (class_1792)class_1802.field_8711, (class_1842)Potion.GRIEVOUS);
            class_1845.method_8074((class_1842)Potion.LONG_VITALITY, (class_1792)class_1802.field_8711, (class_1842)Potion.LONG_GRIEVOUS);
            class_1845.method_8074((class_1842)Potion.STRONG_VITALITY, (class_1792)class_1802.field_8711, (class_1842)Potion.STRONG_GRIEVOUS);
            class_1845.method_8074((class_1842)Potion.GRIEVOUS, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_GRIEVOUS);
            class_1845.method_8074((class_1842)Potion.GRIEVOUS, (class_1792)class_1802.field_8601, (class_1842)Potion.STRONG_GRIEVOUS);
        }
        if (levitationEnabled) {
            class_1845.method_8074((class_1842)class_1847.field_8974, (class_1792)class_1802.field_8711, (class_1842)Potion.LEVITATION);
        }
        if (flyingEnabled) {
            class_1845.method_8074((class_1842)Potion.LEVITATION, (class_1792)class_1802.field_8882, (class_1842)Potion.FLYING);
            class_1845.method_8074((class_1842)Potion.FLYING, (class_1792)class_1802.field_8725, (class_1842)Potion.LONG_FLYING);
            class_1845.method_8074((class_1842)Potion.LONG_FLYING, (class_1792)class_1802.field_8725, (class_1842)Potion.EXTRA_LONG_FLYING);
        }
    }

    public record CharmMatcher(String domain, Pattern pathRegex, int maxLevel) {
        public static boolean isDisabled(class_1291 effect, int amplifier) {
            return CharmMatcher.isDisabled(class_7923.field_41174.method_10221((Object)effect), amplifier);
        }

        public static boolean isDisabled(class_2960 id, int amplifier) {
            return LIMITED_CHARMS.stream().anyMatch(charmMatcher -> charmMatcher.matches(id, amplifier + 1));
        }

        public boolean matches(class_1291 effect, int amplifier) {
            class_2960 id = class_7923.field_41174.method_10221((Object)effect);
            return this.matches(id, amplifier);
        }

        public boolean matches(class_2960 id, int amplifier) {
            return !(this.domain != null && !this.domain.equals(id.method_12836()) || !this.pathRegex.matcher(id.method_12832()).matches() || amplifier != this.maxLevel && this.maxLevel != Integer.MAX_VALUE);
        }

        public static CharmMatcher parse(String s) throws Exception {
            int pipe = s.lastIndexOf(124);
            int colon = s.indexOf(58);
            int maxLevel = Integer.MAX_VALUE;
            if (pipe > 0) {
                maxLevel = Integer.parseInt(s.substring(pipe + 1));
                if (maxLevel < 1) {
                    throw new Exception("Level " + maxLevel + " cannot be less than 1!");
                }
            } else {
                pipe = s.length();
            }
            String domain = s.substring(0, colon);
            Pattern pattern = Pattern.compile(s.substring(colon + 1, pipe));
            return new CharmMatcher(domain, pattern, maxLevel);
        }
    }

    public static class Potion {
        public static final class_1842 RESISTANCE = Apoth.registerPot(new class_1842("resistance", new class_1293[]{new class_1293(class_1294.field_5907, 3600)}), "resistance");
        public static final class_1842 LONG_RESISTANCE = Apoth.registerPot(new class_1842("resistance", new class_1293[]{new class_1293(class_1294.field_5907, 9600)}), "long_resistance");
        public static final class_1842 STRONG_RESISTANCE = Apoth.registerPot(new class_1842("resistance", new class_1293[]{new class_1293(class_1294.field_5907, 1800, 1)}), "strong_resistance");
        public static final class_1842 ABSORPTION = Apoth.registerPot(new class_1842("absorption", new class_1293[]{new class_1293(class_1294.field_5898, 1200, 1)}), "absorption");
        public static final class_1842 LONG_ABSORPTION = Apoth.registerPot(new class_1842("absorption", new class_1293[]{new class_1293(class_1294.field_5898, 3600, 1)}), "long_absorption");
        public static final class_1842 STRONG_ABSORPTION = Apoth.registerPot(new class_1842("absorption", new class_1293[]{new class_1293(class_1294.field_5898, 600, 3)}), "strong_absorption");
        public static final class_1842 HASTE = Apoth.registerPot(new class_1842("haste", new class_1293[]{new class_1293(class_1294.field_5917, 3600)}), "haste");
        public static final class_1842 LONG_HASTE = Apoth.registerPot(new class_1842("haste", new class_1293[]{new class_1293(class_1294.field_5917, 9600)}), "long_haste");
        public static final class_1842 STRONG_HASTE = Apoth.registerPot(new class_1842("haste", new class_1293[]{new class_1293(class_1294.field_5917, 1800, 1)}), "strong_haste");
        public static final class_1842 FATIGUE = Apoth.registerPot(new class_1842("fatigue", new class_1293[]{new class_1293(class_1294.field_5901, 3600)}), "fatigue");
        public static final class_1842 LONG_FATIGUE = Apoth.registerPot(new class_1842("fatigue", new class_1293[]{new class_1293(class_1294.field_5901, 9600)}), "long_fatigue");
        public static final class_1842 STRONG_FATIGUE = Apoth.registerPot(new class_1842("fatigue", new class_1293[]{new class_1293(class_1294.field_5901, 1800, 1)}), "strong_fatigue");
        public static final class_1842 WITHER = Apoth.registerPot(new class_1842("wither", new class_1293[]{new class_1293(class_1294.field_5920, 3600)}), "wither");
        public static final class_1842 LONG_WITHER = Apoth.registerPot(new class_1842("wither", new class_1293[]{new class_1293(class_1294.field_5920, 9600)}), "long_wither");
        public static final class_1842 STRONG_WITHER = Apoth.registerPot(new class_1842("wither", new class_1293[]{new class_1293(class_1294.field_5920, 1800, 1)}), "strong_wither");
        public static final class_1842 SUNDERING = Apoth.registerPot(new class_1842("sundering", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.SUNDERING, 3600)}), "sundering");
        public static final class_1842 LONG_SUNDERING = Apoth.registerPot(new class_1842("sundering", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.SUNDERING, 9600)}), "long_sundering");
        public static final class_1842 STRONG_SUNDERING = Apoth.registerPot(new class_1842("sundering", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.SUNDERING, 1800, 1)}), "strong_sundering");
        public static final class_1842 KNOWLEDGE = Apoth.registerPot(new class_1842("knowledge", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.KNOWLEDGE, 2400)}), "knowledge");
        public static final class_1842 LONG_KNOWLEDGE = Apoth.registerPot(new class_1842("knowledge", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.KNOWLEDGE, 4800)}), "long_knowledge");
        public static final class_1842 STRONG_KNOWLEDGE = Apoth.registerPot(new class_1842("knowledge", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.KNOWLEDGE, 1200, 1)}), "strong_knowledge");
        public static final class_1842 VITALITY = Apoth.registerPot(new class_1842("vitality", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.VITALITY, 4800)}), "vitality");
        public static final class_1842 LONG_VITALITY = Apoth.registerPot(new class_1842("vitality", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.VITALITY, 14400)}), "long_vitality");
        public static final class_1842 STRONG_VITALITY = Apoth.registerPot(new class_1842("vitality", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.VITALITY, 3600, 1)}), "strong_vitality");
        public static final class_1842 GRIEVOUS = Apoth.registerPot(new class_1842("grievous", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.GRIEVOUS, 4800)}), "grievous");
        public static final class_1842 LONG_GRIEVOUS = Apoth.registerPot(new class_1842("grievous", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.GRIEVOUS, 14400)}), "long_grievous");
        public static final class_1842 STRONG_GRIEVOUS = Apoth.registerPot(new class_1842("grievous", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.GRIEVOUS, 3600, 1)}), "strong_grievous");
        public static final class_1842 LEVITATION = Apoth.registerPot(new class_1842("levitation", new class_1293[]{new class_1293(class_1294.field_5902, 2400)}), "levitation");
        public static final class_1842 FLYING = Apoth.registerPot(new class_1842("flying", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.FLYING, 9600)}), "flying");
        public static final class_1842 LONG_FLYING = Apoth.registerPot(new class_1842("flying", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.FLYING, 18000)}), "long_flying");
        public static final class_1842 EXTRA_LONG_FLYING = Apoth.registerPot(new class_1842("flying", new class_1293[]{new class_1293((class_1291)ALObjects.MobEffects.FLYING, 36000)}), "extra_long_flying");
    }
}

