/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.helper.rendering;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.blocovermelho.ae2emicrafting.client.helper.mapper.EmiStackHelper;
import org.blocovermelho.ae2emicrafting.client.helper.rendering.Rendering;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Result {
    @Nullable
    public List<class_2561> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
        return null;
    }

    public abstract boolean canCraft();

    public void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 draw) {
    }

    public static NotApplicable createNotApplicable() {
        return new NotApplicable();
    }

    public static Success createSuccessful() {
        return new Success();
    }

    public static Error createFailed(class_2561 text) {
        return new Error(text, Set.of());
    }

    public static Error createFailed(class_2561 text, Set<Integer> missingSlots) {
        return new Error(text, missingSlots);
    }

    static final class NotApplicable
    extends Result {
        NotApplicable() {
        }

        @Override
        public boolean canCraft() {
            return false;
        }
    }

    public static final class Success
    extends Result {
        @Override
        public boolean canCraft() {
            return true;
        }
    }

    static final class Error
    extends Result {
        private final class_2561 message;
        private final Set<Integer> missingSlots;

        public Error(class_2561 message, Set<Integer> missingSlots) {
            this.message = message;
            this.missingSlots = missingSlots;
        }

        public class_2561 getMessage() {
            return this.message;
        }

        @Override
        public boolean canCraft() {
            return false;
        }

        @Override
        public void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
            Rendering.renderMissingAndCraftableSlotOverlays(widgets, guiGraphics, this.missingSlots, Set.of());
        }

        @Override
        public List<class_2561> getTooltip(EmiRecipe emiRecipe, EmiCraftContext<?> context) {
            return List.of(this.getMessage());
        }
    }

    public static final class EncodeWithCraftables
    extends Result {
        private final Set<AEKey> craftableKeys;

        public EncodeWithCraftables(Set<AEKey> craftableKeys) {
            this.craftableKeys = craftableKeys;
        }

        @Override
        public boolean canCraft() {
            return true;
        }

        @Override
        public List<class_2561> getTooltip(EmiRecipe emiRecipe, EmiCraftContext<?> context) {
            boolean anyCraftable = emiRecipe.getInputs().stream().anyMatch(ing -> EncodeWithCraftables.isCraftable(this.craftableKeys, ing));
            if (anyCraftable) {
                return TransferHelper.createEncodingTooltip((boolean)true);
            }
            return null;
        }

        @Override
        public void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
            for (Widget widget : widgets) {
                SlotWidget slot;
                if (!(widget instanceof SlotWidget) || !Rendering.isInputSlot(slot = (SlotWidget)widget) || !EncodeWithCraftables.isCraftable(this.craftableKeys, slot.getStack())) continue;
                class_4587 poseStack = guiGraphics.method_51448();
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, 400.0f);
                Bounds bounds = Rendering.getInnerBounds(slot);
                guiGraphics.method_25294(bounds.x(), bounds.y(), bounds.right(), bounds.bottom(), 0x400000FF);
                poseStack.method_22909();
            }
        }

        private static boolean isCraftable(Set<AEKey> craftableKeys, EmiIngredient ingredient) {
            return ingredient.getEmiStacks().stream().anyMatch(emiIngredient -> {
                GenericStack stack = EmiStackHelper.toGenericStack(emiIngredient);
                return stack != null && craftableKeys.contains(stack.what());
            });
        }
    }

    public static final class PartiallyCraftable
    extends Result {
        private final CraftingTermMenu.MissingIngredientSlots missingSlots;

        public PartiallyCraftable(CraftingTermMenu.MissingIngredientSlots missingSlots) {
            this.missingSlots = missingSlots;
        }

        @Override
        public boolean canCraft() {
            return true;
        }

        @Override
        public List<class_2561> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
            return TransferHelper.createCraftingTooltip((CraftingTermMenu.MissingIngredientSlots)this.missingSlots, (boolean)false);
        }

        @Override
        public void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
            Rendering.renderMissingAndCraftableSlotOverlays(widgets, guiGraphics, this.missingSlots.missingSlots(), this.missingSlots.craftableSlots());
        }
    }
}

