/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class DetachedDrawerData
implements IDrawer {
    private class_1799 protoStack;
    private int count;
    private int storageMult;
    private boolean heavy;

    public DetachedDrawerData() {
        this.protoStack = class_1799.field_8037;
        this.count = 0;
        this.storageMult = 1;
        this.heavy = false;
    }

    public DetachedDrawerData(IDrawer sourceDrawer) {
        this(sourceDrawer, 1);
    }

    public DetachedDrawerData(IDrawer sourceDrawer, int storageMult) {
        this.protoStack = sourceDrawer.getStoredItemPrototype();
        this.count = sourceDrawer.getStoredItemCount();
        this.storageMult = storageMult;
    }

    public DetachedDrawerData(class_2487 serializedTag) {
        this.deserializeNBT(serializedTag);
    }

    public int getStorageMultiplier() {
        return this.storageMult;
    }

    public void setStorageMultiplier(int storageMult) {
        this.storageMult = storageMult;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setIsHeavy(boolean state) {
        this.heavy = state;
    }

    @Override
    @NotNull
    public class_1799 getStoredItemPrototype() {
        return this.protoStack;
    }

    @Override
    @NotNull
    public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
        return this;
    }

    protected IDrawer setStoredItemRaw(@NotNull class_1799 itemPrototype) {
        this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
        this.protoStack.method_7939(1);
        this.count = 0;
        return this;
    }

    @Override
    public int getStoredItemCount() {
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
    }

    protected void setStoredItemCountRaw(int amount) {
        this.count = amount;
    }

    @Override
    public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getRemainingCapacity() {
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
        return false;
    }

    @Override
    public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack.method_7960();
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.storageMult > 1) {
            tag.method_10569("StorageMult", this.storageMult);
        }
        if (this.protoStack.method_7960()) {
            return tag;
        }
        class_2487 item = new class_2487();
        this.protoStack.method_7953(item);
        tag.method_10566("Item", (class_2520)item);
        tag.method_10569("Count", this.count);
        if (this.heavy) {
            tag.method_10556("Heavy", true);
        }
        return tag;
    }

    public void deserializeNBT(class_2487 nbt) {
        class_1799 tagItem = class_1799.field_8037;
        int tagCount = 0;
        if (nbt == null) {
            return;
        }
        if (nbt.method_10545("Item")) {
            tagItem = class_1799.method_7915((class_2487)nbt.method_10562("Item"));
        }
        if (nbt.method_10545("Count")) {
            tagCount = nbt.method_10550("Count");
        }
        this.storageMult = nbt.method_10545("StorageMult") ? nbt.method_10550("StorageMult") : (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * 8;
        if (nbt.method_10545("Heavy")) {
            this.setIsHeavy(nbt.method_10577("Heavy"));
        }
        this.setStoredItemRaw(tagItem);
        this.setStoredItemCountRaw(tagCount);
    }
}

