/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public class DrawerItemRepository
implements IItemRepository {
    protected IDrawerGroup group;

    public DrawerItemRepository(IDrawerGroup group) {
        this.group = group;
    }

    @Override
    @NotNull
    public class_2371<IItemRepository.ItemRecord> getAllItems() {
        class_2371 records = class_2371.method_10211();
        if (this.group == null) {
            return records;
        }
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs != null && attrs.isSuspended()) {
            return records;
        }
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (drawer.isEmpty()) continue;
            class_1799 stack = drawer.getStoredItemPrototype();
            records.add((Object)new IItemRepository.ItemRecord(stack, drawer.getStoredItemCount()));
        }
        return records;
    }

    @Override
    @NotNull
    public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate, Predicate<class_1799> predicate) {
        boolean empty;
        IDrawer drawer;
        int amount = stack.method_7947();
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (attrs.isSuspended()) {
            return this.stackResult(stack, amount);
        }
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate)) continue;
            empty = drawer.isEmpty();
            if (empty && !simulate) {
                drawer = drawer.setStoredItem(stack);
            }
            int capacity = empty ? drawer.getMaxCapacity(stack) : drawer.getRemainingCapacity();
            int adjusted = Math.min(amount, capacity);
            int n = amount = simulate ? Math.max(amount - capacity, 0) : amount - adjusted + drawer.adjustStoredItemCount(adjusted);
            if (amount == 0) break;
        }
        if (amount > 0) {
            for (int slot : this.group.getAccessibleDrawerSlots()) {
                drawer = this.group.getDrawer(slot);
                if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate)) continue;
                empty = drawer.isEmpty();
                if (empty && !simulate) {
                    drawer = drawer.setStoredItem(stack);
                }
                int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
                if (amount == 0) break;
            }
        }
        if (!simulate && attrs.isBalancedFill() && !attrs.isUnlimitedVending()) {
            StorageUtil.rebalanceDrawers(this.group, stack);
        }
        return amount == 0 ? class_1799.field_8037 : this.stackResult(stack, amount);
    }

    @Override
    @NotNull
    public class_1799 extractItem(@NotNull class_1799 stack, int amount, boolean simulate, Predicate<class_1799> predicate) {
        int remaining = amount;
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (attrs.isSuspended()) {
            return class_1799.field_8037;
        }
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate)) continue;
            int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
            if (remaining == 0) break;
        }
        if (!simulate && attrs.isBalancedFill() && !attrs.isUnlimitedVending()) {
            StorageUtil.rebalanceDrawers(this.group, stack);
        }
        return amount == remaining ? class_1799.field_8037 : this.stackResult(stack, amount - remaining);
    }

    @Override
    public int getStoredItemCount(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        if (this.isSuspended()) {
            return 0;
        }
        long count = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (count += (long)drawer.getStoredItemCount()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    @Override
    public int getRemainingItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        if (this.isSuspended()) {
            return 0;
        }
        long remainder = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (remainder += (long)drawer.getRemainingCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)remainder;
    }

    @Override
    public int getItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        if (this.isSuspended()) {
            return 0;
        }
        long capacity = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (capacity += (long)drawer.getMaxCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    protected boolean testPredicateInsert(IDrawer drawer, @NotNull class_1799 stack, Predicate<class_1799> predicate) {
        if (predicate instanceof IItemRepository.DefaultPredicate) {
            return drawer.canItemBeStored(stack) || predicate.test(drawer.getStoredItemPrototype());
        }
        return drawer.canItemBeStored(stack, predicate);
    }

    protected boolean testPredicateExtract(IDrawer drawer, @NotNull class_1799 stack, Predicate<class_1799> predicate) {
        if (predicate instanceof IItemRepository.DefaultPredicate) {
            return drawer.canItemBeExtracted(stack) || predicate.test(drawer.getStoredItemPrototype());
        }
        return drawer.canItemBeStored(stack, predicate);
    }

    protected class_1799 stackResult(@NotNull class_1799 stack, int amount) {
        class_1799 result = stack.method_7972();
        result.method_7939(amount);
        return result;
    }

    protected boolean isSuspended() {
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        return attrs.isSuspended();
    }
}

