/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class DrawerOverlay {
    public boolean showContent = true;
    public boolean showStackLimit = true;
    public boolean showStatus = true;
    public boolean showStackRemainder;
    public boolean respectQuantifyKey;

    public DrawerOverlay() {
        this.showStackRemainder = (Boolean)ModCommonConfig.INSTANCE.INTEGRATION.waila.stackRemainder.get();
        this.respectQuantifyKey = (Boolean)ModCommonConfig.INSTANCE.INTEGRATION.waila.respectQuantifyKey.get();
    }

    public List<class_2561> getOverlay(BlockEntityDrawers tile) {
        return this.getOverlay(tile, false);
    }

    public List<class_2561> getOverlay(BlockEntityDrawers tile, boolean includeContent) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        IDrawerAttributes attr = tile.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attr == null) {
            attr = EmptyDrawerAttributes.EMPTY;
        }
        if (includeContent) {
            this.addContent(result, tile, attr);
        }
        this.addStackLimit(result, tile, attr);
        this.addStatus(result, tile, attr);
        return result;
    }

    private void addContent(List<class_2561> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showContent || attr.isConcealed()) {
            return;
        }
        boolean showCounts = !this.respectQuantifyKey || attr.isShowingQuantity();
        IDrawerGroup group = tile.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            class_5250 name = class_2561.method_43471((String)"tooltip.storagedrawers.waila.empty");
            class_1799 stack = drawer.getStoredItemPrototype();
            if (!stack.method_7960()) {
                class_5250 stackName = class_2561.method_43471((String)"").method_10852(stack.method_7954());
                if (showCounts) {
                    if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                        name = stackName.method_27693("[\u221e]");
                    } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                        String text = (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                        name = stackName.method_27693(text);
                    } else if (this.showStackRemainder) {
                        int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                        int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                        name = stacks > 0 && remainder > 0 ? stackName.method_27693(" [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]") : (stacks > 0 ? stackName.method_27693(" [" + stacks + "x" + drawer.getStoredItemStackSize() + "]") : stackName.method_27693(" [" + remainder + "]"));
                    } else {
                        name = stackName.method_27693(" [" + drawer.getStoredItemCount() + "]");
                    }
                } else {
                    name = stackName;
                }
            }
            result.add((class_2561)class_2561.method_43469((String)"tooltip.storagedrawers.waila.drawer", (Object[])new Object[]{i + 1, name}));
        }
    }

    private void addStackLimit(List<class_2561> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStackLimit) {
            return;
        }
        if (attr.isUnlimitedStorage() || tile.getDrawerAttributes().isUnlimitedVending()) {
            result.add((class_2561)class_2561.method_43471((String)"tooltip.storagedrawers.waila.nolimit"));
        } else {
            int multiplier = tile.upgrades().getStorageMultiplier();
            int limit = tile.getEffectiveDrawerCapacity();
            try {
                limit = Math.multiplyExact(limit, multiplier);
            }
            catch (ArithmeticException e) {
                limit = 0x1FFFFFF;
            }
            result.add((class_2561)class_2561.method_43469((String)"tooltip.storagedrawers.waila.limit", (Object[])new Object[]{limit, multiplier}));
        }
    }

    private void addStatus(List<class_2561> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStatus) {
            return;
        }
        ArrayList<class_5250> attribs = new ArrayList<class_5250>();
        if (attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.locked"));
        }
        if (attr.isVoid()) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.void"));
        }
        if (attr.isBalancedFill()) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.balanced"));
        }
        if (tile.getOwner() != null) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.protected"));
        }
        if (attr.isMagnet()) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.magnetic"));
        }
        if (attr.isSuspended()) {
            attribs.add(class_2561.method_43471((String)"tooltip.storagedrawers.waila.suspended"));
        }
        if (!attribs.isEmpty()) {
            result.add((class_2561)attribs.stream().reduce((a, b) -> a.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)b)).get());
        }
    }
}

