/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.BlockStateBlockItem;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.fabric.CRCreativeModeTabsImpl;
import com.railwayteam.railways.registry.fabric.CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class CRCreativeModeTabs {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_1761> getBaseTabKey() {
        return CRCreativeModeTabsImpl.getBaseTabKey();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_1761> getTracksTabKey() {
        return CRCreativeModeTabsImpl.getTracksTabKey();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_1761> getPalettesTabKey() {
        return CRCreativeModeTabsImpl.getPalettesTabKey();
    }

    public static void register() {
    }

    public record TabInfo(class_5321<class_1761> key, class_1761 tab) {
    }

    public static final class RegistrateDisplayItemsGenerator
    implements class_1761.class_7914 {
        private final Tabs tab;
        private static final class_1767[] COLOR_ORDER = new class_1767[]{class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7951, class_1767.field_7955, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954, class_1767.field_7957, class_1767.field_7963, class_1767.field_7944, class_1767.field_7967, class_1767.field_7952};

        public RegistrateDisplayItemsGenerator(Tabs tab) {
            this.tab = tab;
        }

        private static Predicate<class_1792> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of();
            for (ItemProviderEntry entry : simpleExclusions) {
                exclusions.add(entry.method_8389());
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeExclusionPredicate$0((Set)exclusions, arg_0);
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemProviderEntry, ItemProviderEntry> simpleBeforeOrderings = Map.of();
            Map<BlockEntry<TrackBlock>, BlockEntry<TrackBlock>> simpleAfterOrderings = Map.of(CRBlocks.CONDUCTOR_WHISTLE_FLAG, (ItemProviderEntry)CRItems.ITEM_CONDUCTOR_CAP.get(class_1767.field_7964), CRItems.REMOTE_LENS, CRBlocks.CONDUCTOR_WHISTLE_FLAG, CRBlocks.CONDUCTOR_VENT, CRItems.REMOTE_LENS, CRBlocks.MANGROVE_TRACK, CRBlocks.SPRUCE_TRACK, CRBlocks.CRIMSON_TRACK, CRBlocks.WARPED_TRACK);
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$1((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$2((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<class_1792, class_1799> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$3((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0);
        }

        private static Function<class_1792, class_1761.class_7705> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, class_1761.class_7705> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$5((Map)visibilities, arg_0, arg_1));
            for (ItemEntry<ConductorCapItem> entry : CRItems.ITEM_CONDUCTOR_CAP.values()) {
                ConductorCapItem item = (ConductorCapItem)((Object)entry.get());
                if (item.color == class_1767.field_7964) continue;
                visibilities.put(item, class_1761.class_7705.field_40193);
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0);
        }

        public void accept(class_1761.class_8128 pParameters, class_1761.class_7704 output) {
            Predicate<class_1792> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<class_1792, class_1799> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<class_1792, class_1761.class_7705> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            class_5321<class_1761> tab = this.tab.getKey();
            LinkedList<class_1792> items = new LinkedList<class_1792>();
            Predicate is3d = (Predicate)Env.unsafeRunForDist(() -> () -> item -> class_310.method_1551().method_1480().method_4019(new class_1799((class_1935)item), null, null, 0).method_4712(), () -> () -> item -> false);
            items.addAll(this.collectItems(tab, is3d, true, exclusionPredicate));
            items.addAll(this.collectBlocks(tab, exclusionPredicate));
            items.addAll(this.collectItems(tab, is3d, false, exclusionPredicate));
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<class_1792> collectBlocks(class_5321<class_1761> tab, Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Railways.registrate().getAll(class_7924.field_41254)) {
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, tab)) continue;
                if (entry.get() instanceof BlockStateBlockItemGroup.GroupedBlock) {
                    BlockStateBlockItemGroup<?, ?> group = BlockStateBlockItemGroup.get(entry.getId());
                    for (ItemEntry<BlockStateBlockItem<?>> itemEntry : group.getItems()) {
                        class_1792 item = ((class_1792)itemEntry.get()).method_8389();
                        if (item == class_1802.field_8162 || exclusionPredicate.test(item)) continue;
                        items.add(item);
                    }
                    continue;
                }
                class_1792 item = ((class_2248)entry.get()).method_8389();
                if (item == class_1802.field_8162 || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<class_1792> collectItems(class_5321<class_1761> tab, Predicate<class_1792> is3d, boolean special, Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Railways.registrate().getAll(class_7924.field_41197)) {
                class_1792 item;
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, tab) || (item = (class_1792)entry.get()) instanceof class_1747 || is3d.test(item) != special || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        /*
         * WARNING - void declaration
         */
        @ExpectPlatform
        @ExpectPlatform.Transformed
        private static boolean isInCreativeTab(RegistryEntry<?> entry, class_5321<class_1761> tab) {
            void var1_1;
            return CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(entry, (class_5321<class_1761>)var1_1);
        }

        private static void applyOrderings(List<class_1792> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                class_1792 item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(class_1761.class_7704 output, List<class_1792> items, Function<class_1792, class_1799> stackFunc, Function<class_1792, class_1761.class_7705> visibilityFunc) {
            for (class_1792 item : items) {
                output.method_45417(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ class_1761.class_7705 lambda$makeVisibilityFunc$6(Map visibilities, class_1792 item) {
            class_1761.class_7705 visibility = (class_1761.class_7705)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return class_1761.class_7705.field_40191;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$5(Map visibilities, ItemProviderEntry entry, class_1761.class_7705 factory) {
            visibilities.put(entry.method_8389(), factory);
        }

        private static /* synthetic */ class_1799 lambda$makeStackFunc$4(Map factories, class_1792 item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (class_1799)factory.apply(item);
            }
            return new class_1799((class_1935)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$3(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.method_8389(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$2(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.method_8389(), otherEntry.method_8389()));
        }

        private static /* synthetic */ void lambda$makeOrderings$1(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.method_8389(), otherEntry.method_8389()));
        }

        private static /* synthetic */ boolean lambda$makeExclusionPredicate$0(Set exclusions, class_1792 item) {
            return exclusions.contains(item) || item instanceof SequencedAssemblyItem;
        }

        private record ItemOrdering(class_1792 item, class_1792 anchor, Type type) {
            public static ItemOrdering before(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }

    public static enum Tabs {
        MAIN(CRCreativeModeTabs::getBaseTabKey),
        TRACK(CRCreativeModeTabs::getTracksTabKey),
        PALETTES(CRCreativeModeTabs::getPalettesTabKey);

        private final Supplier<class_5321<class_1761>> keySupplier;

        private Tabs(Supplier<class_5321<class_1761>> keySupplier) {
            this.keySupplier = keySupplier;
        }

        public class_5321<class_1761> getKey() {
            return this.keySupplier.get();
        }
    }
}

