/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T>
implements Iterable<RegistrySupplier<T>> {
    private final java.util.function.Supplier<RegistrarManager> registriesSupplier;
    private final class_5321<class_2378<T>> key;
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
    private final List<RegistrySupplier<T>> entryView = Collections.unmodifiableList(this.entries);
    private boolean registered = false;
    @Nullable
    private String modId;

    private DeferredRegister(java.util.function.Supplier<RegistrarManager> registriesSupplier, class_5321<class_2378<T>> key, @Nullable String modId) {
        this.registriesSupplier = Objects.requireNonNull(registriesSupplier);
        this.key = Objects.requireNonNull(key);
        this.modId = modId;
    }

    public static <T> DeferredRegister<T> create(String modId, class_5321<class_2378<T>> key) {
        Supplier value = Suppliers.memoize(() -> RegistrarManager.get(modId));
        return new DeferredRegister<T>((java.util.function.Supplier<RegistrarManager>)value, key, Objects.requireNonNull(modId));
    }

    public <R extends T> RegistrySupplier<R> register(String id, java.util.function.Supplier<? extends R> supplier) {
        if (this.modId == null) {
            throw new NullPointerException("You must create the deferred register with a mod id to register entries without the namespace!");
        }
        return this.register(new class_2960(this.modId, id), supplier);
    }

    public <R extends T> RegistrySupplier<R> register(class_2960 id, java.util.function.Supplier<? extends R> supplier) {
        Entry<? extends R> entry = new Entry<R>(id, supplier);
        this.entries.add(entry);
        if (this.registered) {
            Registrar<T> registrar = this.getRegistrar();
            entry.value = registrar.register(entry.id, entry.supplier);
        }
        return entry;
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Cannot register a deferred register twice!");
        }
        this.registered = true;
        Registrar<T> registrar = this.getRegistrar();
        for (Entry<T> entry : this.entries) {
            entry.value = registrar.register(entry.id, entry.supplier);
        }
    }

    @Override
    public Iterator<RegistrySupplier<T>> iterator() {
        return this.entryView.iterator();
    }

    public RegistrarManager getRegistrarManager() {
        return this.registriesSupplier.get();
    }

    public Registrar<T> getRegistrar() {
        return this.registriesSupplier.get().get(this.key);
    }

    private class Entry<R>
    implements RegistrySupplier<R> {
        private final class_2960 id;
        private final java.util.function.Supplier<R> supplier;
        private RegistrySupplier<R> value;

        public Entry(class_2960 id, java.util.function.Supplier<R> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        @Override
        public RegistrarManager getRegistrarManager() {
            return DeferredRegister.this.getRegistrarManager();
        }

        @Override
        public Registrar<R> getRegistrar() {
            return DeferredRegister.this.getRegistrar();
        }

        @Override
        public class_2960 getRegistryId() {
            return DeferredRegister.this.key.method_29177();
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        public boolean isPresent() {
            return this.value != null && this.value.isPresent();
        }

        @Override
        public R get() {
            if (this.isPresent()) {
                return (R)this.value.get();
            }
            throw new NullPointerException("Registry Object not present: " + this.id);
        }

        public int hashCode() {
            return Objects.hash(this.getRegistryId(), this.getId());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegistrySupplier)) {
                return false;
            }
            RegistrySupplier other = (RegistrySupplier)obj;
            return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
        }

        public String toString() {
            return this.getRegistryId().toString() + "@" + this.id.toString();
        }
    }
}

