/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class BaseCachingPredicates
implements CachingPredicates {
    @Nullable
    protected Set<class_2960> spriteIdSet;
    @Nullable
    protected Predicate<class_2680> blockStatePredicate;
    protected boolean isValidForMultipass;

    public BaseCachingPredicates(@Nullable Set<class_2960> spriteIdSet, @Nullable Predicate<class_2680> blockStatePredicate, boolean isValidForMultipass) {
        this.spriteIdSet = spriteIdSet;
        this.blockStatePredicate = blockStatePredicate;
        this.isValidForMultipass = isValidForMultipass;
    }

    @Override
    public boolean affectsSprites() {
        return this.spriteIdSet != null;
    }

    @Override
    public boolean affectsSprite(class_1058 sprite) {
        if (this.spriteIdSet != null) {
            return this.spriteIdSet.contains(sprite.method_45851().method_45816());
        }
        return false;
    }

    @Override
    public boolean affectsBlockStates() {
        return this.blockStatePredicate != null;
    }

    @Override
    public boolean affectsBlockState(class_2680 state) {
        if (this.blockStatePredicate != null) {
            return this.blockStatePredicate.test(state);
        }
        return false;
    }

    @Override
    public boolean isValidForMultipass() {
        return this.isValidForMultipass;
    }

    public static class Factory<T extends BaseCtmProperties>
    implements CachingPredicates.Factory<T> {
        protected boolean isValidForMultipass;

        public Factory(boolean isValidForMultipass) {
            this.isValidForMultipass = isValidForMultipass;
        }

        @Override
        public CachingPredicates createPredicates(T properties, Function<class_4730, class_1058> textureGetter) {
            return new BaseCachingPredicates(((BaseCtmProperties)properties).getMatchTilesSet(), ((BaseCtmProperties)properties).getMatchBlocksPredicate(), this.isValidForMultipass);
        }
    }
}

