/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends FilterUpgradeBase<MagnetUpgrade, MagnetFilterSettings>
implements IEnable,
ITickableUpgrade {
    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 103), TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount, filter, filterTags);
    }

    @Override
    public MagnetFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), this.getFilter(), filterTags);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new MagnetWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount;
        if (this.isTagSelector()) {
            slots.add(new FilterSlotItemHandler(this, this.filter, 0, x + 64, y + 23, 1){

                @Override
                public boolean method_7682() {
                    return super.method_7682();
                }

                @Override
                public boolean method_7680(class_1799 pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                }
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slots.add(new FilterSlotItemHandler(this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                        @Override
                        public boolean method_7680(class_1799 pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.tickRate;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void teleportNearbyItems(class_1657 player, class_1937 level) {
        if (level.field_9236) {
            return;
        }
        int radius = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.pullRange;
        class_238 area = new class_238(player.method_19538().method_1031((double)(-radius), (double)(-radius), (double)(-radius)), player.method_19538().method_1031((double)radius, (double)radius, (double)radius));
        List items = level.method_18023((class_5575)class_1299.field_6052, area, item -> !(!item.method_5805() || level.field_9236 && item.field_6012 <= 1 || item.field_7200 != null && item.field_7200.equals(player.method_5667()) && item.field_6012 <= 80 || item.method_6983().method_7960() || !((MagnetFilterSettings)this.getFilterSettings()).matchesFilter(player, item.method_6983())));
        items.forEach(item -> {
            item.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
            item.method_6975();
        });
    }

    @Override
    protected ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                MagnetUpgrade.this.updateDataHolderUnchecked("Inventory", MagnetUpgrade.this.filter);
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(MagnetUpgrade.this.getDataHolderStack(), "Inventory"));
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilterTags((List)NbtHelper.get(MagnetUpgrade.this.getDataHolderStack(), "FilterTags"));
                MagnetUpgrade.this.changeListeners.forEach(Runnable::run);
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

