/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class AutoPickupUpgrade
extends FilterUpgradeBase<AutoPickupUpgrade, AutoPickupFilterSettings>
implements IEnable {
    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 103), TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount, filter, filterTags);
    }

    public boolean canPickup(class_1799 stack) {
        return ((AutoPickupFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public AutoPickupFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), this.getFilter(), filterTags);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
        if (this.isTagSelector()) {
            slots.add(new FilterSlotItemHandler(this, this.filter, 0, x + 64, y + 23, 1){

                @Override
                public boolean method_7682() {
                    return super.method_7682();
                }

                @Override
                public boolean method_7680(class_1799 pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                }
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slots.add(new FilterSlotItemHandler(this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                        @Override
                        public boolean method_7682() {
                            return super.method_7682() && AutoPickupUpgrade.this.getFilter().get(0) != 2;
                        }

                        @Override
                        public boolean method_7680(class_1799 pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    protected ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked("Inventory", AutoPickupUpgrade.this.filter);
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(AutoPickupUpgrade.this.getDataHolderStack(), "Inventory"));
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilterTags((List)NbtHelper.get(AutoPickupUpgrade.this.getDataHolderStack(), "FilterTags"));
                AutoPickupUpgrade.this.changeListeners.forEach(Runnable::run);
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

