/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RenderHelper {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.29000002f;
    private static final float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.29000002f}}, new float[][]{{0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.01f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.01f, 0.29000002f}}};

    public static void renderScreenTank(class_332 guiGraphics, FluidTank tank, double x, double y, double z, double height, double width) {
        RenderHelper.renderScreenTank(guiGraphics, tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, z, height, width);
    }

    public static void renderScreenTank(class_332 guiGraphics, FluidVariantWrapper fluid, long capacity, long amount, double x, double y, double z, double height, double width) {
        if (fluid == null || fluid.fluidVariant().getFluid() == null || amount <= 0L) {
            return;
        }
        class_1058 icon = FluidVariantRendering.getSprite((FluidVariant)fluid.fluidVariant());
        if (icon == null) {
            icon = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid.fluidVariant());
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.disableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.method_4594();
                float minV = icon.method_4593();
                float maxU = icon.method_4577();
                float maxV = icon.method_4575();
                Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
                class_287 builder = class_289.method_1348().method_1349();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                builder.method_22918(matrix4f, (float)drawX, (float)(drawY + drawHeight), (float)z).method_22913(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).method_1344();
                builder.method_22918(matrix4f, (float)(drawX + drawWidth), (float)(drawY + drawHeight), (float)z).method_22913(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).method_1344();
                builder.method_22918(matrix4f, (float)(drawX + drawWidth), (float)drawY, (float)z).method_22913(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).method_1344();
                builder.method_22918(matrix4f, (float)drawX, (float)drawY, (float)z).method_22913(minU, minV).method_1344();
                class_286.method_43433((class_287.class_7433)builder.method_1326());
            }
            i += 16;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_22909();
    }

    public static void renderFluidSides(class_4587 poseStack, class_4597 buffer, float height, FluidVariantWrapper fluid, int brightness) {
        Triple<Float, Float, Float> colorParts = RenderHelper.getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        for (class_2350 direction : class_2350.values()) {
            class_1058 icon = FluidVariantRendering.getSprite((FluidVariant)fluid.fluidVariant());
            class_4588 renderer = buffer.getBuffer(class_1921.method_23028((class_2960)icon.method_45852()));
            float[][] c = coordinates[direction.ordinal()];
            float replacedMaxV = direction == class_2350.field_11036 || direction == class_2350.field_11033 ? icon.method_4570(0.25) : (icon.method_4575() - icon.method_4593()) * height + icon.method_4593();
            float replacedU1 = direction == class_2350.field_11036 || direction == class_2350.field_11033 ? icon.method_4580(0.25) : icon.method_4580(0.4375);
            float replacedU2 = direction == class_2350.field_11036 || direction == class_2350.field_11033 ? icon.method_4580(0.5) : icon.method_4580(0.5);
            renderer.method_22918(matrix4f, c[0][0], RenderHelper.getHeight(c[0][1], height), c[0][2]).method_22915(r, g, b, a).method_22913(replacedU1, replacedMaxV).method_22916(brightness).method_1344();
            renderer.method_22918(matrix4f, c[1][0], RenderHelper.getHeight(c[1][1], height), c[1][2]).method_22915(r, g, b, a).method_22913(replacedU1, icon.method_4593()).method_22916(brightness).method_1344();
            renderer.method_22918(matrix4f, c[2][0], RenderHelper.getHeight(c[2][1], height), c[2][2]).method_22915(r, g, b, a).method_22913(replacedU2, icon.method_4593()).method_22916(brightness).method_1344();
            renderer.method_22918(matrix4f, c[3][0], RenderHelper.getHeight(c[3][1], height), c[3][2]).method_22915(r, g, b, a).method_22913(replacedU2, replacedMaxV).method_22916(brightness).method_1344();
        }
    }

    private static float getHeight(float height, float replaceHeight) {
        if (height == 0.29000002f) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(FluidTank tank, class_4587 poseStack, class_4597 buffer, int combinedLightIn, float x, float y, float z) {
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        if (!tank.isEmpty() && !tank.getFluid().isEmpty()) {
            poseStack.method_46416(x, y, z);
            float height = RenderHelper.getTankFillRatio(tank) * 0.99f;
            RenderHelper.renderFluidSides(poseStack, buffer, height, tank.getFluid(), combinedLightIn);
        }
        poseStack.method_22909();
    }

    public static class_1058 getBlockIcon(class_2248 block) {
        return class_310.method_1551().method_1541().method_3351().method_3339(block.method_9564());
    }

    public static float getTankFillRatio(FluidTank tank) {
        return Math.min(1.0f, (float)tank.getFluidAmount() / (float)tank.getCapacity()) * 0.5f;
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidVariantWrapper fluidStack) {
        int color = FluidVariantRendering.getColor((FluidVariant)fluidStack.fluidVariant());
        return RenderHelper.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

