/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.libs.nightconfig.core.Config;
import me.cominixo.betterf3.libs.nightconfig.core.file.FileConfig;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.ChunksModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.EmptyModule;
import me.cominixo.betterf3.modules.EntityModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.modules.HelpModule;
import me.cominixo.betterf3.modules.SoundModule;
import me.cominixo.betterf3.modules.SystemModule;
import me.cominixo.betterf3.utils.DebugLine;
import net.minecraft.class_5251;

public final class ModConfigFile {
    private static FileType storedFileType;
    public static final Runnable saveRunnable;

    private ModConfigFile() {
    }

    public static void load(FileType filetype) {
        Config general;
        storedFileType = filetype;
        File file = new File(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml");
        if (!file.exists()) {
            return;
        }
        Object config = FileConfig.builder(file).concurrent().autosave().build();
        config.load();
        Config allModulesConfig = config.getOrElse("modules", () -> null);
        if (allModulesConfig != null) {
            for (BaseModule module : BaseModule.allModules) {
                String moduleName = module.id;
                Config moduleConfig = allModulesConfig.getOrElse(moduleName, () -> null);
                if (moduleConfig == null) continue;
                Config lines = moduleConfig.getOrElse("lines", () -> null);
                if (lines != null) {
                    for (Config.Entry entry : lines.entrySet()) {
                        DebugLine line = module.line(entry.getKey());
                        if (line == null) continue;
                        line.enabled = (Boolean)entry.getValue();
                    }
                }
                if (module.defaultNameColor != null) {
                    module.nameColor = class_5251.method_27717((int)moduleConfig.getOrElse("name_color", Integer.valueOf(module.defaultNameColor.method_27716())));
                }
                if (module.defaultValueColor != null) {
                    module.valueColor = class_5251.method_27717((int)moduleConfig.getOrElse("value_color", Integer.valueOf(module.defaultValueColor.method_27716())));
                }
                if (module instanceof CoordsModule) {
                    CoordsModule coordsModule = (CoordsModule)module;
                    if (coordsModule.defaultColorX != null) {
                        coordsModule.colorX = class_5251.method_27717((int)moduleConfig.getOrElse("color_x", Integer.valueOf(coordsModule.defaultColorX.method_27716())));
                    }
                    if (coordsModule.defaultColorY != null) {
                        coordsModule.colorY = class_5251.method_27717((int)moduleConfig.getOrElse("color_y", Integer.valueOf(coordsModule.defaultColorY.method_27716())));
                    }
                    if (coordsModule.defaultColorZ != null) {
                        coordsModule.colorZ = class_5251.method_27717((int)moduleConfig.getOrElse("color_z", Integer.valueOf(coordsModule.defaultColorZ.method_27716())));
                    }
                }
                if (module instanceof SoundModule) {
                    SoundModule soundModule = (SoundModule)module;
                    if (soundModule.defaultMaximumColor != null) {
                        soundModule.maximumColor = class_5251.method_27717((int)moduleConfig.getOrElse("maximum_color", Integer.valueOf(soundModule.defaultMaximumColor.method_27716())));
                    }
                }
                if (module instanceof EntityModule) {
                    EntityModule entityModule = (EntityModule)module;
                    if (entityModule.defaultTotalColor != null) {
                        entityModule.totalColor = class_5251.method_27717((int)moduleConfig.getOrElse("total_entities_color", Integer.valueOf(entityModule.defaultTotalColor.method_27716())));
                    }
                }
                if (module instanceof HelpModule) {
                    HelpModule helpModule = (HelpModule)module;
                    if (helpModule.defaultEnabledColor != null) {
                        helpModule.enabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("enabled_color", Integer.valueOf(helpModule.defaultEnabledColor.method_27716())));
                    }
                    if (helpModule.defaultDisabledColor != null) {
                        helpModule.disabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("disabled_color", Integer.valueOf(helpModule.defaultDisabledColor.method_27716())));
                    }
                }
                if (module instanceof ChunksModule) {
                    ChunksModule chunkModule = (ChunksModule)module;
                    if (chunkModule.defaultEnabledColor != null) {
                        chunkModule.enabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("chunks_enabled_color", Integer.valueOf(chunkModule.defaultEnabledColor.method_27716())));
                    }
                    if (chunkModule.defaultDisabledColor != null) {
                        chunkModule.disabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("chunks_disabled_color", Integer.valueOf(chunkModule.defaultDisabledColor.method_27716())));
                    }
                    if (chunkModule.defaultTotalColor != null) {
                        chunkModule.totalColor = class_5251.method_27717((int)moduleConfig.getOrElse("total_chunks_color", Integer.valueOf(chunkModule.defaultTotalColor.method_27716())));
                    }
                }
                if (module instanceof SystemModule) {
                    SystemModule systemModule = (SystemModule)module;
                    if (systemModule.memoryColorToggle == null) {
                        systemModule.memoryColorToggle = moduleConfig.getOrElse("memory_color_toggle", Boolean.valueOf(systemModule.defaultMemoryColorToggle));
                    }
                    if (systemModule.timeFormat == null) {
                        systemModule.timeFormat = moduleConfig.getOrElse("time_format", systemModule.defaultTimeFormat);
                    }
                }
                module.enabled = moduleConfig.getOrElse("enabled", Boolean.valueOf(true));
            }
        } else {
            List modulesRightConfig;
            ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
            ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
            List modulesLeftConfig = config.getOrElse("modules_left", () -> null);
            if (modulesLeftConfig != null) {
                for (Object moduleConfig : modulesLeftConfig) {
                    String moduleName = (String)moduleConfig.getOrElse("name", null);
                    if (moduleName == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule((Config)moduleConfig);
                    modulesLeft.add(baseModule);
                }
            }
            if ((modulesRightConfig = config.getOrElse("modules_right", () -> null)) != null) {
                for (Config moduleConfig : modulesRightConfig) {
                    String string = moduleConfig.getOrElse("name", () -> null);
                    if (string == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule(moduleConfig);
                    modulesRight.add(baseModule);
                }
            }
            if (!modulesLeft.isEmpty() || !modulesRight.isEmpty()) {
                BaseModule.modules = modulesLeft;
                BaseModule.modulesRight = modulesRight;
            }
        }
        if ((general = config.getOrElse("general", () -> null)) != null) {
            if (allModulesConfig != null) {
                BaseModule baseModule;
                ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
                ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
                for (Object s : general.getOrElse("modules_left_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesLeft.add(baseModule);
                }
                if (!modulesLeft.isEmpty()) {
                    BaseModule.modules = modulesLeft;
                }
                for (Object s : general.getOrElse("modules_right_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesRight.add(baseModule);
                }
                if (!modulesRight.isEmpty()) {
                    BaseModule.modulesRight = modulesRight;
                }
            }
            GeneralOptions.disableMod = general.getOrElse("disable_mod", Boolean.valueOf(false));
            GeneralOptions.autoF3 = general.getOrElse("auto_start", Boolean.valueOf(false));
            GeneralOptions.spaceEveryModule = general.getOrElse("space_modules", Boolean.valueOf(false));
            GeneralOptions.shadowText = general.getOrElse("shadow_text", Boolean.valueOf(true));
            GeneralOptions.enableAnimations = general.getOrElse("animations", Boolean.valueOf(true));
            GeneralOptions.animationSpeed = general.getOrElse("animationSpeed", Double.valueOf(1.0));
            GeneralOptions.fontScale = general.getOrElse("fontScale", Double.valueOf(1.0));
            GeneralOptions.backgroundColor = general.getOrElse("background_color", Integer.valueOf(1867534416));
            GeneralOptions.hideDebugCrosshair = general.getOrElse("hide_debug_crosshair", Boolean.valueOf(false));
            GeneralOptions.hideSidebar = general.getOrElse("hide_sidebar", Boolean.valueOf(true));
            GeneralOptions.hideBossbar = general.getOrElse("hide_bossbar", Boolean.valueOf(true));
            GeneralOptions.alwaysEnableProfiler = general.getOrElse("always_show_profiler", Boolean.valueOf(false));
            GeneralOptions.alwaysEnableTPS = general.getOrElse("always_show_tps", Boolean.valueOf(false));
        }
        config.close();
    }

    private static BaseModule loadModule(Config moduleConfig) {
        BaseModule baseModule;
        String moduleName = (String)moduleConfig.getOrElse("name", null);
        try {
            baseModule = (BaseModule)BaseModule.moduleById(moduleName).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            baseModule = new EmptyModule(false);
        }
        Config lines = moduleConfig.getOrElse("lines", () -> null);
        if (lines != null) {
            for (Config.Entry entry : lines.entrySet()) {
                DebugLine line = baseModule.line(entry.getKey());
                if (line == null) continue;
                line.enabled = (Boolean)entry.getValue();
            }
        }
        if (baseModule.defaultNameColor != null) {
            baseModule.nameColor = class_5251.method_27717((int)moduleConfig.getOrElse("name_color", Integer.valueOf(baseModule.defaultNameColor.method_27716())));
        }
        if (baseModule.defaultValueColor != null) {
            baseModule.valueColor = class_5251.method_27717((int)moduleConfig.getOrElse("value_color", Integer.valueOf(baseModule.defaultValueColor.method_27716())));
        }
        if (baseModule instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)baseModule;
            if (coordsModule.defaultColorX != null) {
                coordsModule.colorX = class_5251.method_27717((int)moduleConfig.getOrElse("color_x", Integer.valueOf(coordsModule.defaultColorX.method_27716())));
            }
            if (coordsModule.defaultColorY != null) {
                coordsModule.colorY = class_5251.method_27717((int)moduleConfig.getOrElse("color_y", Integer.valueOf(coordsModule.defaultColorY.method_27716())));
            }
            if (coordsModule.defaultColorZ != null) {
                coordsModule.colorZ = class_5251.method_27717((int)moduleConfig.getOrElse("color_z", Integer.valueOf(coordsModule.defaultColorZ.method_27716())));
            }
        }
        if (baseModule instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)baseModule;
            if (fpsModule.defaultColorHigh != null) {
                fpsModule.colorHigh = class_5251.method_27717((int)moduleConfig.getOrElse("color_high", Integer.valueOf(fpsModule.defaultColorHigh.method_27716())));
            }
            if (fpsModule.defaultColorMed != null) {
                fpsModule.colorMed = class_5251.method_27717((int)moduleConfig.getOrElse("color_med", Integer.valueOf(fpsModule.defaultColorMed.method_27716())));
            }
            if (fpsModule.defaultColorLow != null) {
                fpsModule.colorLow = class_5251.method_27717((int)moduleConfig.getOrElse("color_low", Integer.valueOf(fpsModule.defaultColorLow.method_27716())));
            }
        }
        if (baseModule instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)baseModule;
            emptyModule.emptyLines = moduleConfig.getOrElse("empty_lines", Integer.valueOf(1));
        }
        if (baseModule instanceof SoundModule) {
            SoundModule soundModule = (SoundModule)baseModule;
            if (soundModule.defaultMaximumColor != null) {
                soundModule.maximumColor = class_5251.method_27717((int)moduleConfig.getOrElse("maximum_color", Integer.valueOf(soundModule.defaultMaximumColor.method_27716())));
            }
        }
        if (baseModule instanceof EntityModule) {
            EntityModule entityModule = (EntityModule)baseModule;
            if (entityModule.defaultTotalColor != null) {
                entityModule.totalColor = class_5251.method_27717((int)moduleConfig.getOrElse("total_entities_color", Integer.valueOf(entityModule.defaultTotalColor.method_27716())));
            }
        }
        if (baseModule instanceof HelpModule) {
            HelpModule helpModule = (HelpModule)baseModule;
            if (helpModule.defaultEnabledColor != null) {
                helpModule.enabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("enabled_color", Integer.valueOf(helpModule.defaultEnabledColor.method_27716())));
            }
            if (helpModule.defaultDisabledColor != null) {
                helpModule.disabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("disabled_color", Integer.valueOf(helpModule.defaultDisabledColor.method_27716())));
            }
        }
        if (baseModule instanceof ChunksModule) {
            ChunksModule chunkModule = (ChunksModule)baseModule;
            if (chunkModule.defaultEnabledColor != null) {
                chunkModule.enabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("chunks_enabled_color", Integer.valueOf(chunkModule.defaultEnabledColor.method_27716())));
            }
            if (chunkModule.defaultDisabledColor != null) {
                chunkModule.disabledColor = class_5251.method_27717((int)moduleConfig.getOrElse("chunks_disabled_color", Integer.valueOf(chunkModule.defaultDisabledColor.method_27716())));
            }
            if (chunkModule.defaultTotalColor != null) {
                chunkModule.totalColor = class_5251.method_27717((int)moduleConfig.getOrElse("total_chunks_color", Integer.valueOf(chunkModule.defaultTotalColor.method_27716())));
            }
        }
        if (baseModule instanceof SystemModule) {
            SystemModule systemModule = (SystemModule)baseModule;
            systemModule.memoryColorToggle = moduleConfig.getOrElse("memory_color_toggle", Boolean.valueOf(systemModule.defaultMemoryColorToggle));
            systemModule.timeFormat = moduleConfig.getOrElse("time_format", systemModule.defaultTimeFormat);
        }
        baseModule.enabled = moduleConfig.getOrElse("enabled", Boolean.valueOf(true));
        return baseModule;
    }

    private static Config saveModule(BaseModule module) {
        Config moduleConfig = Config.inMemory();
        Config lines = Config.inMemory();
        for (DebugLine line : module.lines()) {
            String lineId = line.id();
            lines.set(lineId, (Object)line.enabled);
        }
        moduleConfig.set("name", (Object)module.id);
        if (module.nameColor != null) {
            moduleConfig.set("name_color", (Object)module.nameColor.method_27716());
        }
        if (module.valueColor != null) {
            moduleConfig.set("value_color", (Object)module.valueColor.method_27716());
        }
        if (module instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)module;
            if (coordsModule.colorX != null) {
                moduleConfig.set("color_x", (Object)coordsModule.colorX.method_27716());
            }
            if (coordsModule.colorY != null) {
                moduleConfig.set("color_y", (Object)coordsModule.colorY.method_27716());
            }
            if (coordsModule.colorZ != null) {
                moduleConfig.set("color_z", (Object)coordsModule.colorZ.method_27716());
            }
        }
        if (module instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)module;
            if (fpsModule.colorHigh != null) {
                moduleConfig.set("color_high", (Object)fpsModule.colorHigh.method_27716());
            }
            if (fpsModule.colorMed != null) {
                moduleConfig.set("color_med", (Object)fpsModule.colorMed.method_27716());
            }
            if (fpsModule.colorLow != null) {
                moduleConfig.set("color_low", (Object)fpsModule.colorLow.method_27716());
            }
        }
        if (module instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)module;
            moduleConfig.set("empty_lines", (Object)emptyModule.emptyLines);
        }
        if (module instanceof SoundModule) {
            SoundModule soundModule = (SoundModule)module;
            if (soundModule.maximumColor != null) {
                moduleConfig.set("maximum_color", (Object)soundModule.maximumColor.method_27716());
            }
        }
        if (module instanceof EntityModule) {
            EntityModule entityModule = (EntityModule)module;
            if (entityModule.totalColor != null) {
                moduleConfig.set("total_entities_color", (Object)entityModule.totalColor.method_27716());
            }
        }
        if (module instanceof HelpModule) {
            HelpModule helpModule = (HelpModule)module;
            if (helpModule.enabledColor != null) {
                moduleConfig.set("enabled_color", (Object)helpModule.enabledColor.method_27716());
            }
            if (helpModule.disabledColor != null) {
                moduleConfig.set("disabled_color", (Object)helpModule.disabledColor.method_27716());
            }
        }
        if (module instanceof ChunksModule) {
            ChunksModule chunkModule = (ChunksModule)module;
            if (chunkModule.enabledColor != null) {
                moduleConfig.set("chunks_enabled_color", (Object)chunkModule.enabledColor.method_27716());
            }
            if (chunkModule.disabledColor != null) {
                moduleConfig.set("chunks_disabled_color", (Object)chunkModule.disabledColor.method_27716());
            }
            if (chunkModule.totalColor != null) {
                moduleConfig.set("total_chunks_color", (Object)chunkModule.totalColor.method_27716());
            }
        }
        if (module instanceof SystemModule) {
            SystemModule systemModule = (SystemModule)module;
            if (systemModule.memoryColorToggle != null) {
                moduleConfig.set("memory_color_toggle", (Object)systemModule.memoryColorToggle);
            }
            if (systemModule.timeFormat != null) {
                moduleConfig.set("time_format", (Object)systemModule.timeFormat);
            }
        }
        moduleConfig.set("enabled", (Object)module.enabled);
        moduleConfig.set("lines", (Object)lines);
        return moduleConfig;
    }

    static {
        saveRunnable = () -> {
            Object config = FileConfig.builder(Paths.get(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml", new String[0])).concurrent().autosave().build();
            Config general = Config.inMemory();
            general.set("disable_mod", (Object)GeneralOptions.disableMod);
            general.set("auto_start", (Object)GeneralOptions.autoF3);
            general.set("space_modules", (Object)GeneralOptions.spaceEveryModule);
            general.set("shadow_text", (Object)GeneralOptions.shadowText);
            general.set("animations", (Object)GeneralOptions.enableAnimations);
            general.set("animationSpeed", (Object)GeneralOptions.animationSpeed);
            general.set("fontScale", (Object)GeneralOptions.fontScale);
            general.set("background_color", (Object)GeneralOptions.backgroundColor);
            general.set("hide_debug_crosshair", (Object)GeneralOptions.hideDebugCrosshair);
            general.set("hide_sidebar", (Object)GeneralOptions.hideSidebar);
            general.set("hide_bossbar", (Object)GeneralOptions.hideBossbar);
            general.set("always_show_profiler", (Object)GeneralOptions.alwaysEnableProfiler);
            general.set("always_show_tps", (Object)GeneralOptions.alwaysEnableTPS);
            ArrayList<Config> configsLeft = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modules) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsLeft.add(moduleConfig);
            }
            ArrayList<Config> configsRight = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modulesRight) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsRight.add(moduleConfig);
            }
            config.set("modules_left", configsLeft);
            config.set("modules_right", configsRight);
            config.set("general", (Object)general);
            config.close();
        };
    }

    public static enum FileType {
        JSON,
        TOML;

    }
}

