/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.codec;

import com.google.common.collect.BiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.MapBackedCodec;
import dev.shadowsoffire.placebo.codec.NullableFieldCodec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5699;

public class PlaceboCodecs {
    public static <T extends CodecProvider<T>> Codec<T> mapBackedDefaulted(String name, BiMap<class_2960, Codec<? extends T>> reg, Codec<? extends T> defaultCodec) {
        return new MapBackedCodec(name, reg, () -> defaultCodec);
    }

    public static <T extends CodecProvider<? super T>> Codec<T> mapBacked(String name, BiMap<class_2960, Codec<? extends T>> reg) {
        return new MapBackedCodec<T>(name, reg);
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> elementCodec) {
        return PlaceboCodecs.setFromList(elementCodec.listOf());
    }

    public static <T> Codec<Set<T>> setFromList(Codec<List<T>> listCodec) {
        return listCodec.xmap(HashSet::new, ArrayList::new);
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> clazz) {
        return class_5699.method_39508(e -> e.name().toLowerCase(Locale.ROOT), name -> Enum.valueOf(clazz, name.toUpperCase(Locale.ROOT)));
    }

    public static <T extends class_3542> Codec<T> stringResolver(Function<String, T> decoder) {
        return class_5699.method_39508(class_3542::method_15434, decoder);
    }

    public static <A> MapCodec<Optional<A>> nullableField(Codec<A> elementCodec, String name) {
        return new NullableFieldCodec<A>(name, elementCodec);
    }

    public static <A> MapCodec<A> nullableField(Codec<A> elementCodec, String name, A defaultValue) {
        return PlaceboCodecs.nullableField(elementCodec, name).xmap(o -> o.orElse(defaultValue), Optional::ofNullable);
    }
}

