/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.patreon;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.PlaceboClient;
import dev.shadowsoffire.placebo.packets.PatreonDisableMessage;
import dev.shadowsoffire.placebo.patreon.PatreonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class TrailsManager {
    public static Map<UUID, PatreonUtils.PatreonParticleType> TRAILS = new HashMap<UUID, PatreonUtils.PatreonParticleType>();
    public static final Set<UUID> DISABLED = new HashSet<UUID>();

    public static void init() {
        new Thread(() -> {
            Placebo.LOGGER.info("Loading patreon trails data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/TheWinABagel/FakerLib/master/TestTrails.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Placebo.LOGGER.error("Invalid patreon trail entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        TRAILS.put(UUID.fromString(split[0]), PatreonUtils.PatreonParticleType.valueOf(split[1]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Placebo.LOGGER.error("Exception loading patreon trails data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Placebo.LOGGER.info("Loaded {} patreon trails.", (Object)TRAILS.size());
        }, "Placebo (FakerLib) Patreon Trail Loader").start();
    }

    public static void clientTick() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            PatreonUtils.PatreonParticleType t = null;
            if (class_310.method_1551().field_1687 != null) {
                for (class_1657 player : class_310.method_1551().field_1687.method_18456()) {
                    if (player.method_5767() || player.field_6012 * 3 % 2 != 0 || DISABLED.contains(player.method_5667()) || (t = TRAILS.get(player.method_5667())) == null) continue;
                    class_638 world = (class_638)player.method_37908();
                    class_5819 rand = world.field_9229;
                    class_2394 type = t.type.get();
                    world.method_8406(type, player.method_23317() + rand.method_43058() * 0.4 - 0.2, player.method_23318() + 0.1, player.method_23321() + rand.method_43058() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                }
            }
        });
    }

    public static void keys() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (PlaceboClient.TOGGLE_TRAILS.method_1436()) {
                PatreonDisableMessage.sendToServer(new PatreonDisableMessage(0, client.field_1724.method_5667()));
            }
        });
    }
}

