/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.events.ReloadableServerEvent;
import dev.shadowsoffire.placebo.events.ServerEvents;
import dev.shadowsoffire.placebo.json.JsonUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.RegistryCallback;
import dev.shadowsoffire.placebo.reload.ReloadListenerPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicRegistry<R extends CodecProvider<? super R>>
extends class_4309 {
    public static final class_2960 DEFAULT = new class_2960("default");
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final CodecMap<R> codecs;
    protected final Codec<DynamicHolder<R>> holderCodec;
    protected BiMap<class_2960, R> registry = ImmutableBiMap.of();
    private final Map<class_2960, R> staged = new HashMap<class_2960, R>();
    private final Map<class_2960, DynamicHolder<? extends R>> holders = new ConcurrentHashMap<class_2960, DynamicHolder<? extends R>>();
    private final Set<RegistryCallback<R>> callbacks = new HashSet<RegistryCallback<R>>();
    class_2960 id = new class_2960("fakerlib", "packet");

    public DynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.codecs = new CodecMap(path);
        this.registerBuiltinCodecs();
        if (this.codecs.isEmpty()) {
            throw new RuntimeException("Attempted to create a dynamic registry for " + path + " with no built-in codecs!");
        }
        this.holderCodec = class_2960.field_25139.xmap(this::holder, DynamicHolder::getId);
    }

    protected final void apply(Map<class_2960, JsonElement> objects, class_3300 pResourceManager, class_3695 pProfiler) {
        this.beginReload();
        objects.forEach((key, ele) -> {
            try {
                if (JsonUtil.checkAndLogEmpty(ele, key, this.path, this.logger) && JsonUtil.checkConditions(ele, key, this.path, this.logger)) {
                    JsonObject obj = ele.getAsJsonObject();
                    CodecProvider deserialized = (CodecProvider)((Pair)this.codecs.decode(JsonOps.INSTANCE, obj).getOrThrow(false, this::logCodecError)).getFirst();
                    Preconditions.checkNotNull(deserialized.getCodec(), (Object)("A " + this.path + " with id " + key + " is not declaring a codec."));
                    Preconditions.checkNotNull((Object)this.codecs.getKey(deserialized.getCodec()), (Object)("A " + this.path + " with id " + key + " is declaring an unregistered codec."));
                    this.register((class_2960)key, (R)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                this.logger.error("Underlying Exception: ", (Throwable)e);
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinCodecs();

    protected void beginReload() {
        this.callbacks.forEach(l -> l.beginReload(this));
        this.registry = HashBiMap.create();
        this.holders.values().forEach(DynamicHolder::unbind);
    }

    protected void onReload() {
        this.registry = ImmutableBiMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
        this.callbacks.forEach(l -> l.onReload(this));
        this.holders.values().forEach(DynamicHolder::bind);
    }

    public Set<class_2960> getKeys() {
        return this.registry.keySet();
    }

    public Collection<R> getValues() {
        return this.registry.values();
    }

    @Nullable
    public R getValue(class_2960 key) {
        return (R)((CodecProvider)this.registry.get((Object)key));
    }

    @Nullable
    public class_2960 getKey(R value) {
        return (class_2960)this.registry.inverse().get(value);
    }

    public R getOrDefault(class_2960 key, R defValue) {
        return (R)((CodecProvider)this.registry.getOrDefault((Object)key, defValue));
    }

    public void register() {
        if (this.synced) {
            SyncManagement.registerForSync(this);
        }
        ReloadableServerEvent.addListeners((class_3302)this);
    }

    public static void sync() {
        SyncManagement.syncAll();
    }

    public <T extends R> DynamicHolder<T> holder(class_2960 id) {
        return this.holders.computeIfAbsent(id, k -> new DynamicHolder(this, (class_2960)k));
    }

    public <T extends R> DynamicHolder<T> holder(T t) {
        class_2960 key = this.getKey(t);
        return this.holder((T)(key == null ? DynamicHolder.EMPTY : key));
    }

    public DynamicHolder<R> emptyHolder() {
        return this.holder((Object)DynamicHolder.EMPTY);
    }

    public Codec<DynamicHolder<R>> holderCodec() {
        return this.holderCodec;
    }

    public final void registerCodec(class_2960 key, Codec<? extends R> codec) {
        if (!this.subtypes) {
            throw new UnsupportedOperationException("Attempted to call registerCodec on a registry which does not support subtypes.");
        }
        this.codecs.register(key, codec);
    }

    protected final void registerDefaultCodec(class_2960 key, Codec<? extends R> codec) {
        if (this.codecs.getDefaultCodec() != null) {
            throw new UnsupportedOperationException("Attempted to register a second " + this.path + " default codec with key " + key + " but subtypes are not supported!");
        }
        this.codecs.register(key, codec);
        this.codecs.setDefaultCodec(codec);
    }

    public final boolean addCallback(RegistryCallback<R> callback) {
        return this.callbacks.add(callback);
    }

    public final boolean removeCallback(RegistryCallback<R> callback) {
        return this.callbacks.remove(callback);
    }

    protected final void register(class_2960 key, R value) {
        if (this.registry.containsKey((Object)key)) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a duplicate registry ID! Key: " + key);
        }
        this.validateItem(key, value);
        this.registry.put((Object)key, value);
        this.holders.computeIfAbsent(key, k -> new DynamicHolder(this, (class_2960)k));
    }

    protected void validateItem(class_2960 key, R value) {
    }

    private void pushStagedToLive() {
        this.beginReload();
        this.staged.forEach(this::register);
        this.onReload();
    }

    private void logCodecError(String msg) {
        Placebo.LOGGER.error("Codec failure for type {}, message: {}", (Object)this.path, (Object)msg);
    }

    private void sync(class_1657 player) {
        class_3222 sp = (class_3222)player;
        if (player == null) {
            ReloadListenerPacket.Start.sendToAll(this.path);
            this.registry.forEach((k, v) -> ReloadListenerPacket.Content.Provider.sendToAll(this.path, k, v));
            ReloadListenerPacket.End.sendToAll(this.path);
        } else {
            ReloadListenerPacket.Start.sendTo(sp, this.path);
            this.registry.forEach((k, v) -> ReloadListenerPacket.Content.Provider.sendTo(sp, this.path, k, v));
            ReloadListenerPacket.End.sendTo(sp, this.path);
        }
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.createS2CPacket((class_2960)this.id, (class_2540)buf);
        ReloadListenerPacket.Start.init(sp, this.path);
    }

    @ApiStatus.Internal
    static class SyncManagement {
        private static final Map<String, DynamicRegistry<?>> SYNC_REGISTRY = new LinkedHashMap();

        SyncManagement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerForSync(DynamicRegistry<?> listener) {
            if (!listener.synced) {
                throw new UnsupportedOperationException("Attempted to register the non-synced JSON Reload Listener " + listener.path + " as a synced listener!");
            }
            Map<String, DynamicRegistry<?>> map = SYNC_REGISTRY;
            synchronized (map) {
                if (SYNC_REGISTRY.containsKey(listener.path)) {
                    throw new UnsupportedOperationException("Attempted to register the JSON Reload Listener for syncing " + listener.path + " but one already exists!");
                }
                if (SYNC_REGISTRY.isEmpty()) {
                    SyncManagement.syncAll();
                }
                SYNC_REGISTRY.put(listener.path, listener);
            }
        }

        static void initSync(String path) {
            SyncManagement.ifPresent(path, registry -> registry.staged.clear());
        }

        static <V extends CodecProvider<? super V>> void writeItem(String path, V value, class_2540 buf) {
            SyncManagement.ifPresent(path, registry -> {
                CodecMap c = registry.codecs;
                buf.method_10794((class_2487)c.encodeStart((DynamicOps)class_2509.field_11560, value).getOrThrow(false, registry::logCodecError));
            });
        }

        static <V> V readItem(String path, class_2540 buf) {
            DynamicRegistry<?> registry = SYNC_REGISTRY.get(path);
            if (registry == null) {
                throw new RuntimeException("Received sync packet for unknown registry!");
            }
            CodecMap c = registry.codecs;
            return (V)((Pair)c.decode((DynamicOps)class_2509.field_11560, buf.method_10798()).getOrThrow(false, registry::logCodecError)).getFirst();
        }

        static <V> void acceptItem(String path, class_2960 key, V value) {
            SyncManagement.ifPresent(path, registry -> registry.staged.put(key, value));
        }

        static void endSync(String path) {
            if (ServerEvents.getCurrentServer() != null) {
                return;
            }
            SyncManagement.ifPresent(path, DynamicRegistry::pushStagedToLive);
        }

        private static void ifPresent(String path, Consumer<DynamicRegistry<?>> consumer) {
            DynamicRegistry<?> value = SYNC_REGISTRY.get(path);
            if (value != null) {
                consumer.accept(value);
            }
        }

        public static void syncAll() {
            ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> SYNC_REGISTRY.values().forEach(r -> r.sync((class_1657)player)));
        }
    }

    public static class WrappedStateAwareListener
    implements class_3302 {
        private final class_3302 wrapped;

        public WrappedStateAwareListener(class_3302 wrapped) {
            this.wrapped = wrapped;
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.wrapped.method_25931(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }
    }
}

